package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  DateTime,
  BaselineDescription,
  BaselineName,
  BaselineId,
  PatchId,
  PatchGroup
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class GetPatchBaselineResponse(
    baselineId: Option[BaselineId] = None,
    name: Option[BaselineName] = None,
    operatingSystem: Option[zio.aws.ssm.model.OperatingSystem] = None,
    globalFilters: Option[zio.aws.ssm.model.PatchFilterGroup] = None,
    approvalRules: Option[zio.aws.ssm.model.PatchRuleGroup] = None,
    approvedPatches: Option[Iterable[PatchId]] = None,
    approvedPatchesComplianceLevel: Option[
      zio.aws.ssm.model.PatchComplianceLevel
    ] = None,
    approvedPatchesEnableNonSecurity: Option[Boolean] = None,
    rejectedPatches: Option[Iterable[PatchId]] = None,
    rejectedPatchesAction: Option[zio.aws.ssm.model.PatchAction] = None,
    patchGroups: Option[Iterable[PatchGroup]] = None,
    createdDate: Option[DateTime] = None,
    modifiedDate: Option[DateTime] = None,
    description: Option[BaselineDescription] = None,
    sources: Option[Iterable[zio.aws.ssm.model.PatchSource]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetPatchBaselineResponse = {
    import GetPatchBaselineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetPatchBaselineResponse
      .builder()
      .optionallyWith(
        baselineId.map(value => BaselineId.unwrap(value): java.lang.String)
      )(_.baselineId)
      .optionallyWith(
        name.map(value => BaselineName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(operatingSystem.map(value => value.unwrap))(
        _.operatingSystem
      )
      .optionallyWith(globalFilters.map(value => value.buildAwsValue()))(
        _.globalFilters
      )
      .optionallyWith(approvalRules.map(value => value.buildAwsValue()))(
        _.approvalRules
      )
      .optionallyWith(
        approvedPatches.map(value =>
          value.map { item =>
            PatchId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.approvedPatches)
      .optionallyWith(
        approvedPatchesComplianceLevel.map(value => value.unwrap)
      )(_.approvedPatchesComplianceLevel)
      .optionallyWith(
        approvedPatchesEnableNonSecurity.map(value => value: java.lang.Boolean)
      )(_.approvedPatchesEnableNonSecurity)
      .optionallyWith(
        rejectedPatches.map(value =>
          value.map { item =>
            PatchId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.rejectedPatches)
      .optionallyWith(rejectedPatchesAction.map(value => value.unwrap))(
        _.rejectedPatchesAction
      )
      .optionallyWith(
        patchGroups.map(value =>
          value.map { item =>
            PatchGroup.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.patchGroups)
      .optionallyWith(
        createdDate.map(value => DateTime.unwrap(value): Instant)
      )(_.createdDate)
      .optionallyWith(
        modifiedDate.map(value => DateTime.unwrap(value): Instant)
      )(_.modifiedDate)
      .optionallyWith(
        description.map(value =>
          BaselineDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        sources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sources)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.GetPatchBaselineResponse.ReadOnly =
    zio.aws.ssm.model.GetPatchBaselineResponse.wrap(buildAwsValue())
}
object GetPatchBaselineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetPatchBaselineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.GetPatchBaselineResponse =
      zio.aws.ssm.model.GetPatchBaselineResponse(
        baselineId.map(value => value),
        name.map(value => value),
        operatingSystem.map(value => value),
        globalFilters.map(value => value.asEditable),
        approvalRules.map(value => value.asEditable),
        approvedPatches.map(value => value),
        approvedPatchesComplianceLevel.map(value => value),
        approvedPatchesEnableNonSecurity.map(value => value),
        rejectedPatches.map(value => value),
        rejectedPatchesAction.map(value => value),
        patchGroups.map(value => value),
        createdDate.map(value => value),
        modifiedDate.map(value => value),
        description.map(value => value),
        sources.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def baselineId: Option[BaselineId]
    def name: Option[BaselineName]
    def operatingSystem: Option[zio.aws.ssm.model.OperatingSystem]
    def globalFilters: Option[zio.aws.ssm.model.PatchFilterGroup.ReadOnly]
    def approvalRules: Option[zio.aws.ssm.model.PatchRuleGroup.ReadOnly]
    def approvedPatches: Option[List[PatchId]]
    def approvedPatchesComplianceLevel
        : Option[zio.aws.ssm.model.PatchComplianceLevel]
    def approvedPatchesEnableNonSecurity: Option[Boolean]
    def rejectedPatches: Option[List[PatchId]]
    def rejectedPatchesAction: Option[zio.aws.ssm.model.PatchAction]
    def patchGroups: Option[List[PatchGroup]]
    def createdDate: Option[DateTime]
    def modifiedDate: Option[DateTime]
    def description: Option[BaselineDescription]
    def sources: Option[List[zio.aws.ssm.model.PatchSource.ReadOnly]]
    def getBaselineId: ZIO[Any, AwsError, BaselineId] =
      AwsError.unwrapOptionField("baselineId", baselineId)
    def getName: ZIO[Any, AwsError, BaselineName] =
      AwsError.unwrapOptionField("name", name)
    def getOperatingSystem
        : ZIO[Any, AwsError, zio.aws.ssm.model.OperatingSystem] =
      AwsError.unwrapOptionField("operatingSystem", operatingSystem)
    def getGlobalFilters
        : ZIO[Any, AwsError, zio.aws.ssm.model.PatchFilterGroup.ReadOnly] =
      AwsError.unwrapOptionField("globalFilters", globalFilters)
    def getApprovalRules
        : ZIO[Any, AwsError, zio.aws.ssm.model.PatchRuleGroup.ReadOnly] =
      AwsError.unwrapOptionField("approvalRules", approvalRules)
    def getApprovedPatches: ZIO[Any, AwsError, List[PatchId]] =
      AwsError.unwrapOptionField("approvedPatches", approvedPatches)
    def getApprovedPatchesComplianceLevel
        : ZIO[Any, AwsError, zio.aws.ssm.model.PatchComplianceLevel] =
      AwsError.unwrapOptionField(
        "approvedPatchesComplianceLevel",
        approvedPatchesComplianceLevel
      )
    def getApprovedPatchesEnableNonSecurity: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "approvedPatchesEnableNonSecurity",
        approvedPatchesEnableNonSecurity
      )
    def getRejectedPatches: ZIO[Any, AwsError, List[PatchId]] =
      AwsError.unwrapOptionField("rejectedPatches", rejectedPatches)
    def getRejectedPatchesAction
        : ZIO[Any, AwsError, zio.aws.ssm.model.PatchAction] =
      AwsError.unwrapOptionField("rejectedPatchesAction", rejectedPatchesAction)
    def getPatchGroups: ZIO[Any, AwsError, List[PatchGroup]] =
      AwsError.unwrapOptionField("patchGroups", patchGroups)
    def getCreatedDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getModifiedDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("modifiedDate", modifiedDate)
    def getDescription: ZIO[Any, AwsError, BaselineDescription] =
      AwsError.unwrapOptionField("description", description)
    def getSources
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.PatchSource.ReadOnly]] =
      AwsError.unwrapOptionField("sources", sources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetPatchBaselineResponse
  ) extends zio.aws.ssm.model.GetPatchBaselineResponse.ReadOnly {
    override val baselineId: Option[BaselineId] = scala
      .Option(impl.baselineId())
      .map(value => zio.aws.ssm.model.primitives.BaselineId(value))
    override val name: Option[BaselineName] = scala
      .Option(impl.name())
      .map(value => zio.aws.ssm.model.primitives.BaselineName(value))
    override val operatingSystem: Option[zio.aws.ssm.model.OperatingSystem] =
      scala
        .Option(impl.operatingSystem())
        .map(value => zio.aws.ssm.model.OperatingSystem.wrap(value))
    override val globalFilters
        : Option[zio.aws.ssm.model.PatchFilterGroup.ReadOnly] = scala
      .Option(impl.globalFilters())
      .map(value => zio.aws.ssm.model.PatchFilterGroup.wrap(value))
    override val approvalRules
        : Option[zio.aws.ssm.model.PatchRuleGroup.ReadOnly] = scala
      .Option(impl.approvalRules())
      .map(value => zio.aws.ssm.model.PatchRuleGroup.wrap(value))
    override val approvedPatches: Option[List[PatchId]] = scala
      .Option(impl.approvedPatches())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.primitives.PatchId(item)
        }.toList
      )
    override val approvedPatchesComplianceLevel
        : Option[zio.aws.ssm.model.PatchComplianceLevel] = scala
      .Option(impl.approvedPatchesComplianceLevel())
      .map(value => zio.aws.ssm.model.PatchComplianceLevel.wrap(value))
    override val approvedPatchesEnableNonSecurity: Option[Boolean] = scala
      .Option(impl.approvedPatchesEnableNonSecurity())
      .map(value => value: Boolean)
    override val rejectedPatches: Option[List[PatchId]] = scala
      .Option(impl.rejectedPatches())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.primitives.PatchId(item)
        }.toList
      )
    override val rejectedPatchesAction: Option[zio.aws.ssm.model.PatchAction] =
      scala
        .Option(impl.rejectedPatchesAction())
        .map(value => zio.aws.ssm.model.PatchAction.wrap(value))
    override val patchGroups: Option[List[PatchGroup]] = scala
      .Option(impl.patchGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.primitives.PatchGroup(item)
        }.toList
      )
    override val createdDate: Option[DateTime] = scala
      .Option(impl.createdDate())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val modifiedDate: Option[DateTime] = scala
      .Option(impl.modifiedDate())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val description: Option[BaselineDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.ssm.model.primitives.BaselineDescription(value))
    override val sources: Option[List[zio.aws.ssm.model.PatchSource.ReadOnly]] =
      scala
        .Option(impl.sources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.PatchSource.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetPatchBaselineResponse
  ): zio.aws.ssm.model.GetPatchBaselineResponse.ReadOnly = new Wrapper(impl)
}
