package zio.aws.ssm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetOpsItemResponse(
    opsItem: Option[zio.aws.ssm.model.OpsItem] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetOpsItemResponse = {
    import GetOpsItemResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetOpsItemResponse
      .builder()
      .optionallyWith(opsItem.map(value => value.buildAwsValue()))(_.opsItem)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.GetOpsItemResponse.ReadOnly =
    zio.aws.ssm.model.GetOpsItemResponse.wrap(buildAwsValue())
}
object GetOpsItemResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetOpsItemResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.GetOpsItemResponse = zio.aws.ssm.model
      .GetOpsItemResponse(opsItem.map(value => value.asEditable))
    def opsItem: Option[zio.aws.ssm.model.OpsItem.ReadOnly]
    def getOpsItem: ZIO[Any, AwsError, zio.aws.ssm.model.OpsItem.ReadOnly] =
      AwsError.unwrapOptionField("opsItem", opsItem)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetOpsItemResponse
  ) extends zio.aws.ssm.model.GetOpsItemResponse.ReadOnly {
    override val opsItem: Option[zio.aws.ssm.model.OpsItem.ReadOnly] = scala
      .Option(impl.opsItem())
      .map(value => zio.aws.ssm.model.OpsItem.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetOpsItemResponse
  ): zio.aws.ssm.model.GetOpsItemResponse.ReadOnly = new Wrapper(impl)
}
