package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeInventoryDeletionsResponse(
    inventoryDeletions: Option[
      Iterable[zio.aws.ssm.model.InventoryDeletionStatusItem]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsResponse = {
    import DescribeInventoryDeletionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsResponse
      .builder()
      .optionallyWith(
        inventoryDeletions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inventoryDeletions)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.DescribeInventoryDeletionsResponse.ReadOnly =
    zio.aws.ssm.model.DescribeInventoryDeletionsResponse.wrap(buildAwsValue())
}
object DescribeInventoryDeletionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DescribeInventoryDeletionsResponse =
      zio.aws.ssm.model.DescribeInventoryDeletionsResponse(
        inventoryDeletions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def inventoryDeletions
        : Option[List[zio.aws.ssm.model.InventoryDeletionStatusItem.ReadOnly]]
    def nextToken: Option[NextToken]
    def getInventoryDeletions: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.InventoryDeletionStatusItem.ReadOnly
    ]] = AwsError.unwrapOptionField("inventoryDeletions", inventoryDeletions)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsResponse
  ) extends zio.aws.ssm.model.DescribeInventoryDeletionsResponse.ReadOnly {
    override val inventoryDeletions
        : Option[List[zio.aws.ssm.model.InventoryDeletionStatusItem.ReadOnly]] =
      scala
        .Option(impl.inventoryDeletions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.InventoryDeletionStatusItem.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsResponse
  ): zio.aws.ssm.model.DescribeInventoryDeletionsResponse.ReadOnly =
    new Wrapper(impl)
}
