package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{InstanceCount, StatusName}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AssociationOverview(
    status: Option[StatusName] = None,
    detailedStatus: Option[StatusName] = None,
    associationStatusAggregatedCount: Option[Map[StatusName, InstanceCount]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.AssociationOverview = {
    import AssociationOverview.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.AssociationOverview
      .builder()
      .optionallyWith(
        status.map(value => StatusName.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        detailedStatus.map(value => StatusName.unwrap(value): java.lang.String)
      )(_.detailedStatus)
      .optionallyWith(
        associationStatusAggregatedCount.map(value =>
          value
            .map({ case (key, value) =>
              (StatusName.unwrap(key): java.lang.String) -> (InstanceCount
                .unwrap(value): Integer)
            })
            .asJava
        )
      )(_.associationStatusAggregatedCount)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.AssociationOverview.ReadOnly =
    zio.aws.ssm.model.AssociationOverview.wrap(buildAwsValue())
}
object AssociationOverview {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.AssociationOverview
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.AssociationOverview =
      zio.aws.ssm.model.AssociationOverview(
        status.map(value => value),
        detailedStatus.map(value => value),
        associationStatusAggregatedCount.map(value => value)
      )
    def status: Option[StatusName]
    def detailedStatus: Option[StatusName]
    def associationStatusAggregatedCount: Option[Map[StatusName, InstanceCount]]
    def getStatus: ZIO[Any, AwsError, StatusName] =
      AwsError.unwrapOptionField("status", status)
    def getDetailedStatus: ZIO[Any, AwsError, StatusName] =
      AwsError.unwrapOptionField("detailedStatus", detailedStatus)
    def getAssociationStatusAggregatedCount
        : ZIO[Any, AwsError, Map[StatusName, InstanceCount]] =
      AwsError.unwrapOptionField(
        "associationStatusAggregatedCount",
        associationStatusAggregatedCount
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.AssociationOverview
  ) extends zio.aws.ssm.model.AssociationOverview.ReadOnly {
    override val status: Option[StatusName] = scala
      .Option(impl.status())
      .map(value => zio.aws.ssm.model.primitives.StatusName(value))
    override val detailedStatus: Option[StatusName] = scala
      .Option(impl.detailedStatus())
      .map(value => zio.aws.ssm.model.primitives.StatusName(value))
    override val associationStatusAggregatedCount
        : Option[Map[StatusName, InstanceCount]] = scala
      .Option(impl.associationStatusAggregatedCount())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ssm.model.primitives.StatusName(
              key
            ) -> zio.aws.ssm.model.primitives.InstanceCount(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.AssociationOverview
  ): zio.aws.ssm.model.AssociationOverview.ReadOnly = new Wrapper(impl)
}
