package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.SessionId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TerminateSessionResponse(sessionId: Option[SessionId] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.TerminateSessionResponse = {
    import TerminateSessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.TerminateSessionResponse
      .builder()
      .optionallyWith(
        sessionId.map(value => SessionId.unwrap(value): java.lang.String)
      )(_.sessionId)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.TerminateSessionResponse.ReadOnly =
    zio.aws.ssm.model.TerminateSessionResponse.wrap(buildAwsValue())
}
object TerminateSessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.TerminateSessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.TerminateSessionResponse =
      zio.aws.ssm.model.TerminateSessionResponse(sessionId.map(value => value))
    def sessionId: Option[SessionId]
    def getSessionId: ZIO[Any, AwsError, SessionId] =
      AwsError.unwrapOptionField("sessionId", sessionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.TerminateSessionResponse
  ) extends zio.aws.ssm.model.TerminateSessionResponse.ReadOnly {
    override val sessionId: Option[SessionId] = scala
      .Option(impl.sessionId())
      .map(value => zio.aws.ssm.model.primitives.SessionId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.TerminateSessionResponse
  ): zio.aws.ssm.model.TerminateSessionResponse.ReadOnly = new Wrapper(impl)
}
