package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.ResourceDataSyncOrganizationalUnitId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ResourceDataSyncOrganizationalUnit(
    organizationalUnitId: Option[ResourceDataSyncOrganizationalUnitId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ResourceDataSyncOrganizationalUnit = {
    import ResourceDataSyncOrganizationalUnit.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ResourceDataSyncOrganizationalUnit
      .builder()
      .optionallyWith(
        organizationalUnitId.map(value =>
          ResourceDataSyncOrganizationalUnitId.unwrap(value): java.lang.String
        )
      )(_.organizationalUnitId)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.ResourceDataSyncOrganizationalUnit.ReadOnly =
    zio.aws.ssm.model.ResourceDataSyncOrganizationalUnit.wrap(buildAwsValue())
}
object ResourceDataSyncOrganizationalUnit {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ResourceDataSyncOrganizationalUnit
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ResourceDataSyncOrganizationalUnit =
      zio.aws.ssm.model.ResourceDataSyncOrganizationalUnit(
        organizationalUnitId.map(value => value)
      )
    def organizationalUnitId: Option[ResourceDataSyncOrganizationalUnitId]
    def getOrganizationalUnitId
        : ZIO[Any, AwsError, ResourceDataSyncOrganizationalUnitId] =
      AwsError.unwrapOptionField("organizationalUnitId", organizationalUnitId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ResourceDataSyncOrganizationalUnit
  ) extends zio.aws.ssm.model.ResourceDataSyncOrganizationalUnit.ReadOnly {
    override val organizationalUnitId
        : Option[ResourceDataSyncOrganizationalUnitId] = scala
      .Option(impl.organizationalUnitId())
      .map(value =>
        zio.aws.ssm.model.primitives.ResourceDataSyncOrganizationalUnitId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ResourceDataSyncOrganizationalUnit
  ): zio.aws.ssm.model.ResourceDataSyncOrganizationalUnit.ReadOnly =
    new Wrapper(impl)
}
