package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.PSParameterVersion
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutParameterResponse(
    version: Option[PSParameterVersion] = None,
    tier: Option[zio.aws.ssm.model.ParameterTier] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.PutParameterResponse = {
    import PutParameterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.PutParameterResponse
      .builder()
      .optionallyWith(
        version.map(value => PSParameterVersion.unwrap(value): java.lang.Long)
      )(_.version)
      .optionallyWith(tier.map(value => value.unwrap))(_.tier)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.PutParameterResponse.ReadOnly =
    zio.aws.ssm.model.PutParameterResponse.wrap(buildAwsValue())
}
object PutParameterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.PutParameterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.PutParameterResponse =
      zio.aws.ssm.model.PutParameterResponse(
        version.map(value => value),
        tier.map(value => value)
      )
    def version: Option[PSParameterVersion]
    def tier: Option[zio.aws.ssm.model.ParameterTier]
    def getVersion: ZIO[Any, AwsError, PSParameterVersion] =
      AwsError.unwrapOptionField("version", version)
    def getTier: ZIO[Any, AwsError, zio.aws.ssm.model.ParameterTier] =
      AwsError.unwrapOptionField("tier", tier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.PutParameterResponse
  ) extends zio.aws.ssm.model.PutParameterResponse.ReadOnly {
    override val version: Option[PSParameterVersion] = scala
      .Option(impl.version())
      .map(value => zio.aws.ssm.model.primitives.PSParameterVersion(value))
    override val tier: Option[zio.aws.ssm.model.ParameterTier] = scala
      .Option(impl.tier())
      .map(value => zio.aws.ssm.model.ParameterTier.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.PutParameterResponse
  ): zio.aws.ssm.model.PutParameterResponse.ReadOnly = new Wrapper(impl)
}
