package zio.aws.ssm.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{
  OpsItemId,
  DateTime,
  OpsItemType,
  OpsItemPriority,
  OpsItemSource,
  OpsItemSeverity,
  OpsItemDataKey,
  OpsItemDescription,
  OpsItemTitle,
  OpsItemCategory
}
import scala.jdk.CollectionConverters._
final case class OpsItem(
    createdBy: Option[String] = None,
    opsItemType: Option[OpsItemType] = None,
    createdTime: Option[DateTime] = None,
    description: Option[OpsItemDescription] = None,
    lastModifiedBy: Option[String] = None,
    lastModifiedTime: Option[DateTime] = None,
    notifications: Option[Iterable[zio.aws.ssm.model.OpsItemNotification]] =
      None,
    priority: Option[OpsItemPriority] = None,
    relatedOpsItems: Option[Iterable[zio.aws.ssm.model.RelatedOpsItem]] = None,
    status: Option[zio.aws.ssm.model.OpsItemStatus] = None,
    opsItemId: Option[OpsItemId] = None,
    version: Option[String] = None,
    title: Option[OpsItemTitle] = None,
    source: Option[OpsItemSource] = None,
    operationalData: Option[
      Map[OpsItemDataKey, zio.aws.ssm.model.OpsItemDataValue]
    ] = None,
    category: Option[OpsItemCategory] = None,
    severity: Option[OpsItemSeverity] = None,
    actualStartTime: Option[DateTime] = None,
    actualEndTime: Option[DateTime] = None,
    plannedStartTime: Option[DateTime] = None,
    plannedEndTime: Option[DateTime] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ssm.model.OpsItem = {
    import OpsItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.OpsItem
      .builder()
      .optionallyWith(createdBy.map(value => value: java.lang.String))(
        _.createdBy
      )
      .optionallyWith(
        opsItemType.map(value => OpsItemType.unwrap(value): java.lang.String)
      )(_.opsItemType)
      .optionallyWith(
        createdTime.map(value => DateTime.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        description.map(value =>
          OpsItemDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(lastModifiedBy.map(value => value: java.lang.String))(
        _.lastModifiedBy
      )
      .optionallyWith(
        lastModifiedTime.map(value => DateTime.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        notifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.notifications)
      .optionallyWith(
        priority.map(value => OpsItemPriority.unwrap(value): Integer)
      )(_.priority)
      .optionallyWith(
        relatedOpsItems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.relatedOpsItems)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        opsItemId.map(value => OpsItemId.unwrap(value): java.lang.String)
      )(_.opsItemId)
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .optionallyWith(
        title.map(value => OpsItemTitle.unwrap(value): java.lang.String)
      )(_.title)
      .optionallyWith(
        source.map(value => OpsItemSource.unwrap(value): java.lang.String)
      )(_.source)
      .optionallyWith(
        operationalData.map(value =>
          value
            .map({ case (key, value) =>
              (OpsItemDataKey.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.operationalData)
      .optionallyWith(
        category.map(value => OpsItemCategory.unwrap(value): java.lang.String)
      )(_.category)
      .optionallyWith(
        severity.map(value => OpsItemSeverity.unwrap(value): java.lang.String)
      )(_.severity)
      .optionallyWith(
        actualStartTime.map(value => DateTime.unwrap(value): Instant)
      )(_.actualStartTime)
      .optionallyWith(
        actualEndTime.map(value => DateTime.unwrap(value): Instant)
      )(_.actualEndTime)
      .optionallyWith(
        plannedStartTime.map(value => DateTime.unwrap(value): Instant)
      )(_.plannedStartTime)
      .optionallyWith(
        plannedEndTime.map(value => DateTime.unwrap(value): Instant)
      )(_.plannedEndTime)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.OpsItem.ReadOnly =
    zio.aws.ssm.model.OpsItem.wrap(buildAwsValue())
}
object OpsItem {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ssm.model.OpsItem] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.OpsItem = zio.aws.ssm.model.OpsItem(
      createdBy.map(value => value),
      opsItemType.map(value => value),
      createdTime.map(value => value),
      description.map(value => value),
      lastModifiedBy.map(value => value),
      lastModifiedTime.map(value => value),
      notifications.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      priority.map(value => value),
      relatedOpsItems.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      status.map(value => value),
      opsItemId.map(value => value),
      version.map(value => value),
      title.map(value => value),
      source.map(value => value),
      operationalData.map(value =>
        value.map({ case (key, value) =>
          key -> value.asEditable
        })
      ),
      category.map(value => value),
      severity.map(value => value),
      actualStartTime.map(value => value),
      actualEndTime.map(value => value),
      plannedStartTime.map(value => value),
      plannedEndTime.map(value => value)
    )
    def createdBy: Option[String]
    def opsItemType: Option[OpsItemType]
    def createdTime: Option[DateTime]
    def description: Option[OpsItemDescription]
    def lastModifiedBy: Option[String]
    def lastModifiedTime: Option[DateTime]
    def notifications
        : Option[List[zio.aws.ssm.model.OpsItemNotification.ReadOnly]]
    def priority: Option[OpsItemPriority]
    def relatedOpsItems: Option[List[zio.aws.ssm.model.RelatedOpsItem.ReadOnly]]
    def status: Option[zio.aws.ssm.model.OpsItemStatus]
    def opsItemId: Option[OpsItemId]
    def version: Option[String]
    def title: Option[OpsItemTitle]
    def source: Option[OpsItemSource]
    def operationalData: Option[
      Map[OpsItemDataKey, zio.aws.ssm.model.OpsItemDataValue.ReadOnly]
    ]
    def category: Option[OpsItemCategory]
    def severity: Option[OpsItemSeverity]
    def actualStartTime: Option[DateTime]
    def actualEndTime: Option[DateTime]
    def plannedStartTime: Option[DateTime]
    def plannedEndTime: Option[DateTime]
    def getCreatedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getOpsItemType: ZIO[Any, AwsError, OpsItemType] =
      AwsError.unwrapOptionField("opsItemType", opsItemType)
    def getCreatedTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getDescription: ZIO[Any, AwsError, OpsItemDescription] =
      AwsError.unwrapOptionField("description", description)
    def getLastModifiedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
    def getLastModifiedTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getNotifications: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.OpsItemNotification.ReadOnly
    ]] = AwsError.unwrapOptionField("notifications", notifications)
    def getPriority: ZIO[Any, AwsError, OpsItemPriority] =
      AwsError.unwrapOptionField("priority", priority)
    def getRelatedOpsItems
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.RelatedOpsItem.ReadOnly]] =
      AwsError.unwrapOptionField("relatedOpsItems", relatedOpsItems)
    def getStatus: ZIO[Any, AwsError, zio.aws.ssm.model.OpsItemStatus] =
      AwsError.unwrapOptionField("status", status)
    def getOpsItemId: ZIO[Any, AwsError, OpsItemId] =
      AwsError.unwrapOptionField("opsItemId", opsItemId)
    def getVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("version", version)
    def getTitle: ZIO[Any, AwsError, OpsItemTitle] =
      AwsError.unwrapOptionField("title", title)
    def getSource: ZIO[Any, AwsError, OpsItemSource] =
      AwsError.unwrapOptionField("source", source)
    def getOperationalData: ZIO[Any, AwsError, Map[
      OpsItemDataKey,
      zio.aws.ssm.model.OpsItemDataValue.ReadOnly
    ]] = AwsError.unwrapOptionField("operationalData", operationalData)
    def getCategory: ZIO[Any, AwsError, OpsItemCategory] =
      AwsError.unwrapOptionField("category", category)
    def getSeverity: ZIO[Any, AwsError, OpsItemSeverity] =
      AwsError.unwrapOptionField("severity", severity)
    def getActualStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("actualStartTime", actualStartTime)
    def getActualEndTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("actualEndTime", actualEndTime)
    def getPlannedStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("plannedStartTime", plannedStartTime)
    def getPlannedEndTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("plannedEndTime", plannedEndTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.OpsItem
  ) extends zio.aws.ssm.model.OpsItem.ReadOnly {
    override val createdBy: Option[String] =
      scala.Option(impl.createdBy()).map(value => value: String)
    override val opsItemType: Option[OpsItemType] = scala
      .Option(impl.opsItemType())
      .map(value => zio.aws.ssm.model.primitives.OpsItemType(value))
    override val createdTime: Option[DateTime] = scala
      .Option(impl.createdTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val description: Option[OpsItemDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.ssm.model.primitives.OpsItemDescription(value))
    override val lastModifiedBy: Option[String] =
      scala.Option(impl.lastModifiedBy()).map(value => value: String)
    override val lastModifiedTime: Option[DateTime] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val notifications
        : Option[List[zio.aws.ssm.model.OpsItemNotification.ReadOnly]] = scala
      .Option(impl.notifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.OpsItemNotification.wrap(item)
        }.toList
      )
    override val priority: Option[OpsItemPriority] = scala
      .Option(impl.priority())
      .map(value => zio.aws.ssm.model.primitives.OpsItemPriority(value))
    override val relatedOpsItems
        : Option[List[zio.aws.ssm.model.RelatedOpsItem.ReadOnly]] = scala
      .Option(impl.relatedOpsItems())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.RelatedOpsItem.wrap(item)
        }.toList
      )
    override val status: Option[zio.aws.ssm.model.OpsItemStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.ssm.model.OpsItemStatus.wrap(value))
    override val opsItemId: Option[OpsItemId] = scala
      .Option(impl.opsItemId())
      .map(value => zio.aws.ssm.model.primitives.OpsItemId(value))
    override val version: Option[String] =
      scala.Option(impl.version()).map(value => value: String)
    override val title: Option[OpsItemTitle] = scala
      .Option(impl.title())
      .map(value => zio.aws.ssm.model.primitives.OpsItemTitle(value))
    override val source: Option[OpsItemSource] = scala
      .Option(impl.source())
      .map(value => zio.aws.ssm.model.primitives.OpsItemSource(value))
    override val operationalData: Option[
      Map[OpsItemDataKey, zio.aws.ssm.model.OpsItemDataValue.ReadOnly]
    ] = scala
      .Option(impl.operationalData())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ssm.model.primitives.OpsItemDataKey(
              key
            ) -> zio.aws.ssm.model.OpsItemDataValue.wrap(value)
          })
          .toMap
      )
    override val category: Option[OpsItemCategory] = scala
      .Option(impl.category())
      .map(value => zio.aws.ssm.model.primitives.OpsItemCategory(value))
    override val severity: Option[OpsItemSeverity] = scala
      .Option(impl.severity())
      .map(value => zio.aws.ssm.model.primitives.OpsItemSeverity(value))
    override val actualStartTime: Option[DateTime] = scala
      .Option(impl.actualStartTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val actualEndTime: Option[DateTime] = scala
      .Option(impl.actualEndTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val plannedStartTime: Option[DateTime] = scala
      .Option(impl.plannedStartTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val plannedEndTime: Option[DateTime] = scala
      .Option(impl.plannedEndTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.OpsItem
  ): zio.aws.ssm.model.OpsItem.ReadOnly = new Wrapper(impl)
}
