package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListCommandInvocationsResponse(
    commandInvocations: Option[Iterable[zio.aws.ssm.model.CommandInvocation]] =
      None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ListCommandInvocationsResponse = {
    import ListCommandInvocationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ListCommandInvocationsResponse
      .builder()
      .optionallyWith(
        commandInvocations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.commandInvocations)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ListCommandInvocationsResponse.ReadOnly =
    zio.aws.ssm.model.ListCommandInvocationsResponse.wrap(buildAwsValue())
}
object ListCommandInvocationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ListCommandInvocationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ListCommandInvocationsResponse =
      zio.aws.ssm.model.ListCommandInvocationsResponse(
        commandInvocations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def commandInvocations
        : Option[List[zio.aws.ssm.model.CommandInvocation.ReadOnly]]
    def nextToken: Option[NextToken]
    def getCommandInvocations: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.CommandInvocation.ReadOnly
    ]] = AwsError.unwrapOptionField("commandInvocations", commandInvocations)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ListCommandInvocationsResponse
  ) extends zio.aws.ssm.model.ListCommandInvocationsResponse.ReadOnly {
    override val commandInvocations
        : Option[List[zio.aws.ssm.model.CommandInvocation.ReadOnly]] = scala
      .Option(impl.commandInvocations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.CommandInvocation.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ListCommandInvocationsResponse
  ): zio.aws.ssm.model.ListCommandInvocationsResponse.ReadOnly = new Wrapper(
    impl
  )
}
