package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  InventoryResultItemKey,
  InventoryResultEntityId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InventoryResultEntity(
    id: Option[InventoryResultEntityId] = None,
    data: Option[
      Map[InventoryResultItemKey, zio.aws.ssm.model.InventoryResultItem]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.InventoryResultEntity = {
    import InventoryResultEntity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.InventoryResultEntity
      .builder()
      .optionallyWith(
        id.map(value => InventoryResultEntityId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        data.map(value =>
          value
            .map({ case (key, value) =>
              (InventoryResultItemKey.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.data)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.InventoryResultEntity.ReadOnly =
    zio.aws.ssm.model.InventoryResultEntity.wrap(buildAwsValue())
}
object InventoryResultEntity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.InventoryResultEntity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.InventoryResultEntity =
      zio.aws.ssm.model.InventoryResultEntity(
        id.map(value => value),
        data.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def id: Option[InventoryResultEntityId]
    def data: Option[Map[
      InventoryResultItemKey,
      zio.aws.ssm.model.InventoryResultItem.ReadOnly
    ]]
    def getId: ZIO[Any, AwsError, InventoryResultEntityId] =
      AwsError.unwrapOptionField("id", id)
    def getData: ZIO[Any, AwsError, Map[
      InventoryResultItemKey,
      zio.aws.ssm.model.InventoryResultItem.ReadOnly
    ]] = AwsError.unwrapOptionField("data", data)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.InventoryResultEntity
  ) extends zio.aws.ssm.model.InventoryResultEntity.ReadOnly {
    override val id: Option[InventoryResultEntityId] = scala
      .Option(impl.id())
      .map(value => zio.aws.ssm.model.primitives.InventoryResultEntityId(value))
    override val data: Option[Map[
      InventoryResultItemKey,
      zio.aws.ssm.model.InventoryResultItem.ReadOnly
    ]] = scala
      .Option(impl.data())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ssm.model.primitives.InventoryResultItemKey(
              key
            ) -> zio.aws.ssm.model.InventoryResultItem.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.InventoryResultEntity
  ): zio.aws.ssm.model.InventoryResultEntity.ReadOnly = new Wrapper(impl)
}
