package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetParameterHistoryResponse(
    parameters: Option[Iterable[zio.aws.ssm.model.ParameterHistory]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetParameterHistoryResponse = {
    import GetParameterHistoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetParameterHistoryResponse
      .builder()
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.GetParameterHistoryResponse.ReadOnly =
    zio.aws.ssm.model.GetParameterHistoryResponse.wrap(buildAwsValue())
}
object GetParameterHistoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetParameterHistoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.GetParameterHistoryResponse =
      zio.aws.ssm.model.GetParameterHistoryResponse(
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def parameters: Option[List[zio.aws.ssm.model.ParameterHistory.ReadOnly]]
    def nextToken: Option[NextToken]
    def getParameters: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.ParameterHistory.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetParameterHistoryResponse
  ) extends zio.aws.ssm.model.GetParameterHistoryResponse.ReadOnly {
    override val parameters
        : Option[List[zio.aws.ssm.model.ParameterHistory.ReadOnly]] = scala
      .Option(impl.parameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.ParameterHistory.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetParameterHistoryResponse
  ): zio.aws.ssm.model.GetParameterHistoryResponse.ReadOnly = new Wrapper(impl)
}
