package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.SessionTarget
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetConnectionStatusResponse(
    target: Option[SessionTarget] = None,
    status: Option[zio.aws.ssm.model.ConnectionStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetConnectionStatusResponse = {
    import GetConnectionStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetConnectionStatusResponse
      .builder()
      .optionallyWith(
        target.map(value => SessionTarget.unwrap(value): java.lang.String)
      )(_.target)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.GetConnectionStatusResponse.ReadOnly =
    zio.aws.ssm.model.GetConnectionStatusResponse.wrap(buildAwsValue())
}
object GetConnectionStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetConnectionStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.GetConnectionStatusResponse =
      zio.aws.ssm.model.GetConnectionStatusResponse(
        target.map(value => value),
        status.map(value => value)
      )
    def target: Option[SessionTarget]
    def status: Option[zio.aws.ssm.model.ConnectionStatus]
    def getTarget: ZIO[Any, AwsError, SessionTarget] =
      AwsError.unwrapOptionField("target", target)
    def getStatus: ZIO[Any, AwsError, zio.aws.ssm.model.ConnectionStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetConnectionStatusResponse
  ) extends zio.aws.ssm.model.GetConnectionStatusResponse.ReadOnly {
    override val target: Option[SessionTarget] = scala
      .Option(impl.target())
      .map(value => zio.aws.ssm.model.primitives.SessionTarget(value))
    override val status: Option[zio.aws.ssm.model.ConnectionStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.ssm.model.ConnectionStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetConnectionStatusResponse
  ): zio.aws.ssm.model.GetConnectionStatusResponse.ReadOnly = new Wrapper(impl)
}
