package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  DocumentVersionName,
  DocumentVersion,
  DocumentName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DocumentDefaultVersionDescription(
    name: Option[DocumentName] = None,
    defaultVersion: Option[DocumentVersion] = None,
    defaultVersionName: Option[DocumentVersionName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DocumentDefaultVersionDescription = {
    import DocumentDefaultVersionDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DocumentDefaultVersionDescription
      .builder()
      .optionallyWith(
        name.map(value => DocumentName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        defaultVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.defaultVersion)
      .optionallyWith(
        defaultVersionName.map(value =>
          DocumentVersionName.unwrap(value): java.lang.String
        )
      )(_.defaultVersionName)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DocumentDefaultVersionDescription.ReadOnly =
    zio.aws.ssm.model.DocumentDefaultVersionDescription.wrap(buildAwsValue())
}
object DocumentDefaultVersionDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DocumentDefaultVersionDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DocumentDefaultVersionDescription =
      zio.aws.ssm.model.DocumentDefaultVersionDescription(
        name.map(value => value),
        defaultVersion.map(value => value),
        defaultVersionName.map(value => value)
      )
    def name: Option[DocumentName]
    def defaultVersion: Option[DocumentVersion]
    def defaultVersionName: Option[DocumentVersionName]
    def getName: ZIO[Any, AwsError, DocumentName] =
      AwsError.unwrapOptionField("name", name)
    def getDefaultVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("defaultVersion", defaultVersion)
    def getDefaultVersionName: ZIO[Any, AwsError, DocumentVersionName] =
      AwsError.unwrapOptionField("defaultVersionName", defaultVersionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DocumentDefaultVersionDescription
  ) extends zio.aws.ssm.model.DocumentDefaultVersionDescription.ReadOnly {
    override val name: Option[DocumentName] = scala
      .Option(impl.name())
      .map(value => zio.aws.ssm.model.primitives.DocumentName(value))
    override val defaultVersion: Option[DocumentVersion] = scala
      .Option(impl.defaultVersion())
      .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
    override val defaultVersionName: Option[DocumentVersionName] = scala
      .Option(impl.defaultVersionName())
      .map(value => zio.aws.ssm.model.primitives.DocumentVersionName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DocumentDefaultVersionDescription
  ): zio.aws.ssm.model.DocumentDefaultVersionDescription.ReadOnly = new Wrapper(
    impl
  )
}
