package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{NextToken, AccountId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeDocumentPermissionResponse(
    accountIds: Option[Iterable[AccountId]] = None,
    accountSharingInfoList: Option[
      Iterable[zio.aws.ssm.model.AccountSharingInfo]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeDocumentPermissionResponse = {
    import DescribeDocumentPermissionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeDocumentPermissionResponse
      .builder()
      .optionallyWith(
        accountIds.map(value =>
          value.map { item =>
            AccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.accountIds)
      .optionallyWith(
        accountSharingInfoList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accountSharingInfoList)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.DescribeDocumentPermissionResponse.ReadOnly =
    zio.aws.ssm.model.DescribeDocumentPermissionResponse.wrap(buildAwsValue())
}
object DescribeDocumentPermissionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeDocumentPermissionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DescribeDocumentPermissionResponse =
      zio.aws.ssm.model.DescribeDocumentPermissionResponse(
        accountIds.map(value => value),
        accountSharingInfoList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def accountIds: Option[List[AccountId]]
    def accountSharingInfoList
        : Option[List[zio.aws.ssm.model.AccountSharingInfo.ReadOnly]]
    def nextToken: Option[NextToken]
    def getAccountIds: ZIO[Any, AwsError, List[AccountId]] =
      AwsError.unwrapOptionField("accountIds", accountIds)
    def getAccountSharingInfoList: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.AccountSharingInfo.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "accountSharingInfoList",
      accountSharingInfoList
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeDocumentPermissionResponse
  ) extends zio.aws.ssm.model.DescribeDocumentPermissionResponse.ReadOnly {
    override val accountIds: Option[List[AccountId]] = scala
      .Option(impl.accountIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.primitives.AccountId(item)
        }.toList
      )
    override val accountSharingInfoList
        : Option[List[zio.aws.ssm.model.AccountSharingInfo.ReadOnly]] = scala
      .Option(impl.accountSharingInfoList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.AccountSharingInfo.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeDocumentPermissionResponse
  ): zio.aws.ssm.model.DescribeDocumentPermissionResponse.ReadOnly =
    new Wrapper(impl)
}
