package zio.aws.ssm.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateAssociationBatchRequest(
    entries: Iterable[zio.aws.ssm.model.CreateAssociationBatchRequestEntry]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.CreateAssociationBatchRequest = {
    import CreateAssociationBatchRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.CreateAssociationBatchRequest
      .builder()
      .entries(entries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.CreateAssociationBatchRequest.ReadOnly =
    zio.aws.ssm.model.CreateAssociationBatchRequest.wrap(buildAwsValue())
}
object CreateAssociationBatchRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.CreateAssociationBatchRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.CreateAssociationBatchRequest =
      zio.aws.ssm.model.CreateAssociationBatchRequest(entries.map { item =>
        item.asEditable
      })
    def entries
        : List[zio.aws.ssm.model.CreateAssociationBatchRequestEntry.ReadOnly]
    def getEntries: ZIO[Any, Nothing, List[
      zio.aws.ssm.model.CreateAssociationBatchRequestEntry.ReadOnly
    ]] = ZIO.succeed(entries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.CreateAssociationBatchRequest
  ) extends zio.aws.ssm.model.CreateAssociationBatchRequest.ReadOnly {
    override val entries
        : List[zio.aws.ssm.model.CreateAssociationBatchRequestEntry.ReadOnly] =
      impl
        .entries()
        .asScala
        .map { item =>
          zio.aws.ssm.model.CreateAssociationBatchRequestEntry.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.CreateAssociationBatchRequest
  ): zio.aws.ssm.model.CreateAssociationBatchRequest.ReadOnly = new Wrapper(
    impl
  )
}
