package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  AttachmentIdentifier,
  AttachmentsSourceValue
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AttachmentsSource(
    key: Option[zio.aws.ssm.model.AttachmentsSourceKey] = None,
    values: Option[Iterable[AttachmentsSourceValue]] = None,
    name: Option[AttachmentIdentifier] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.AttachmentsSource = {
    import AttachmentsSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.AttachmentsSource
      .builder()
      .optionallyWith(key.map(value => value.unwrap))(_.key)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            AttachmentsSourceValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .optionallyWith(
        name.map(value => AttachmentIdentifier.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.AttachmentsSource.ReadOnly =
    zio.aws.ssm.model.AttachmentsSource.wrap(buildAwsValue())
}
object AttachmentsSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.AttachmentsSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.AttachmentsSource =
      zio.aws.ssm.model.AttachmentsSource(
        key.map(value => value),
        values.map(value => value),
        name.map(value => value)
      )
    def key: Option[zio.aws.ssm.model.AttachmentsSourceKey]
    def values: Option[List[AttachmentsSourceValue]]
    def name: Option[AttachmentIdentifier]
    def getKey: ZIO[Any, AwsError, zio.aws.ssm.model.AttachmentsSourceKey] =
      AwsError.unwrapOptionField("key", key)
    def getValues: ZIO[Any, AwsError, List[AttachmentsSourceValue]] =
      AwsError.unwrapOptionField("values", values)
    def getName: ZIO[Any, AwsError, AttachmentIdentifier] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.AttachmentsSource
  ) extends zio.aws.ssm.model.AttachmentsSource.ReadOnly {
    override val key: Option[zio.aws.ssm.model.AttachmentsSourceKey] = scala
      .Option(impl.key())
      .map(value => zio.aws.ssm.model.AttachmentsSourceKey.wrap(value))
    override val values: Option[List[AttachmentsSourceValue]] = scala
      .Option(impl.values())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.primitives.AttachmentsSourceValue(item)
        }.toList
      )
    override val name: Option[AttachmentIdentifier] = scala
      .Option(impl.name())
      .map(value => zio.aws.ssm.model.primitives.AttachmentIdentifier(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.AttachmentsSource
  ): zio.aws.ssm.model.AttachmentsSource.ReadOnly = new Wrapper(impl)
}
