package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.OpsItemFilterValue
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class OpsItemFilter(
    key: zio.aws.ssm.model.OpsItemFilterKey,
    values: Iterable[OpsItemFilterValue],
    operator: zio.aws.ssm.model.OpsItemFilterOperator
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.OpsItemFilter = {
    import OpsItemFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.OpsItemFilter
      .builder()
      .key(key.unwrap)
      .values(values.map { item =>
        OpsItemFilterValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .operator(operator.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.OpsItemFilter.ReadOnly =
    zio.aws.ssm.model.OpsItemFilter.wrap(buildAwsValue())
}
object OpsItemFilter {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ssm.model.OpsItemFilter] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.OpsItemFilter =
      zio.aws.ssm.model.OpsItemFilter(key, values, operator)
    def key: zio.aws.ssm.model.OpsItemFilterKey
    def values: List[OpsItemFilterValue]
    def operator: zio.aws.ssm.model.OpsItemFilterOperator
    def getKey: ZIO[Any, Nothing, zio.aws.ssm.model.OpsItemFilterKey] =
      ZIO.succeed(key)
    def getValues: ZIO[Any, Nothing, List[OpsItemFilterValue]] =
      ZIO.succeed(values)
    def getOperator
        : ZIO[Any, Nothing, zio.aws.ssm.model.OpsItemFilterOperator] =
      ZIO.succeed(operator)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.OpsItemFilter
  ) extends zio.aws.ssm.model.OpsItemFilter.ReadOnly {
    override val key: zio.aws.ssm.model.OpsItemFilterKey =
      zio.aws.ssm.model.OpsItemFilterKey.wrap(impl.key())
    override val values: List[OpsItemFilterValue] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.ssm.model.primitives.OpsItemFilterValue(item)
      }
      .toList
    override val operator: zio.aws.ssm.model.OpsItemFilterOperator =
      zio.aws.ssm.model.OpsItemFilterOperator.wrap(impl.operator())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.OpsItemFilter
  ): zio.aws.ssm.model.OpsItemFilter.ReadOnly = new Wrapper(impl)
}
