package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  MaintenanceWindowStringDateTime,
  MaintenanceWindowOffset,
  MaintenanceWindowId,
  MaintenanceWindowTimezone,
  MaintenanceWindowCutoff,
  MaintenanceWindowSchedule,
  MaintenanceWindowDurationHours,
  MaintenanceWindowEnabled,
  MaintenanceWindowName,
  MaintenanceWindowDescription
}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MaintenanceWindowIdentity(
    windowId: Option[MaintenanceWindowId] = None,
    name: Option[MaintenanceWindowName] = None,
    description: Option[MaintenanceWindowDescription] = None,
    enabled: Option[MaintenanceWindowEnabled] = None,
    duration: Option[MaintenanceWindowDurationHours] = None,
    cutoff: Option[MaintenanceWindowCutoff] = None,
    schedule: Option[MaintenanceWindowSchedule] = None,
    scheduleTimezone: Option[MaintenanceWindowTimezone] = None,
    scheduleOffset: Option[MaintenanceWindowOffset] = None,
    endDate: Option[MaintenanceWindowStringDateTime] = None,
    startDate: Option[MaintenanceWindowStringDateTime] = None,
    nextExecutionTime: Option[MaintenanceWindowStringDateTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.MaintenanceWindowIdentity = {
    import MaintenanceWindowIdentity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.MaintenanceWindowIdentity
      .builder()
      .optionallyWith(
        windowId.map(value =>
          MaintenanceWindowId.unwrap(value): java.lang.String
        )
      )(_.windowId)
      .optionallyWith(
        name.map(value => MaintenanceWindowName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          MaintenanceWindowDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        enabled.map(value =>
          MaintenanceWindowEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.enabled)
      .optionallyWith(
        duration.map(value =>
          MaintenanceWindowDurationHours.unwrap(value): Integer
        )
      )(_.duration)
      .optionallyWith(
        cutoff.map(value => MaintenanceWindowCutoff.unwrap(value): Integer)
      )(_.cutoff)
      .optionallyWith(
        schedule.map(value =>
          MaintenanceWindowSchedule.unwrap(value): java.lang.String
        )
      )(_.schedule)
      .optionallyWith(
        scheduleTimezone.map(value =>
          MaintenanceWindowTimezone.unwrap(value): java.lang.String
        )
      )(_.scheduleTimezone)
      .optionallyWith(
        scheduleOffset.map(value =>
          MaintenanceWindowOffset.unwrap(value): Integer
        )
      )(_.scheduleOffset)
      .optionallyWith(
        endDate.map(value =>
          MaintenanceWindowStringDateTime.unwrap(value): java.lang.String
        )
      )(_.endDate)
      .optionallyWith(
        startDate.map(value =>
          MaintenanceWindowStringDateTime.unwrap(value): java.lang.String
        )
      )(_.startDate)
      .optionallyWith(
        nextExecutionTime.map(value =>
          MaintenanceWindowStringDateTime.unwrap(value): java.lang.String
        )
      )(_.nextExecutionTime)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.MaintenanceWindowIdentity.ReadOnly =
    zio.aws.ssm.model.MaintenanceWindowIdentity.wrap(buildAwsValue())
}
object MaintenanceWindowIdentity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.MaintenanceWindowIdentity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.MaintenanceWindowIdentity =
      zio.aws.ssm.model.MaintenanceWindowIdentity(
        windowId.map(value => value),
        name.map(value => value),
        description.map(value => value),
        enabled.map(value => value),
        duration.map(value => value),
        cutoff.map(value => value),
        schedule.map(value => value),
        scheduleTimezone.map(value => value),
        scheduleOffset.map(value => value),
        endDate.map(value => value),
        startDate.map(value => value),
        nextExecutionTime.map(value => value)
      )
    def windowId: Option[MaintenanceWindowId]
    def name: Option[MaintenanceWindowName]
    def description: Option[MaintenanceWindowDescription]
    def enabled: Option[MaintenanceWindowEnabled]
    def duration: Option[MaintenanceWindowDurationHours]
    def cutoff: Option[MaintenanceWindowCutoff]
    def schedule: Option[MaintenanceWindowSchedule]
    def scheduleTimezone: Option[MaintenanceWindowTimezone]
    def scheduleOffset: Option[MaintenanceWindowOffset]
    def endDate: Option[MaintenanceWindowStringDateTime]
    def startDate: Option[MaintenanceWindowStringDateTime]
    def nextExecutionTime: Option[MaintenanceWindowStringDateTime]
    def getWindowId: ZIO[Any, AwsError, MaintenanceWindowId] =
      AwsError.unwrapOptionField("windowId", windowId)
    def getName: ZIO[Any, AwsError, MaintenanceWindowName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, MaintenanceWindowDescription] =
      AwsError.unwrapOptionField("description", description)
    def getEnabled: ZIO[Any, AwsError, MaintenanceWindowEnabled] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getDuration: ZIO[Any, AwsError, MaintenanceWindowDurationHours] =
      AwsError.unwrapOptionField("duration", duration)
    def getCutoff: ZIO[Any, AwsError, MaintenanceWindowCutoff] =
      AwsError.unwrapOptionField("cutoff", cutoff)
    def getSchedule: ZIO[Any, AwsError, MaintenanceWindowSchedule] =
      AwsError.unwrapOptionField("schedule", schedule)
    def getScheduleTimezone: ZIO[Any, AwsError, MaintenanceWindowTimezone] =
      AwsError.unwrapOptionField("scheduleTimezone", scheduleTimezone)
    def getScheduleOffset: ZIO[Any, AwsError, MaintenanceWindowOffset] =
      AwsError.unwrapOptionField("scheduleOffset", scheduleOffset)
    def getEndDate: ZIO[Any, AwsError, MaintenanceWindowStringDateTime] =
      AwsError.unwrapOptionField("endDate", endDate)
    def getStartDate: ZIO[Any, AwsError, MaintenanceWindowStringDateTime] =
      AwsError.unwrapOptionField("startDate", startDate)
    def getNextExecutionTime
        : ZIO[Any, AwsError, MaintenanceWindowStringDateTime] =
      AwsError.unwrapOptionField("nextExecutionTime", nextExecutionTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.MaintenanceWindowIdentity
  ) extends zio.aws.ssm.model.MaintenanceWindowIdentity.ReadOnly {
    override val windowId: Option[MaintenanceWindowId] = scala
      .Option(impl.windowId())
      .map(value => zio.aws.ssm.model.primitives.MaintenanceWindowId(value))
    override val name: Option[MaintenanceWindowName] = scala
      .Option(impl.name())
      .map(value => zio.aws.ssm.model.primitives.MaintenanceWindowName(value))
    override val description: Option[MaintenanceWindowDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.ssm.model.primitives.MaintenanceWindowDescription(value)
      )
    override val enabled: Option[MaintenanceWindowEnabled] = scala
      .Option(impl.enabled())
      .map(value =>
        zio.aws.ssm.model.primitives.MaintenanceWindowEnabled(value)
      )
    override val duration: Option[MaintenanceWindowDurationHours] = scala
      .Option(impl.duration())
      .map(value =>
        zio.aws.ssm.model.primitives.MaintenanceWindowDurationHours(value)
      )
    override val cutoff: Option[MaintenanceWindowCutoff] = scala
      .Option(impl.cutoff())
      .map(value => zio.aws.ssm.model.primitives.MaintenanceWindowCutoff(value))
    override val schedule: Option[MaintenanceWindowSchedule] = scala
      .Option(impl.schedule())
      .map(value =>
        zio.aws.ssm.model.primitives.MaintenanceWindowSchedule(value)
      )
    override val scheduleTimezone: Option[MaintenanceWindowTimezone] = scala
      .Option(impl.scheduleTimezone())
      .map(value =>
        zio.aws.ssm.model.primitives.MaintenanceWindowTimezone(value)
      )
    override val scheduleOffset: Option[MaintenanceWindowOffset] = scala
      .Option(impl.scheduleOffset())
      .map(value => zio.aws.ssm.model.primitives.MaintenanceWindowOffset(value))
    override val endDate: Option[MaintenanceWindowStringDateTime] = scala
      .Option(impl.endDate())
      .map(value =>
        zio.aws.ssm.model.primitives.MaintenanceWindowStringDateTime(value)
      )
    override val startDate: Option[MaintenanceWindowStringDateTime] = scala
      .Option(impl.startDate())
      .map(value =>
        zio.aws.ssm.model.primitives.MaintenanceWindowStringDateTime(value)
      )
    override val nextExecutionTime: Option[MaintenanceWindowStringDateTime] =
      scala
        .Option(impl.nextExecutionTime())
        .map(value =>
          zio.aws.ssm.model.primitives.MaintenanceWindowStringDateTime(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.MaintenanceWindowIdentity
  ): zio.aws.ssm.model.MaintenanceWindowIdentity.ReadOnly = new Wrapper(impl)
}
