package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  MaxResults,
  NextToken,
  ResourceDataSyncType
}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListResourceDataSyncRequest(
    syncType: Option[ResourceDataSyncType] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ListResourceDataSyncRequest = {
    import ListResourceDataSyncRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ListResourceDataSyncRequest
      .builder()
      .optionallyWith(
        syncType.map(value =>
          ResourceDataSyncType.unwrap(value): java.lang.String
        )
      )(_.syncType)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ListResourceDataSyncRequest.ReadOnly =
    zio.aws.ssm.model.ListResourceDataSyncRequest.wrap(buildAwsValue())
}
object ListResourceDataSyncRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ListResourceDataSyncRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ListResourceDataSyncRequest =
      zio.aws.ssm.model.ListResourceDataSyncRequest(
        syncType.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def syncType: Option[ResourceDataSyncType]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getSyncType: ZIO[Any, AwsError, ResourceDataSyncType] =
      AwsError.unwrapOptionField("syncType", syncType)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ListResourceDataSyncRequest
  ) extends zio.aws.ssm.model.ListResourceDataSyncRequest.ReadOnly {
    override val syncType: Option[ResourceDataSyncType] = scala
      .Option(impl.syncType())
      .map(value => zio.aws.ssm.model.primitives.ResourceDataSyncType(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ssm.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ListResourceDataSyncRequest
  ): zio.aws.ssm.model.ListResourceDataSyncRequest.ReadOnly = new Wrapper(impl)
}
