package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{SnapshotId, InstanceId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetDeployablePatchSnapshotForInstanceRequest(
    instanceId: InstanceId,
    snapshotId: SnapshotId,
    baselineOverride: Option[zio.aws.ssm.model.BaselineOverride] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetDeployablePatchSnapshotForInstanceRequest = {
    import GetDeployablePatchSnapshotForInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetDeployablePatchSnapshotForInstanceRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .snapshotId(SnapshotId.unwrap(snapshotId): java.lang.String)
      .optionallyWith(baselineOverride.map(value => value.buildAwsValue()))(
        _.baselineOverride
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.GetDeployablePatchSnapshotForInstanceRequest.ReadOnly =
    zio.aws.ssm.model.GetDeployablePatchSnapshotForInstanceRequest
      .wrap(buildAwsValue())
}
object GetDeployablePatchSnapshotForInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetDeployablePatchSnapshotForInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssm.model.GetDeployablePatchSnapshotForInstanceRequest =
      zio.aws.ssm.model.GetDeployablePatchSnapshotForInstanceRequest(
        instanceId,
        snapshotId,
        baselineOverride.map(value => value.asEditable)
      )
    def instanceId: InstanceId
    def snapshotId: SnapshotId
    def baselineOverride: Option[zio.aws.ssm.model.BaselineOverride.ReadOnly]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getSnapshotId: ZIO[Any, Nothing, SnapshotId] = ZIO.succeed(snapshotId)
    def getBaselineOverride
        : ZIO[Any, AwsError, zio.aws.ssm.model.BaselineOverride.ReadOnly] =
      AwsError.unwrapOptionField("baselineOverride", baselineOverride)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetDeployablePatchSnapshotForInstanceRequest
  ) extends zio.aws.ssm.model.GetDeployablePatchSnapshotForInstanceRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.ssm.model.primitives.InstanceId(impl.instanceId())
    override val snapshotId: SnapshotId =
      zio.aws.ssm.model.primitives.SnapshotId(impl.snapshotId())
    override val baselineOverride
        : Option[zio.aws.ssm.model.BaselineOverride.ReadOnly] = scala
      .Option(impl.baselineOverride())
      .map(value => zio.aws.ssm.model.BaselineOverride.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetDeployablePatchSnapshotForInstanceRequest
  ): zio.aws.ssm.model.GetDeployablePatchSnapshotForInstanceRequest.ReadOnly =
    new Wrapper(impl)
}
