package zio.aws.ssm.model
import scala.jdk.CollectionConverters._
sealed trait DocumentParameterType {
  def unwrap: software.amazon.awssdk.services.ssm.model.DocumentParameterType
}
object DocumentParameterType {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.DocumentParameterType
  ): zio.aws.ssm.model.DocumentParameterType = value match {
    case software.amazon.awssdk.services.ssm.model.DocumentParameterType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.DocumentParameterType.STRING =>
      val r = String
      r
    case software.amazon.awssdk.services.ssm.model.DocumentParameterType.STRING_LIST =>
      val r = StringList
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssm.model.DocumentParameterType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DocumentParameterType =
      software.amazon.awssdk.services.ssm.model.DocumentParameterType.UNKNOWN_TO_SDK_VERSION
  }
  case object String extends zio.aws.ssm.model.DocumentParameterType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DocumentParameterType =
      software.amazon.awssdk.services.ssm.model.DocumentParameterType.STRING
  }
  case object StringList extends zio.aws.ssm.model.DocumentParameterType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DocumentParameterType =
      software.amazon.awssdk.services.ssm.model.DocumentParameterType.STRING_LIST
  }
}
