package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  NextToken,
  CommandMaxResults,
  InstanceId,
  CommandId
}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListCommandInvocationsRequest(
    commandId: Option[CommandId] = None,
    instanceId: Option[InstanceId] = None,
    maxResults: Option[CommandMaxResults] = None,
    nextToken: Option[NextToken] = None,
    filters: Option[Iterable[zio.aws.ssm.model.CommandFilter]] = None,
    details: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ListCommandInvocationsRequest = {
    import ListCommandInvocationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ListCommandInvocationsRequest
      .builder()
      .optionallyWith(
        commandId.map(value => CommandId.unwrap(value): java.lang.String)
      )(_.commandId)
      .optionallyWith(
        instanceId.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.instanceId)
      .optionallyWith(
        maxResults.map(value => CommandMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(details.map(value => value: java.lang.Boolean))(_.details)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ListCommandInvocationsRequest.ReadOnly =
    zio.aws.ssm.model.ListCommandInvocationsRequest.wrap(buildAwsValue())
}
object ListCommandInvocationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ListCommandInvocationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ListCommandInvocationsRequest =
      zio.aws.ssm.model.ListCommandInvocationsRequest(
        commandId.map(value => value),
        instanceId.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        details.map(value => value)
      )
    def commandId: Option[CommandId]
    def instanceId: Option[InstanceId]
    def maxResults: Option[CommandMaxResults]
    def nextToken: Option[NextToken]
    def filters: Option[List[zio.aws.ssm.model.CommandFilter.ReadOnly]]
    def details: Option[Boolean]
    def getCommandId: ZIO[Any, AwsError, CommandId] =
      AwsError.unwrapOptionField("commandId", commandId)
    def getInstanceId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getMaxResults: ZIO[Any, AwsError, CommandMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.CommandFilter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getDetails: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("details", details)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ListCommandInvocationsRequest
  ) extends zio.aws.ssm.model.ListCommandInvocationsRequest.ReadOnly {
    override val commandId: Option[CommandId] = scala
      .Option(impl.commandId())
      .map(value => zio.aws.ssm.model.primitives.CommandId(value))
    override val instanceId: Option[InstanceId] = scala
      .Option(impl.instanceId())
      .map(value => zio.aws.ssm.model.primitives.InstanceId(value))
    override val maxResults: Option[CommandMaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ssm.model.primitives.CommandMaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
    override val filters
        : Option[List[zio.aws.ssm.model.CommandFilter.ReadOnly]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.CommandFilter.wrap(item)
        }.toList
      )
    override val details: Option[Boolean] =
      scala.Option(impl.details()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ListCommandInvocationsRequest
  ): zio.aws.ssm.model.ListCommandInvocationsRequest.ReadOnly = new Wrapper(
    impl
  )
}
