package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  RemainingCount,
  ResourceCount,
  InventoryItemSchemaVersion
}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InventoryDeletionSummaryItem(
    version: Option[InventoryItemSchemaVersion] = None,
    count: Option[ResourceCount] = None,
    remainingCount: Option[RemainingCount] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.InventoryDeletionSummaryItem = {
    import InventoryDeletionSummaryItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.InventoryDeletionSummaryItem
      .builder()
      .optionallyWith(
        version.map(value =>
          InventoryItemSchemaVersion.unwrap(value): java.lang.String
        )
      )(_.version)
      .optionallyWith(count.map(value => ResourceCount.unwrap(value): Integer))(
        _.count
      )
      .optionallyWith(
        remainingCount.map(value => RemainingCount.unwrap(value): Integer)
      )(_.remainingCount)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.InventoryDeletionSummaryItem.ReadOnly =
    zio.aws.ssm.model.InventoryDeletionSummaryItem.wrap(buildAwsValue())
}
object InventoryDeletionSummaryItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.InventoryDeletionSummaryItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.InventoryDeletionSummaryItem =
      zio.aws.ssm.model.InventoryDeletionSummaryItem(
        version.map(value => value),
        count.map(value => value),
        remainingCount.map(value => value)
      )
    def version: Option[InventoryItemSchemaVersion]
    def count: Option[ResourceCount]
    def remainingCount: Option[RemainingCount]
    def getVersion: ZIO[Any, AwsError, InventoryItemSchemaVersion] =
      AwsError.unwrapOptionField("version", version)
    def getCount: ZIO[Any, AwsError, ResourceCount] =
      AwsError.unwrapOptionField("count", count)
    def getRemainingCount: ZIO[Any, AwsError, RemainingCount] =
      AwsError.unwrapOptionField("remainingCount", remainingCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.InventoryDeletionSummaryItem
  ) extends zio.aws.ssm.model.InventoryDeletionSummaryItem.ReadOnly {
    override val version: Option[InventoryItemSchemaVersion] = scala
      .Option(impl.version())
      .map(value =>
        zio.aws.ssm.model.primitives.InventoryItemSchemaVersion(value)
      )
    override val count: Option[ResourceCount] = scala
      .Option(impl.count())
      .map(value => zio.aws.ssm.model.primitives.ResourceCount(value))
    override val remainingCount: Option[RemainingCount] = scala
      .Option(impl.remainingCount())
      .map(value => zio.aws.ssm.model.primitives.RemainingCount(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.InventoryDeletionSummaryItem
  ): zio.aws.ssm.model.InventoryDeletionSummaryItem.ReadOnly = new Wrapper(impl)
}
