package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  AutomationParameterValue,
  AutomationParameterKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FailureDetails(
    failureStage: Option[String] = None,
    failureType: Option[String] = None,
    details: Option[
      Map[AutomationParameterKey, Iterable[AutomationParameterValue]]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.FailureDetails = {
    import FailureDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.FailureDetails
      .builder()
      .optionallyWith(failureStage.map(value => value: java.lang.String))(
        _.failureStage
      )
      .optionallyWith(failureType.map(value => value: java.lang.String))(
        _.failureType
      )
      .optionallyWith(
        details.map(value =>
          value
            .map({ case (key, value) =>
              (AutomationParameterKey
                .unwrap(key): java.lang.String) -> value.map { item =>
                AutomationParameterValue.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.details)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.FailureDetails.ReadOnly =
    zio.aws.ssm.model.FailureDetails.wrap(buildAwsValue())
}
object FailureDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.FailureDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.FailureDetails =
      zio.aws.ssm.model.FailureDetails(
        failureStage.map(value => value),
        failureType.map(value => value),
        details.map(value => value)
      )
    def failureStage: Option[String]
    def failureType: Option[String]
    def details
        : Option[Map[AutomationParameterKey, List[AutomationParameterValue]]]
    def getFailureStage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("failureStage", failureStage)
    def getFailureType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("failureType", failureType)
    def getDetails: ZIO[Any, AwsError, Map[AutomationParameterKey, List[
      AutomationParameterValue
    ]]] = AwsError.unwrapOptionField("details", details)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.FailureDetails
  ) extends zio.aws.ssm.model.FailureDetails.ReadOnly {
    override val failureStage: Option[String] =
      scala.Option(impl.failureStage()).map(value => value: String)
    override val failureType: Option[String] =
      scala.Option(impl.failureType()).map(value => value: String)
    override val details
        : Option[Map[AutomationParameterKey, List[AutomationParameterValue]]] =
      scala
        .Option(impl.details())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.ssm.model.primitives
                .AutomationParameterKey(key) -> value.asScala.map { item =>
                zio.aws.ssm.model.primitives.AutomationParameterValue(item)
              }.toList
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.FailureDetails
  ): zio.aws.ssm.model.FailureDetails.ReadOnly = new Wrapper(impl)
}
