package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.OpsItemMaxResults
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeOpsItemsRequest(
    opsItemFilters: Option[Iterable[zio.aws.ssm.model.OpsItemFilter]] = None,
    maxResults: Option[OpsItemMaxResults] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeOpsItemsRequest = {
    import DescribeOpsItemsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeOpsItemsRequest
      .builder()
      .optionallyWith(
        opsItemFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.opsItemFilters)
      .optionallyWith(
        maxResults.map(value => OpsItemMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DescribeOpsItemsRequest.ReadOnly =
    zio.aws.ssm.model.DescribeOpsItemsRequest.wrap(buildAwsValue())
}
object DescribeOpsItemsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeOpsItemsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DescribeOpsItemsRequest =
      zio.aws.ssm.model.DescribeOpsItemsRequest(
        opsItemFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def opsItemFilters: Option[List[zio.aws.ssm.model.OpsItemFilter.ReadOnly]]
    def maxResults: Option[OpsItemMaxResults]
    def nextToken: Option[String]
    def getOpsItemFilters
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.OpsItemFilter.ReadOnly]] =
      AwsError.unwrapOptionField("opsItemFilters", opsItemFilters)
    def getMaxResults: ZIO[Any, AwsError, OpsItemMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeOpsItemsRequest
  ) extends zio.aws.ssm.model.DescribeOpsItemsRequest.ReadOnly {
    override val opsItemFilters
        : Option[List[zio.aws.ssm.model.OpsItemFilter.ReadOnly]] = scala
      .Option(impl.opsItemFilters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.OpsItemFilter.wrap(item)
        }.toList
      )
    override val maxResults: Option[OpsItemMaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ssm.model.primitives.OpsItemMaxResults(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeOpsItemsRequest
  ): zio.aws.ssm.model.DescribeOpsItemsRequest.ReadOnly = new Wrapper(impl)
}
