package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeMaintenanceWindowTargetsResponse(
    targets: Option[Iterable[zio.aws.ssm.model.MaintenanceWindowTarget]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsResponse = {
    import DescribeMaintenanceWindowTargetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsResponse
      .builder()
      .optionallyWith(
        targets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targets)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.DescribeMaintenanceWindowTargetsResponse.ReadOnly =
    zio.aws.ssm.model.DescribeMaintenanceWindowTargetsResponse
      .wrap(buildAwsValue())
}
object DescribeMaintenanceWindowTargetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DescribeMaintenanceWindowTargetsResponse =
      zio.aws.ssm.model.DescribeMaintenanceWindowTargetsResponse(
        targets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def targets
        : Option[List[zio.aws.ssm.model.MaintenanceWindowTarget.ReadOnly]]
    def nextToken: Option[NextToken]
    def getTargets: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.MaintenanceWindowTarget.ReadOnly
    ]] = AwsError.unwrapOptionField("targets", targets)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsResponse
  ) extends zio.aws.ssm.model.DescribeMaintenanceWindowTargetsResponse.ReadOnly {
    override val targets
        : Option[List[zio.aws.ssm.model.MaintenanceWindowTarget.ReadOnly]] =
      scala
        .Option(impl.targets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.MaintenanceWindowTarget.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsResponse
  ): zio.aws.ssm.model.DescribeMaintenanceWindowTargetsResponse.ReadOnly =
    new Wrapper(impl)
}
