package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  MaintenanceWindowTaskId,
  MaintenanceWindowId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeregisterTaskFromMaintenanceWindowResponse(
    windowId: Option[MaintenanceWindowId] = None,
    windowTaskId: Option[MaintenanceWindowTaskId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DeregisterTaskFromMaintenanceWindowResponse = {
    import DeregisterTaskFromMaintenanceWindowResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DeregisterTaskFromMaintenanceWindowResponse
      .builder()
      .optionallyWith(
        windowId.map(value =>
          MaintenanceWindowId.unwrap(value): java.lang.String
        )
      )(_.windowId)
      .optionallyWith(
        windowTaskId.map(value =>
          MaintenanceWindowTaskId.unwrap(value): java.lang.String
        )
      )(_.windowTaskId)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.DeregisterTaskFromMaintenanceWindowResponse.ReadOnly =
    zio.aws.ssm.model.DeregisterTaskFromMaintenanceWindowResponse
      .wrap(buildAwsValue())
}
object DeregisterTaskFromMaintenanceWindowResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DeregisterTaskFromMaintenanceWindowResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssm.model.DeregisterTaskFromMaintenanceWindowResponse =
      zio.aws.ssm.model.DeregisterTaskFromMaintenanceWindowResponse(
        windowId.map(value => value),
        windowTaskId.map(value => value)
      )
    def windowId: Option[MaintenanceWindowId]
    def windowTaskId: Option[MaintenanceWindowTaskId]
    def getWindowId: ZIO[Any, AwsError, MaintenanceWindowId] =
      AwsError.unwrapOptionField("windowId", windowId)
    def getWindowTaskId: ZIO[Any, AwsError, MaintenanceWindowTaskId] =
      AwsError.unwrapOptionField("windowTaskId", windowTaskId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DeregisterTaskFromMaintenanceWindowResponse
  ) extends zio.aws.ssm.model.DeregisterTaskFromMaintenanceWindowResponse.ReadOnly {
    override val windowId: Option[MaintenanceWindowId] = scala
      .Option(impl.windowId())
      .map(value => zio.aws.ssm.model.primitives.MaintenanceWindowId(value))
    override val windowTaskId: Option[MaintenanceWindowTaskId] = scala
      .Option(impl.windowTaskId())
      .map(value => zio.aws.ssm.model.primitives.MaintenanceWindowTaskId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DeregisterTaskFromMaintenanceWindowResponse
  ): zio.aws.ssm.model.DeregisterTaskFromMaintenanceWindowResponse.ReadOnly =
    new Wrapper(impl)
}
