package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.ManagedInstanceId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeregisterManagedInstanceRequest(
    instanceId: ManagedInstanceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DeregisterManagedInstanceRequest = {
    import DeregisterManagedInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DeregisterManagedInstanceRequest
      .builder()
      .instanceId(ManagedInstanceId.unwrap(instanceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DeregisterManagedInstanceRequest.ReadOnly =
    zio.aws.ssm.model.DeregisterManagedInstanceRequest.wrap(buildAwsValue())
}
object DeregisterManagedInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DeregisterManagedInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DeregisterManagedInstanceRequest =
      zio.aws.ssm.model.DeregisterManagedInstanceRequest(instanceId)
    def instanceId: ManagedInstanceId
    def getInstanceId: ZIO[Any, Nothing, ManagedInstanceId] =
      ZIO.succeed(instanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DeregisterManagedInstanceRequest
  ) extends zio.aws.ssm.model.DeregisterManagedInstanceRequest.ReadOnly {
    override val instanceId: ManagedInstanceId =
      zio.aws.ssm.model.primitives.ManagedInstanceId(impl.instanceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DeregisterManagedInstanceRequest
  ): zio.aws.ssm.model.DeregisterManagedInstanceRequest.ReadOnly = new Wrapper(
    impl
  )
}
