package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{InventoryItemTypeName, UUID}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteInventoryResponse(
    deletionId: Option[UUID] = None,
    typeName: Option[InventoryItemTypeName] = None,
    deletionSummary: Option[zio.aws.ssm.model.InventoryDeletionSummary] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DeleteInventoryResponse = {
    import DeleteInventoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DeleteInventoryResponse
      .builder()
      .optionallyWith(
        deletionId.map(value => UUID.unwrap(value): java.lang.String)
      )(_.deletionId)
      .optionallyWith(
        typeName.map(value =>
          InventoryItemTypeName.unwrap(value): java.lang.String
        )
      )(_.typeName)
      .optionallyWith(deletionSummary.map(value => value.buildAwsValue()))(
        _.deletionSummary
      )
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DeleteInventoryResponse.ReadOnly =
    zio.aws.ssm.model.DeleteInventoryResponse.wrap(buildAwsValue())
}
object DeleteInventoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DeleteInventoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DeleteInventoryResponse =
      zio.aws.ssm.model.DeleteInventoryResponse(
        deletionId.map(value => value),
        typeName.map(value => value),
        deletionSummary.map(value => value.asEditable)
      )
    def deletionId: Option[UUID]
    def typeName: Option[InventoryItemTypeName]
    def deletionSummary
        : Option[zio.aws.ssm.model.InventoryDeletionSummary.ReadOnly]
    def getDeletionId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("deletionId", deletionId)
    def getTypeName: ZIO[Any, AwsError, InventoryItemTypeName] =
      AwsError.unwrapOptionField("typeName", typeName)
    def getDeletionSummary: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.InventoryDeletionSummary.ReadOnly
    ] = AwsError.unwrapOptionField("deletionSummary", deletionSummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DeleteInventoryResponse
  ) extends zio.aws.ssm.model.DeleteInventoryResponse.ReadOnly {
    override val deletionId: Option[UUID] = scala
      .Option(impl.deletionId())
      .map(value => zio.aws.ssm.model.primitives.UUID(value))
    override val typeName: Option[InventoryItemTypeName] = scala
      .Option(impl.typeName())
      .map(value => zio.aws.ssm.model.primitives.InventoryItemTypeName(value))
    override val deletionSummary
        : Option[zio.aws.ssm.model.InventoryDeletionSummary.ReadOnly] = scala
      .Option(impl.deletionSummary())
      .map(value => zio.aws.ssm.model.InventoryDeletionSummary.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DeleteInventoryResponse
  ): zio.aws.ssm.model.DeleteInventoryResponse.ReadOnly = new Wrapper(impl)
}
