package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.MaintenanceWindowExecutionId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CancelMaintenanceWindowExecutionResponse(
    windowExecutionId: Option[MaintenanceWindowExecutionId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.CancelMaintenanceWindowExecutionResponse = {
    import CancelMaintenanceWindowExecutionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.CancelMaintenanceWindowExecutionResponse
      .builder()
      .optionallyWith(
        windowExecutionId.map(value =>
          MaintenanceWindowExecutionId.unwrap(value): java.lang.String
        )
      )(_.windowExecutionId)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.CancelMaintenanceWindowExecutionResponse.ReadOnly =
    zio.aws.ssm.model.CancelMaintenanceWindowExecutionResponse
      .wrap(buildAwsValue())
}
object CancelMaintenanceWindowExecutionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.CancelMaintenanceWindowExecutionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.CancelMaintenanceWindowExecutionResponse =
      zio.aws.ssm.model.CancelMaintenanceWindowExecutionResponse(
        windowExecutionId.map(value => value)
      )
    def windowExecutionId: Option[MaintenanceWindowExecutionId]
    def getWindowExecutionId: ZIO[Any, AwsError, MaintenanceWindowExecutionId] =
      AwsError.unwrapOptionField("windowExecutionId", windowExecutionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.CancelMaintenanceWindowExecutionResponse
  ) extends zio.aws.ssm.model.CancelMaintenanceWindowExecutionResponse.ReadOnly {
    override val windowExecutionId: Option[MaintenanceWindowExecutionId] = scala
      .Option(impl.windowExecutionId())
      .map(value =>
        zio.aws.ssm.model.primitives.MaintenanceWindowExecutionId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.CancelMaintenanceWindowExecutionResponse
  ): zio.aws.ssm.model.CancelMaintenanceWindowExecutionResponse.ReadOnly =
    new Wrapper(impl)
}
