package zio.aws.ssm
import zio.aws.ssm.model.DescribeAutomationExecutionsResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.ssm.{
  SsmAsyncClientBuilder,
  SsmAsyncClient
}
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import software.amazon.awssdk.services.ssm.model.{
  GetMaintenanceWindowRequest,
  GetServiceSettingRequest,
  UpdateResourceDataSyncResponse,
  LabelParameterVersionRequest,
  ListDocumentVersionsRequest,
  StartSessionResponse,
  DescribeMaintenanceWindowTasksRequest,
  DescribePatchGroupStateRequest,
  ResumeSessionResponse,
  StepExecution,
  DescribeInstancePatchStatesRequest,
  DocumentVersionInfo,
  DescribeMaintenanceWindowsForTargetRequest,
  PutInventoryResponse,
  AssociateOpsItemRelatedItemRequest,
  DescribeMaintenanceWindowExecutionTasksResponse,
  ListComplianceSummariesResponse,
  ScheduledWindowExecution,
  StopAutomationExecutionRequest,
  DescribeDocumentResponse,
  CancelCommandResponse,
  GetMaintenanceWindowExecutionRequest,
  GetDefaultPatchBaselineRequest,
  InventoryItemSchema,
  ListResourceDataSyncResponse,
  DescribePatchGroupsRequest,
  UpdateDocumentDefaultVersionResponse,
  CancelMaintenanceWindowExecutionRequest,
  DescribeEffectivePatchesForPatchBaselineRequest,
  MaintenanceWindowTask,
  OpsEntity,
  RegisterTaskWithMaintenanceWindowRequest,
  DeleteAssociationResponse,
  DeleteMaintenanceWindowResponse,
  GetParameterResponse,
  ModifyDocumentPermissionRequest,
  ParameterMetadata,
  DeregisterTaskFromMaintenanceWindowRequest,
  UpdatePatchBaselineResponse,
  UpdateMaintenanceWindowTaskResponse,
  GetDeployablePatchSnapshotForInstanceRequest,
  ListOpsMetadataRequest,
  GetAutomationExecutionRequest,
  DisassociateOpsItemRelatedItemRequest,
  DeregisterTargetFromMaintenanceWindowRequest,
  DescribeMaintenanceWindowExecutionsResponse,
  UpdateDocumentResponse,
  RegisterPatchBaselineForPatchGroupResponse,
  DescribeAssociationExecutionsRequest,
  UpdateDocumentDefaultVersionRequest,
  DeleteResourceDataSyncRequest,
  TerminateSessionResponse,
  CreatePatchBaselineRequest,
  PatchComplianceData,
  DescribeParametersResponse,
  AddTagsToResourceRequest,
  GetInventoryResponse,
  OpsItemRelatedItemSummary,
  CreateAssociationBatchRequest,
  ListComplianceSummariesRequest,
  GetMaintenanceWindowResponse,
  GetDefaultPatchBaselineResponse,
  UnlabelParameterVersionRequest,
  DescribeMaintenanceWindowTargetsResponse,
  RemoveTagsFromResourceResponse,
  CreateAssociationBatchResponse,
  DescribeActivationsRequest,
  RegisterDefaultPatchBaselineRequest,
  DescribeMaintenanceWindowsRequest,
  InstancePatchState,
  ListAssociationVersionsRequest,
  UpdateDocumentMetadataResponse,
  DescribeEffectiveInstanceAssociationsResponse,
  DeleteOpsMetadataRequest,
  GetInventorySchemaResponse,
  DeleteParametersResponse,
  DescribeActivationsResponse,
  GetConnectionStatusResponse,
  ListOpsItemRelatedItemsRequest,
  ResumeSessionRequest,
  CreateMaintenanceWindowResponse,
  ResetServiceSettingResponse,
  GetOpsSummaryRequest,
  DeleteActivationRequest,
  LabelParameterVersionResponse,
  PutComplianceItemsResponse,
  UpdateAssociationStatusRequest,
  SendAutomationSignalRequest,
  CommandInvocation,
  InstanceInformation,
  DescribeMaintenanceWindowsResponse,
  Activation,
  DeleteOpsMetadataResponse,
  DeleteActivationResponse,
  GetDocumentResponse,
  DescribeInstancePatchStatesForPatchGroupResponse,
  DescribeEffectivePatchesForPatchBaselineResponse,
  GetMaintenanceWindowExecutionTaskResponse,
  DisassociateOpsItemRelatedItemResponse,
  DescribeDocumentPermissionRequest,
  DeregisterManagedInstanceResponse,
  UpdateOpsItemResponse,
  ListComplianceItemsResponse,
  ListTagsForResourceRequest,
  ListCommandsRequest,
  DescribeInstanceInformationRequest,
  GetServiceSettingResponse,
  UpdateResourceDataSyncRequest,
  RegisterTargetWithMaintenanceWindowResponse,
  GetPatchBaselineResponse,
  DeregisterTargetFromMaintenanceWindowResponse,
  DescribeMaintenanceWindowScheduleRequest,
  DescribeAvailablePatchesRequest,
  UpdateMaintenanceWindowTargetResponse,
  DeleteParameterRequest,
  GetParameterHistoryRequest,
  DescribeInstancePatchesResponse,
  Association,
  DeleteMaintenanceWindowRequest,
  InventoryResultEntity,
  PatchGroupPatchBaselineMapping,
  UpdateDocumentRequest,
  GetParameterHistoryResponse,
  DeletePatchBaselineRequest,
  DescribeSessionsRequest,
  ResourceComplianceSummaryItem,
  GetParametersByPathRequest,
  CreateOpsMetadataResponse,
  DescribePatchGroupsResponse,
  ParameterHistory,
  GetParameterRequest,
  GetMaintenanceWindowTaskResponse,
  Patch,
  InstanceAssociation,
  GetPatchBaselineRequest,
  DescribeAutomationStepExecutionsRequest,
  UpdateAssociationStatusResponse,
  MaintenanceWindowTarget,
  DescribeEffectiveInstanceAssociationsRequest,
  GetParametersResponse,
  DescribeInventoryDeletionsRequest,
  SendCommandResponse,
  MaintenanceWindowIdentity,
  ListTagsForResourceResponse,
  UpdateMaintenanceWindowTaskRequest,
  InventoryDeletionStatusItem,
  UpdateOpsMetadataResponse,
  DescribeOpsItemsRequest,
  UpdateManagedInstanceRoleRequest,
  DescribeMaintenanceWindowScheduleResponse,
  DeleteInventoryResponse,
  GetMaintenanceWindowExecutionResponse,
  DeleteDocumentResponse,
  DescribeInstancePatchStatesResponse,
  GetMaintenanceWindowTaskRequest,
  AssociationExecutionTarget,
  SendAutomationSignalResponse,
  PutParameterRequest,
  UpdateServiceSettingRequest,
  TerminateSessionRequest,
  DescribeAssociationRequest,
  DescribeMaintenanceWindowTasksResponse,
  StartAutomationExecutionResponse,
  CreateOpsMetadataRequest,
  AssociationVersionInfo,
  DescribePatchGroupStateResponse,
  DeregisterPatchBaselineForPatchGroupRequest,
  DescribeAutomationExecutionsRequest,
  CancelCommandRequest,
  ListOpsItemRelatedItemsResponse,
  StartSessionRequest,
  DeleteAssociationRequest,
  GetMaintenanceWindowExecutionTaskInvocationResponse,
  MaintenanceWindowExecutionTaskIdentity,
  RemoveTagsFromResourceRequest,
  PatchBaselineIdentity,
  DescribeOpsItemsResponse,
  DescribePatchBaselinesResponse,
  DescribeMaintenanceWindowExecutionTaskInvocationsResponse,
  MaintenanceWindowExecutionTaskInvocationIdentity,
  Session,
  ListDocumentMetadataHistoryRequest,
  GetOpsItemRequest,
  RegisterDefaultPatchBaselineResponse,
  DescribeMaintenanceWindowTargetsRequest,
  UpdateOpsMetadataRequest,
  MaintenanceWindowIdentityForTarget,
  DeleteParametersRequest,
  ListResourceComplianceSummariesResponse,
  DescribeAutomationExecutionsResponse,
  DeregisterManagedInstanceRequest,
  OpsMetadata,
  GetAutomationExecutionResponse,
  DescribeSessionsResponse,
  DescribePatchBaselinesRequest,
  RegisterTargetWithMaintenanceWindowRequest,
  CreateActivationResponse,
  PutInventoryRequest,
  StartChangeRequestExecutionResponse,
  GetCalendarStateResponse,
  ListOpsItemEventsResponse,
  CancelMaintenanceWindowExecutionResponse,
  GetOpsItemResponse,
  CreatePatchBaselineResponse,
  RegisterPatchBaselineForPatchGroupRequest,
  DeleteDocumentRequest,
  DeregisterTaskFromMaintenanceWindowResponse,
  UnlabelParameterVersionResponse,
  GetParametersRequest,
  GetCommandInvocationRequest,
  AssociationExecution,
  GetMaintenanceWindowExecutionTaskInvocationRequest,
  DocumentIdentifier,
  DescribeMaintenanceWindowsForTargetResponse,
  ListResourceDataSyncRequest,
  UpdateDocumentMetadataRequest,
  ListDocumentsRequest,
  DescribeMaintenanceWindowExecutionsRequest,
  Command,
  GetCalendarStateRequest,
  ListOpsItemEventsRequest,
  InstanceAssociationStatusInfo,
  UpdateAssociationRequest,
  AutomationExecutionMetadata,
  DescribeInstanceAssociationsStatusRequest,
  PutParameterResponse,
  DescribeDocumentPermissionResponse,
  StartAutomationExecutionRequest,
  GetParametersByPathResponse,
  MaintenanceWindowExecution,
  DescribeAssociationExecutionTargetsRequest,
  ListDocumentsResponse,
  GetDeployablePatchSnapshotForInstanceResponse,
  ResourceDataSyncItem,
  GetOpsMetadataResponse,
  ComplianceItem,
  GetPatchBaselineForPatchGroupResponse,
  CreateDocumentResponse,
  AddTagsToResourceResponse,
  EffectivePatch,
  AssociateOpsItemRelatedItemResponse,
  UpdateServiceSettingResponse,
  DescribeAssociationExecutionTargetsResponse,
  DeleteParameterResponse,
  StartAssociationsOnceRequest,
  DeleteResourceDataSyncResponse,
  DeletePatchBaselineResponse,
  GetCommandInvocationResponse,
  ListAssociationsRequest,
  ListInventoryEntriesRequest,
  ListComplianceItemsRequest,
  GetDocumentRequest,
  MetadataValue,
  UpdateManagedInstanceRoleResponse,
  DescribeInstancePatchesRequest,
  CreateMaintenanceWindowRequest,
  CreateActivationRequest,
  DescribeAvailablePatchesResponse,
  ResetServiceSettingRequest,
  DescribeAssociationResponse,
  UpdateMaintenanceWindowTargetRequest,
  GetInventoryRequest,
  SendCommandRequest,
  DescribeMaintenanceWindowExecutionTaskInvocationsRequest,
  PutComplianceItemsRequest,
  UpdatePatchBaselineRequest,
  CreateResourceDataSyncResponse,
  ListCommandInvocationsResponse,
  DescribeAssociationExecutionsResponse,
  RegisterTaskWithMaintenanceWindowResponse,
  DescribeInventoryDeletionsResponse,
  ListResourceComplianceSummariesRequest,
  ListCommandInvocationsRequest,
  GetPatchBaselineForPatchGroupRequest,
  ListOpsMetadataResponse,
  ListDocumentMetadataHistoryResponse,
  DescribeDocumentRequest,
  ListCommandsResponse,
  CreateOpsItemRequest,
  CreateResourceDataSyncRequest,
  StartAssociationsOnceResponse,
  Parameter,
  OpsItemEventSummary,
  GetOpsMetadataRequest,
  DescribePatchPropertiesRequest,
  DescribeParametersRequest,
  GetMaintenanceWindowExecutionTaskRequest,
  DescribeInstanceInformationResponse,
  ListInventoryEntriesResponse,
  DescribeInstanceAssociationsStatusResponse,
  GetOpsSummaryResponse,
  DescribeInstancePatchStatesForPatchGroupRequest,
  CreateDocumentRequest,
  UpdateMaintenanceWindowRequest,
  ModifyDocumentPermissionResponse,
  ComplianceSummaryItem,
  DescribePatchPropertiesResponse,
  ListAssociationVersionsResponse,
  StopAutomationExecutionResponse,
  StartChangeRequestExecutionRequest,
  GetConnectionStatusRequest,
  DescribeAutomationStepExecutionsResponse,
  GetInventorySchemaRequest,
  CreateOpsItemResponse,
  UpdateOpsItemRequest,
  CreateAssociationRequest,
  ListDocumentVersionsResponse,
  UpdateAssociationResponse,
  DescribeMaintenanceWindowExecutionTasksRequest,
  ListAssociationsResponse,
  OpsItemSummary,
  UpdateMaintenanceWindowResponse,
  CreateAssociationResponse,
  DeleteInventoryRequest,
  DeregisterPatchBaselineForPatchGroupResponse
}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import zio.stream.ZStream
import zio.aws.ssm.model.primitives.{AttributeValue, AttributeName, MetadataKey}
import scala.jdk.CollectionConverters._
trait Ssm extends AspectSupport[Ssm] {
  val api: SsmAsyncClient
  def deleteInventory(
      request: zio.aws.ssm.model.DeleteInventoryRequest
  ): IO[AwsError, zio.aws.ssm.model.DeleteInventoryResponse.ReadOnly]
  def describeAutomationStepExecutions(
      request: zio.aws.ssm.model.DescribeAutomationStepExecutionsRequest
  ): ZStream[Any, AwsError, zio.aws.ssm.model.StepExecution.ReadOnly]
  def describeAutomationStepExecutionsPaginated(
      request: zio.aws.ssm.model.DescribeAutomationStepExecutionsRequest
  ): IO[
    AwsError,
    zio.aws.ssm.model.DescribeAutomationStepExecutionsResponse.ReadOnly
  ]
  def deleteParameters(
      request: zio.aws.ssm.model.DeleteParametersRequest
  ): IO[AwsError, zio.aws.ssm.model.DeleteParametersResponse.ReadOnly]
  def getParameterHistory(
      request: zio.aws.ssm.model.GetParameterHistoryRequest
  ): ZStream[Any, AwsError, zio.aws.ssm.model.ParameterHistory.ReadOnly]
  def getParameterHistoryPaginated(
      request: zio.aws.ssm.model.GetParameterHistoryRequest
  ): IO[AwsError, zio.aws.ssm.model.GetParameterHistoryResponse.ReadOnly]
  def addTagsToResource(
      request: zio.aws.ssm.model.AddTagsToResourceRequest
  ): IO[AwsError, zio.aws.ssm.model.AddTagsToResourceResponse.ReadOnly]
  def describeSessions(
      request: zio.aws.ssm.model.DescribeSessionsRequest
  ): ZStream[Any, AwsError, zio.aws.ssm.model.Session.ReadOnly]
  def describeSessionsPaginated(
      request: zio.aws.ssm.model.DescribeSessionsRequest
  ): IO[AwsError, zio.aws.ssm.model.DescribeSessionsResponse.ReadOnly]
  def listResourceDataSync(
      request: zio.aws.ssm.model.ListResourceDataSyncRequest
  ): ZStream[Any, AwsError, zio.aws.ssm.model.ResourceDataSyncItem.ReadOnly]
  def listResourceDataSyncPaginated(
      request: zio.aws.ssm.model.ListResourceDataSyncRequest
  ): IO[AwsError, zio.aws.ssm.model.ListResourceDataSyncResponse.ReadOnly]
  def getOpsMetadata(
      request: zio.aws.ssm.model.GetOpsMetadataRequest
  ): IO[AwsError, StreamingOutputResult[
    Any,
    zio.aws.ssm.model.GetOpsMetadataResponse.ReadOnly,
    Tuple2[MetadataKey, zio.aws.ssm.model.MetadataValue.ReadOnly]
  ]]
  def getOpsMetadataPaginated(
      request: zio.aws.ssm.model.GetOpsMetadataRequest
  ): IO[AwsError, zio.aws.ssm.model.GetOpsMetadataResponse.ReadOnly]
  def deregisterPatchBaselineForPatchGroup(
      request: zio.aws.ssm.model.DeregisterPatchBaselineForPatchGroupRequest
  ): IO[
    AwsError,
    zio.aws.ssm.model.DeregisterPatchBaselineForPatchGroupResponse.ReadOnly
  ]
  def stopAutomationExecution(
      request: zio.aws.ssm.model.StopAutomationExecutionRequest
  ): IO[AwsError, zio.aws.ssm.model.StopAutomationExecutionResponse.ReadOnly]
  def describeInstanceAssociationsStatus(
      request: zio.aws.ssm.model.DescribeInstanceAssociationsStatusRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.ssm.model.InstanceAssociationStatusInfo.ReadOnly
  ]
  def describeInstanceAssociationsStatusPaginated(
      request: zio.aws.ssm.model.DescribeInstanceAssociationsStatusRequest
  ): IO[
    AwsError,
    zio.aws.ssm.model.DescribeInstanceAssociationsStatusResponse.ReadOnly
  ]
  def describeMaintenanceWindowsForTarget(
      request: zio.aws.ssm.model.DescribeMaintenanceWindowsForTargetRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.ssm.model.MaintenanceWindowIdentityForTarget.ReadOnly
  ]
  def describeMaintenanceWindowsForTargetPaginated(
      request: zio.aws.ssm.model.DescribeMaintenanceWindowsForTargetRequest
  ): IO[
    AwsError,
    zio.aws.ssm.model.DescribeMaintenanceWindowsForTargetResponse.ReadOnly
  ]
  def getParameters(
      request: zio.aws.ssm.model.GetParametersRequest
  ): IO[AwsError, zio.aws.ssm.model.GetParametersResponse.ReadOnly]
  def describeInstancePatchStates(
      request: zio.aws.ssm.model.DescribeInstancePatchStatesRequest
  ): ZStream[Any, AwsError, zio.aws.ssm.model.InstancePatchState.ReadOnly]
  def describeInstancePatchStatesPaginated(
      request: zio.aws.ssm.model.DescribeInstancePatchStatesRequest
  ): IO[
    AwsError,
    zio.aws.ssm.model.DescribeInstancePatchStatesResponse.ReadOnly
  ]
  def listInventoryEntries(
      request: zio.aws.ssm.model.ListInventoryEntriesRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.ssm.model.ListInventoryEntriesResponse.ReadOnly,
    Map[AttributeName, AttributeValue]
  ]]
  def listInventoryEntriesPaginated(
      request: zio.aws.ssm.model.ListInventoryEntriesRequest
  ): IO[AwsError, zio.aws.ssm.model.ListInventoryEntriesResponse.ReadOnly]
  def describeMaintenanceWindowExecutions(
      request: zio.aws.ssm.model.DescribeMaintenanceWindowExecutionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.ssm.model.MaintenanceWindowExecution.ReadOnly
  ]
  def describeMaintenanceWindowExecutionsPaginated(
      request: zio.aws.ssm.model.DescribeMaintenanceWindowExecutionsRequest
  ): IO[
    AwsError,
    zio.aws.ssm.model.DescribeMaintenanceWindowExecutionsResponse.ReadOnly
  ]
  def describeAssociationExecutions(
      request: zio.aws.ssm.model.DescribeAssociationExecutionsRequest
  ): ZStream[Any, AwsError, zio.aws.ssm.model.AssociationExecution.ReadOnly]
  def describeAssociationExecutionsPaginated(
      request: zio.aws.ssm.model.DescribeAssociationExecutionsRequest
  ): IO[
    AwsError,
    zio.aws.ssm.model.DescribeAssociationExecutionsResponse.ReadOnly
  ]
  def listComplianceItems(
      request: zio.aws.ssm.model.ListComplianceItemsRequest
  ): ZStream[Any, AwsError, zio.aws.ssm.model.ComplianceItem.ReadOnly]
  def listComplianceItemsPaginated(
      request: zio.aws.ssm.model.ListComplianceItemsRequest
  ): IO[AwsError, zio.aws.ssm.model.ListComplianceItemsResponse.ReadOnly]
  def describeMaintenanceWindowTasks(
      request: zio.aws.ssm.model.DescribeMaintenanceWindowTasksRequest
  ): ZStream[Any, AwsError, zio.aws.ssm.model.MaintenanceWindowTask.ReadOnly]
  def describeMaintenanceWindowTasksPaginated(
      request: zio.aws.ssm.model.DescribeMaintenanceWindowTasksRequest
  ): IO[
    AwsError,
    zio.aws.ssm.model.DescribeMaintenanceWindowTasksResponse.ReadOnly
  ]
  def deleteMaintenanceWindow(
      request: zio.aws.ssm.model.DeleteMaintenanceWindowRequest
  ): IO[AwsError, zio.aws.ssm.model.DeleteMaintenanceWindowResponse.ReadOnly]
  def describePatchGroupState(
      request: zio.aws.ssm.model.DescribePatchGroupStateRequest
  ): IO[AwsError, zio.aws.ssm.model.DescribePatchGroupStateResponse.ReadOnly]
  def describeParameters(
      request: zio.aws.ssm.model.DescribeParametersRequest
  ): ZStream[Any, AwsError, zio.aws.ssm.model.ParameterMetadata.ReadOnly]
  def describeParametersPaginated(
      request: zio.aws.ssm.model.DescribeParametersRequest
  ): IO[AwsError, zio.aws.ssm.model.DescribeParametersResponse.ReadOnly]
  def listOpsItemEvents(
      request: zio.aws.ssm.model.ListOpsItemEventsRequest
  ): ZStream[Any, AwsError, zio.aws.ssm.model.OpsItemEventSummary.ReadOnly]
  def listOpsItemEventsPaginated(
      request: zio.aws.ssm.model.ListOpsItemEventsRequest
  ): IO[AwsError, zio.aws.ssm.model.ListOpsItemEventsResponse.ReadOnly]
  def getDocument(
      request: zio.aws.ssm.model.GetDocumentRequest
  ): IO[AwsError, zio.aws.ssm.model.GetDocumentResponse.ReadOnly]
  def createDocument(
      request: zio.aws.ssm.model.CreateDocumentRequest
  ): IO[AwsError, zio.aws.ssm.model.CreateDocumentResponse.ReadOnly]
  def modifyDocumentPermission(
      request: zio.aws.ssm.model.ModifyDocumentPermissionRequest
  ): IO[AwsError, zio.aws.ssm.model.ModifyDocumentPermissionResponse.ReadOnly]
  def registerTargetWithMaintenanceWindow(
      request: zio.aws.ssm.model.RegisterTargetWithMaintenanceWindowRequest
  ): IO[
    AwsError,
    zio.aws.ssm.model.RegisterTargetWithMaintenanceWindowResponse.ReadOnly
  ]
  def terminateSession(
      request: zio.aws.ssm.model.TerminateSessionRequest
  ): IO[AwsError, zio.aws.ssm.model.TerminateSessionResponse.ReadOnly]
  def removeTagsFromResource(
      request: zio.aws.ssm.model.RemoveTagsFromResourceRequest
  ): IO[AwsError, zio.aws.ssm.model.RemoveTagsFromResourceResponse.ReadOnly]
  def startChangeRequestExecution(
      request: zio.aws.ssm.model.StartChangeRequestExecutionRequest
  ): IO[
    AwsError,
    zio.aws.ssm.model.StartChangeRequestExecutionResponse.ReadOnly
  ]
  def describeActivations(
      request: zio.aws.ssm.model.DescribeActivationsRequest
  ): ZStream[Any, AwsError, zio.aws.ssm.model.Activation.ReadOnly]
  def describeActivationsPaginated(
      request: zio.aws.ssm.model.DescribeActivationsRequest
  ): IO[AwsError, zio.aws.ssm.model.DescribeActivationsResponse.ReadOnly]
  def sendAutomationSignal(
      request: zio.aws.ssm.model.SendAutomationSignalRequest
  ): IO[AwsError, zio.aws.ssm.model.SendAutomationSignalResponse.ReadOnly]
  def createMaintenanceWindow(
      request: zio.aws.ssm.model.CreateMaintenanceWindowRequest
  ): IO[AwsError, zio.aws.ssm.model.CreateMaintenanceWindowResponse.ReadOnly]
  def cancelCommand(
      request: zio.aws.ssm.model.CancelCommandRequest
  ): IO[AwsError, zio.aws.ssm.model.CancelCommandResponse.ReadOnly]
  def getMaintenanceWindow(
      request: zio.aws.ssm.model.GetMaintenanceWindowRequest
  ): IO[AwsError, zio.aws.ssm.model.GetMaintenanceWindowResponse.ReadOnly]
  def describeAssociation(
      request: zio.aws.ssm.model.DescribeAssociationRequest
  ): IO[AwsError, zio.aws.ssm.model.DescribeAssociationResponse.ReadOnly]
  def getMaintenanceWindowExecutionTask(
      request: zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskRequest
  ): IO[
    AwsError,
    zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskResponse.ReadOnly
  ]
  def labelParameterVersion(
      request: zio.aws.ssm.model.LabelParameterVersionRequest
  ): IO[AwsError, zio.aws.ssm.model.LabelParameterVersionResponse.ReadOnly]
  def describePatchProperties(
      request: zio.aws.ssm.model.DescribePatchPropertiesRequest
  ): ZStream[Any, AwsError, Map[AttributeName, AttributeValue]]
  def describePatchPropertiesPaginated(
      request: zio.aws.ssm.model.DescribePatchPropertiesRequest
  ): IO[AwsError, zio.aws.ssm.model.DescribePatchPropertiesResponse.ReadOnly]
  def describeMaintenanceWindowSchedule(
      request: zio.aws.ssm.model.DescribeMaintenanceWindowScheduleRequest
  ): ZStream[Any, AwsError, zio.aws.ssm.model.ScheduledWindowExecution.ReadOnly]
  def describeMaintenanceWindowSchedulePaginated(
      request: zio.aws.ssm.model.DescribeMaintenanceWindowScheduleRequest
  ): IO[
    AwsError,
    zio.aws.ssm.model.DescribeMaintenanceWindowScheduleResponse.ReadOnly
  ]
  def getDefaultPatchBaseline(
      request: zio.aws.ssm.model.GetDefaultPatchBaselineRequest
  ): IO[AwsError, zio.aws.ssm.model.GetDefaultPatchBaselineResponse.ReadOnly]
  def updateDocumentMetadata(
      request: zio.aws.ssm.model.UpdateDocumentMetadataRequest
  ): IO[AwsError, zio.aws.ssm.model.UpdateDocumentMetadataResponse.ReadOnly]
  def deleteAssociation(
      request: zio.aws.ssm.model.DeleteAssociationRequest
  ): IO[AwsError, zio.aws.ssm.model.DeleteAssociationResponse.ReadOnly]
  def createAssociationBatch(
      request: zio.aws.ssm.model.CreateAssociationBatchRequest
  ): IO[AwsError, zio.aws.ssm.model.CreateAssociationBatchResponse.ReadOnly]
  def getParameter(
      request: zio.aws.ssm.model.GetParameterRequest
  ): IO[AwsError, zio.aws.ssm.model.GetParameterResponse.ReadOnly]
  def registerTaskWithMaintenanceWindow(
      request: zio.aws.ssm.model.RegisterTaskWithMaintenanceWindowRequest
  ): IO[
    AwsError,
    zio.aws.ssm.model.RegisterTaskWithMaintenanceWindowResponse.ReadOnly
  ]
  def listOpsMetadata(
      request: zio.aws.ssm.model.ListOpsMetadataRequest
  ): ZStream[Any, AwsError, zio.aws.ssm.model.OpsMetadata.ReadOnly]
  def listOpsMetadataPaginated(
      request: zio.aws.ssm.model.ListOpsMetadataRequest
  ): IO[AwsError, zio.aws.ssm.model.ListOpsMetadataResponse.ReadOnly]
  def registerPatchBaselineForPatchGroup(
      request: zio.aws.ssm.model.RegisterPatchBaselineForPatchGroupRequest
  ): IO[
    AwsError,
    zio.aws.ssm.model.RegisterPatchBaselineForPatchGroupResponse.ReadOnly
  ]
  def describeInstancePatchStatesForPatchGroup(
      request: zio.aws.ssm.model.DescribeInstancePatchStatesForPatchGroupRequest
  ): ZStream[Any, AwsError, zio.aws.ssm.model.InstancePatchState.ReadOnly]
  def describeInstancePatchStatesForPatchGroupPaginated(
      request: zio.aws.ssm.model.DescribeInstancePatchStatesForPatchGroupRequest
  ): IO[
    AwsError,
    zio.aws.ssm.model.DescribeInstancePatchStatesForPatchGroupResponse.ReadOnly
  ]
  def listDocuments(
      request: zio.aws.ssm.model.ListDocumentsRequest
  ): ZStream[Any, AwsError, zio.aws.ssm.model.DocumentIdentifier.ReadOnly]
  def listDocumentsPaginated(
      request: zio.aws.ssm.model.ListDocumentsRequest
  ): IO[AwsError, zio.aws.ssm.model.ListDocumentsResponse.ReadOnly]
  def getPatchBaseline(
      request: zio.aws.ssm.model.GetPatchBaselineRequest
  ): IO[AwsError, zio.aws.ssm.model.GetPatchBaselineResponse.ReadOnly]
  def updateMaintenanceWindowTarget(
      request: zio.aws.ssm.model.UpdateMaintenanceWindowTargetRequest
  ): IO[
    AwsError,
    zio.aws.ssm.model.UpdateMaintenanceWindowTargetResponse.ReadOnly
  ]
  def startAutomationExecution(
      request: zio.aws.ssm.model.StartAutomationExecutionRequest
  ): IO[AwsError, zio.aws.ssm.model.StartAutomationExecutionResponse.ReadOnly]
  def sendCommand(
      request: zio.aws.ssm.model.SendCommandRequest
  ): IO[AwsError, zio.aws.ssm.model.SendCommandResponse.ReadOnly]
  def getInventory(
      request: zio.aws.ssm.model.GetInventoryRequest
  ): ZStream[Any, AwsError, zio.aws.ssm.model.InventoryResultEntity.ReadOnly]
  def getInventoryPaginated(
      request: zio.aws.ssm.model.GetInventoryRequest
  ): IO[AwsError, zio.aws.ssm.model.GetInventoryResponse.ReadOnly]
  def updateServiceSetting(
      request: zio.aws.ssm.model.UpdateServiceSettingRequest
  ): IO[AwsError, zio.aws.ssm.model.UpdateServiceSettingResponse.ReadOnly]
  def getConnectionStatus(
      request: zio.aws.ssm.model.GetConnectionStatusRequest
  ): IO[AwsError, zio.aws.ssm.model.GetConnectionStatusResponse.ReadOnly]
  def describeAutomationExecutions(
      request: zio.aws.ssm.model.DescribeAutomationExecutionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.ssm.model.AutomationExecutionMetadata.ReadOnly
  ]
  def describeAutomationExecutionsPaginated(
      request: zio.aws.ssm.model.DescribeAutomationExecutionsRequest
  ): IO[AwsError, ReadOnly]
  def resumeSession(
      request: zio.aws.ssm.model.ResumeSessionRequest
  ): IO[AwsError, zio.aws.ssm.model.ResumeSessionResponse.ReadOnly]
  def listResourceComplianceSummaries(
      request: zio.aws.ssm.model.ListResourceComplianceSummariesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.ssm.model.ResourceComplianceSummaryItem.ReadOnly
  ]
  def listResourceComplianceSummariesPaginated(
      request: zio.aws.ssm.model.ListResourceComplianceSummariesRequest
  ): IO[
    AwsError,
    zio.aws.ssm.model.ListResourceComplianceSummariesResponse.ReadOnly
  ]
  def createPatchBaseline(
      request: zio.aws.ssm.model.CreatePatchBaselineRequest
  ): IO[AwsError, zio.aws.ssm.model.CreatePatchBaselineResponse.ReadOnly]
  def getOpsItem(
      request: zio.aws.ssm.model.GetOpsItemRequest
  ): IO[AwsError, zio.aws.ssm.model.GetOpsItemResponse.ReadOnly]
  def getPatchBaselineForPatchGroup(
      request: zio.aws.ssm.model.GetPatchBaselineForPatchGroupRequest
  ): IO[
    AwsError,
    zio.aws.ssm.model.GetPatchBaselineForPatchGroupResponse.ReadOnly
  ]
  def createAssociation(
      request: zio.aws.ssm.model.CreateAssociationRequest
  ): IO[AwsError, zio.aws.ssm.model.CreateAssociationResponse.ReadOnly]
  def listAssociations(
      request: zio.aws.ssm.model.ListAssociationsRequest
  ): ZStream[Any, AwsError, zio.aws.ssm.model.Association.ReadOnly]
  def listAssociationsPaginated(
      request: zio.aws.ssm.model.ListAssociationsRequest
  ): IO[AwsError, zio.aws.ssm.model.ListAssociationsResponse.ReadOnly]
  def updateDocument(
      request: zio.aws.ssm.model.UpdateDocumentRequest
  ): IO[AwsError, zio.aws.ssm.model.UpdateDocumentResponse.ReadOnly]
  def putInventory(
      request: zio.aws.ssm.model.PutInventoryRequest
  ): IO[AwsError, zio.aws.ssm.model.PutInventoryResponse.ReadOnly]
  def updateMaintenanceWindow(
      request: zio.aws.ssm.model.UpdateMaintenanceWindowRequest
  ): IO[AwsError, zio.aws.ssm.model.UpdateMaintenanceWindowResponse.ReadOnly]
  def updateDocumentDefaultVersion(
      request: zio.aws.ssm.model.UpdateDocumentDefaultVersionRequest
  ): IO[
    AwsError,
    zio.aws.ssm.model.UpdateDocumentDefaultVersionResponse.ReadOnly
  ]
  def getMaintenanceWindowTask(
      request: zio.aws.ssm.model.GetMaintenanceWindowTaskRequest
  ): IO[AwsError, zio.aws.ssm.model.GetMaintenanceWindowTaskResponse.ReadOnly]
  def describeAssociationExecutionTargets(
      request: zio.aws.ssm.model.DescribeAssociationExecutionTargetsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.ssm.model.AssociationExecutionTarget.ReadOnly
  ]
  def describeAssociationExecutionTargetsPaginated(
      request: zio.aws.ssm.model.DescribeAssociationExecutionTargetsRequest
  ): IO[
    AwsError,
    zio.aws.ssm.model.DescribeAssociationExecutionTargetsResponse.ReadOnly
  ]
  def createOpsItem(
      request: zio.aws.ssm.model.CreateOpsItemRequest
  ): IO[AwsError, zio.aws.ssm.model.CreateOpsItemResponse.ReadOnly]
  def listCommands(
      request: zio.aws.ssm.model.ListCommandsRequest
  ): ZStream[Any, AwsError, zio.aws.ssm.model.Command.ReadOnly]
  def listCommandsPaginated(
      request: zio.aws.ssm.model.ListCommandsRequest
  ): IO[AwsError, zio.aws.ssm.model.ListCommandsResponse.ReadOnly]
  def getAutomationExecution(
      request: zio.aws.ssm.model.GetAutomationExecutionRequest
  ): IO[AwsError, zio.aws.ssm.model.GetAutomationExecutionResponse.ReadOnly]
  def describeMaintenanceWindowExecutionTasks(
      request: zio.aws.ssm.model.DescribeMaintenanceWindowExecutionTasksRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.ssm.model.MaintenanceWindowExecutionTaskIdentity.ReadOnly
  ]
  def describeMaintenanceWindowExecutionTasksPaginated(
      request: zio.aws.ssm.model.DescribeMaintenanceWindowExecutionTasksRequest
  ): IO[
    AwsError,
    zio.aws.ssm.model.DescribeMaintenanceWindowExecutionTasksResponse.ReadOnly
  ]
  def listDocumentVersions(
      request: zio.aws.ssm.model.ListDocumentVersionsRequest
  ): ZStream[Any, AwsError, zio.aws.ssm.model.DocumentVersionInfo.ReadOnly]
  def listDocumentVersionsPaginated(
      request: zio.aws.ssm.model.ListDocumentVersionsRequest
  ): IO[AwsError, zio.aws.ssm.model.ListDocumentVersionsResponse.ReadOnly]
  def getOpsSummary(
      request: zio.aws.ssm.model.GetOpsSummaryRequest
  ): ZStream[Any, AwsError, zio.aws.ssm.model.OpsEntity.ReadOnly]
  def getOpsSummaryPaginated(
      request: zio.aws.ssm.model.GetOpsSummaryRequest
  ): IO[AwsError, zio.aws.ssm.model.GetOpsSummaryResponse.ReadOnly]
  def describeDocument(
      request: zio.aws.ssm.model.DescribeDocumentRequest
  ): IO[AwsError, zio.aws.ssm.model.DescribeDocumentResponse.ReadOnly]
  def describePatchGroups(
      request: zio.aws.ssm.model.DescribePatchGroupsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.ssm.model.PatchGroupPatchBaselineMapping.ReadOnly
  ]
  def describePatchGroupsPaginated(
      request: zio.aws.ssm.model.DescribePatchGroupsRequest
  ): IO[AwsError, zio.aws.ssm.model.DescribePatchGroupsResponse.ReadOnly]
  def startAssociationsOnce(
      request: zio.aws.ssm.model.StartAssociationsOnceRequest
  ): IO[AwsError, zio.aws.ssm.model.StartAssociationsOnceResponse.ReadOnly]
  def describeMaintenanceWindowTargets(
      request: zio.aws.ssm.model.DescribeMaintenanceWindowTargetsRequest
  ): ZStream[Any, AwsError, zio.aws.ssm.model.MaintenanceWindowTarget.ReadOnly]
  def describeMaintenanceWindowTargetsPaginated(
      request: zio.aws.ssm.model.DescribeMaintenanceWindowTargetsRequest
  ): IO[
    AwsError,
    zio.aws.ssm.model.DescribeMaintenanceWindowTargetsResponse.ReadOnly
  ]
  def updateManagedInstanceRole(
      request: zio.aws.ssm.model.UpdateManagedInstanceRoleRequest
  ): IO[AwsError, zio.aws.ssm.model.UpdateManagedInstanceRoleResponse.ReadOnly]
  def describeInstanceInformation(
      request: zio.aws.ssm.model.DescribeInstanceInformationRequest
  ): ZStream[Any, AwsError, zio.aws.ssm.model.InstanceInformation.ReadOnly]
  def describeInstanceInformationPaginated(
      request: zio.aws.ssm.model.DescribeInstanceInformationRequest
  ): IO[
    AwsError,
    zio.aws.ssm.model.DescribeInstanceInformationResponse.ReadOnly
  ]
  def updateMaintenanceWindowTask(
      request: zio.aws.ssm.model.UpdateMaintenanceWindowTaskRequest
  ): IO[
    AwsError,
    zio.aws.ssm.model.UpdateMaintenanceWindowTaskResponse.ReadOnly
  ]
  def describeMaintenanceWindows(
      request: zio.aws.ssm.model.DescribeMaintenanceWindowsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.ssm.model.MaintenanceWindowIdentity.ReadOnly
  ]
  def describeMaintenanceWindowsPaginated(
      request: zio.aws.ssm.model.DescribeMaintenanceWindowsRequest
  ): IO[AwsError, zio.aws.ssm.model.DescribeMaintenanceWindowsResponse.ReadOnly]
  def getServiceSetting(
      request: zio.aws.ssm.model.GetServiceSettingRequest
  ): IO[AwsError, zio.aws.ssm.model.GetServiceSettingResponse.ReadOnly]
  def registerDefaultPatchBaseline(
      request: zio.aws.ssm.model.RegisterDefaultPatchBaselineRequest
  ): IO[
    AwsError,
    zio.aws.ssm.model.RegisterDefaultPatchBaselineResponse.ReadOnly
  ]
  def listDocumentMetadataHistory(
      request: zio.aws.ssm.model.ListDocumentMetadataHistoryRequest
  ): IO[
    AwsError,
    zio.aws.ssm.model.ListDocumentMetadataHistoryResponse.ReadOnly
  ]
  def getParametersByPath(
      request: zio.aws.ssm.model.GetParametersByPathRequest
  ): ZStream[Any, AwsError, zio.aws.ssm.model.Parameter.ReadOnly]
  def getParametersByPathPaginated(
      request: zio.aws.ssm.model.GetParametersByPathRequest
  ): IO[AwsError, zio.aws.ssm.model.GetParametersByPathResponse.ReadOnly]
  def cancelMaintenanceWindowExecution(
      request: zio.aws.ssm.model.CancelMaintenanceWindowExecutionRequest
  ): IO[
    AwsError,
    zio.aws.ssm.model.CancelMaintenanceWindowExecutionResponse.ReadOnly
  ]
  def listTagsForResource(
      request: zio.aws.ssm.model.ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.ssm.model.ListTagsForResourceResponse.ReadOnly]
  def describeMaintenanceWindowExecutionTaskInvocations(
      request: zio.aws.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.ssm.model.MaintenanceWindowExecutionTaskInvocationIdentity.ReadOnly
  ]
  def describeMaintenanceWindowExecutionTaskInvocationsPaginated(
      request: zio.aws.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsRequest
  ): IO[
    AwsError,
    zio.aws.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsResponse.ReadOnly
  ]
  def updateAssociation(
      request: zio.aws.ssm.model.UpdateAssociationRequest
  ): IO[AwsError, zio.aws.ssm.model.UpdateAssociationResponse.ReadOnly]
  def startSession(
      request: zio.aws.ssm.model.StartSessionRequest
  ): IO[AwsError, zio.aws.ssm.model.StartSessionResponse.ReadOnly]
  def associateOpsItemRelatedItem(
      request: zio.aws.ssm.model.AssociateOpsItemRelatedItemRequest
  ): IO[
    AwsError,
    zio.aws.ssm.model.AssociateOpsItemRelatedItemResponse.ReadOnly
  ]
  def disassociateOpsItemRelatedItem(
      request: zio.aws.ssm.model.DisassociateOpsItemRelatedItemRequest
  ): IO[
    AwsError,
    zio.aws.ssm.model.DisassociateOpsItemRelatedItemResponse.ReadOnly
  ]
  def describeOpsItems(
      request: zio.aws.ssm.model.DescribeOpsItemsRequest
  ): ZStream[Any, AwsError, zio.aws.ssm.model.OpsItemSummary.ReadOnly]
  def describeOpsItemsPaginated(
      request: zio.aws.ssm.model.DescribeOpsItemsRequest
  ): IO[AwsError, zio.aws.ssm.model.DescribeOpsItemsResponse.ReadOnly]
  def describeEffectiveInstanceAssociations(
      request: zio.aws.ssm.model.DescribeEffectiveInstanceAssociationsRequest
  ): ZStream[Any, AwsError, zio.aws.ssm.model.InstanceAssociation.ReadOnly]
  def describeEffectiveInstanceAssociationsPaginated(
      request: zio.aws.ssm.model.DescribeEffectiveInstanceAssociationsRequest
  ): IO[
    AwsError,
    zio.aws.ssm.model.DescribeEffectiveInstanceAssociationsResponse.ReadOnly
  ]
  def listAssociationVersions(
      request: zio.aws.ssm.model.ListAssociationVersionsRequest
  ): ZStream[Any, AwsError, zio.aws.ssm.model.AssociationVersionInfo.ReadOnly]
  def listAssociationVersionsPaginated(
      request: zio.aws.ssm.model.ListAssociationVersionsRequest
  ): IO[AwsError, zio.aws.ssm.model.ListAssociationVersionsResponse.ReadOnly]
  def describeInstancePatches(
      request: zio.aws.ssm.model.DescribeInstancePatchesRequest
  ): ZStream[Any, AwsError, zio.aws.ssm.model.PatchComplianceData.ReadOnly]
  def describeInstancePatchesPaginated(
      request: zio.aws.ssm.model.DescribeInstancePatchesRequest
  ): IO[AwsError, zio.aws.ssm.model.DescribeInstancePatchesResponse.ReadOnly]
  def getDeployablePatchSnapshotForInstance(
      request: zio.aws.ssm.model.GetDeployablePatchSnapshotForInstanceRequest
  ): IO[
    AwsError,
    zio.aws.ssm.model.GetDeployablePatchSnapshotForInstanceResponse.ReadOnly
  ]
  def putComplianceItems(
      request: zio.aws.ssm.model.PutComplianceItemsRequest
  ): IO[AwsError, zio.aws.ssm.model.PutComplianceItemsResponse.ReadOnly]
  def deleteActivation(
      request: zio.aws.ssm.model.DeleteActivationRequest
  ): IO[AwsError, zio.aws.ssm.model.DeleteActivationResponse.ReadOnly]
  def listOpsItemRelatedItems(
      request: zio.aws.ssm.model.ListOpsItemRelatedItemsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.ssm.model.OpsItemRelatedItemSummary.ReadOnly
  ]
  def listOpsItemRelatedItemsPaginated(
      request: zio.aws.ssm.model.ListOpsItemRelatedItemsRequest
  ): IO[AwsError, zio.aws.ssm.model.ListOpsItemRelatedItemsResponse.ReadOnly]
  def deleteParameter(
      request: zio.aws.ssm.model.DeleteParameterRequest
  ): IO[AwsError, zio.aws.ssm.model.DeleteParameterResponse.ReadOnly]
  def describeInventoryDeletions(
      request: zio.aws.ssm.model.DescribeInventoryDeletionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.ssm.model.InventoryDeletionStatusItem.ReadOnly
  ]
  def describeInventoryDeletionsPaginated(
      request: zio.aws.ssm.model.DescribeInventoryDeletionsRequest
  ): IO[AwsError, zio.aws.ssm.model.DescribeInventoryDeletionsResponse.ReadOnly]
  def getCommandInvocation(
      request: zio.aws.ssm.model.GetCommandInvocationRequest
  ): IO[AwsError, zio.aws.ssm.model.GetCommandInvocationResponse.ReadOnly]
  def updateAssociationStatus(
      request: zio.aws.ssm.model.UpdateAssociationStatusRequest
  ): IO[AwsError, zio.aws.ssm.model.UpdateAssociationStatusResponse.ReadOnly]
  def updateOpsMetadata(
      request: zio.aws.ssm.model.UpdateOpsMetadataRequest
  ): IO[AwsError, zio.aws.ssm.model.UpdateOpsMetadataResponse.ReadOnly]
  def describePatchBaselines(
      request: zio.aws.ssm.model.DescribePatchBaselinesRequest
  ): ZStream[Any, AwsError, zio.aws.ssm.model.PatchBaselineIdentity.ReadOnly]
  def describePatchBaselinesPaginated(
      request: zio.aws.ssm.model.DescribePatchBaselinesRequest
  ): IO[AwsError, zio.aws.ssm.model.DescribePatchBaselinesResponse.ReadOnly]
  def describeEffectivePatchesForPatchBaseline(
      request: zio.aws.ssm.model.DescribeEffectivePatchesForPatchBaselineRequest
  ): ZStream[Any, AwsError, zio.aws.ssm.model.EffectivePatch.ReadOnly]
  def describeEffectivePatchesForPatchBaselinePaginated(
      request: zio.aws.ssm.model.DescribeEffectivePatchesForPatchBaselineRequest
  ): IO[
    AwsError,
    zio.aws.ssm.model.DescribeEffectivePatchesForPatchBaselineResponse.ReadOnly
  ]
  def createActivation(
      request: zio.aws.ssm.model.CreateActivationRequest
  ): IO[AwsError, zio.aws.ssm.model.CreateActivationResponse.ReadOnly]
  def getMaintenanceWindowExecution(
      request: zio.aws.ssm.model.GetMaintenanceWindowExecutionRequest
  ): IO[
    AwsError,
    zio.aws.ssm.model.GetMaintenanceWindowExecutionResponse.ReadOnly
  ]
  def deregisterTaskFromMaintenanceWindow(
      request: zio.aws.ssm.model.DeregisterTaskFromMaintenanceWindowRequest
  ): IO[
    AwsError,
    zio.aws.ssm.model.DeregisterTaskFromMaintenanceWindowResponse.ReadOnly
  ]
  def deleteDocument(
      request: zio.aws.ssm.model.DeleteDocumentRequest
  ): IO[AwsError, zio.aws.ssm.model.DeleteDocumentResponse.ReadOnly]
  def createResourceDataSync(
      request: zio.aws.ssm.model.CreateResourceDataSyncRequest
  ): IO[AwsError, zio.aws.ssm.model.CreateResourceDataSyncResponse.ReadOnly]
  def getMaintenanceWindowExecutionTaskInvocation(
      request: zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskInvocationRequest
  ): IO[
    AwsError,
    zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskInvocationResponse.ReadOnly
  ]
  def deregisterManagedInstance(
      request: zio.aws.ssm.model.DeregisterManagedInstanceRequest
  ): IO[AwsError, zio.aws.ssm.model.DeregisterManagedInstanceResponse.ReadOnly]
  def updateOpsItem(
      request: zio.aws.ssm.model.UpdateOpsItemRequest
  ): IO[AwsError, zio.aws.ssm.model.UpdateOpsItemResponse.ReadOnly]
  def deleteOpsMetadata(
      request: zio.aws.ssm.model.DeleteOpsMetadataRequest
  ): IO[AwsError, zio.aws.ssm.model.DeleteOpsMetadataResponse.ReadOnly]
  def describeAvailablePatches(
      request: zio.aws.ssm.model.DescribeAvailablePatchesRequest
  ): ZStream[Any, AwsError, zio.aws.ssm.model.Patch.ReadOnly]
  def describeAvailablePatchesPaginated(
      request: zio.aws.ssm.model.DescribeAvailablePatchesRequest
  ): IO[AwsError, zio.aws.ssm.model.DescribeAvailablePatchesResponse.ReadOnly]
  def listComplianceSummaries(
      request: zio.aws.ssm.model.ListComplianceSummariesRequest
  ): ZStream[Any, AwsError, zio.aws.ssm.model.ComplianceSummaryItem.ReadOnly]
  def listComplianceSummariesPaginated(
      request: zio.aws.ssm.model.ListComplianceSummariesRequest
  ): IO[AwsError, zio.aws.ssm.model.ListComplianceSummariesResponse.ReadOnly]
  def deletePatchBaseline(
      request: zio.aws.ssm.model.DeletePatchBaselineRequest
  ): IO[AwsError, zio.aws.ssm.model.DeletePatchBaselineResponse.ReadOnly]
  def createOpsMetadata(
      request: zio.aws.ssm.model.CreateOpsMetadataRequest
  ): IO[AwsError, zio.aws.ssm.model.CreateOpsMetadataResponse.ReadOnly]
  def deregisterTargetFromMaintenanceWindow(
      request: zio.aws.ssm.model.DeregisterTargetFromMaintenanceWindowRequest
  ): IO[
    AwsError,
    zio.aws.ssm.model.DeregisterTargetFromMaintenanceWindowResponse.ReadOnly
  ]
  def putParameter(
      request: zio.aws.ssm.model.PutParameterRequest
  ): IO[AwsError, zio.aws.ssm.model.PutParameterResponse.ReadOnly]
  def describeDocumentPermission(
      request: zio.aws.ssm.model.DescribeDocumentPermissionRequest
  ): IO[AwsError, zio.aws.ssm.model.DescribeDocumentPermissionResponse.ReadOnly]
  def resetServiceSetting(
      request: zio.aws.ssm.model.ResetServiceSettingRequest
  ): IO[AwsError, zio.aws.ssm.model.ResetServiceSettingResponse.ReadOnly]
  def updateResourceDataSync(
      request: zio.aws.ssm.model.UpdateResourceDataSyncRequest
  ): IO[AwsError, zio.aws.ssm.model.UpdateResourceDataSyncResponse.ReadOnly]
  def unlabelParameterVersion(
      request: zio.aws.ssm.model.UnlabelParameterVersionRequest
  ): IO[AwsError, zio.aws.ssm.model.UnlabelParameterVersionResponse.ReadOnly]
  def getInventorySchema(
      request: zio.aws.ssm.model.GetInventorySchemaRequest
  ): ZStream[Any, AwsError, zio.aws.ssm.model.InventoryItemSchema.ReadOnly]
  def getInventorySchemaPaginated(
      request: zio.aws.ssm.model.GetInventorySchemaRequest
  ): IO[AwsError, zio.aws.ssm.model.GetInventorySchemaResponse.ReadOnly]
  def getCalendarState(
      request: zio.aws.ssm.model.GetCalendarStateRequest
  ): IO[AwsError, zio.aws.ssm.model.GetCalendarStateResponse.ReadOnly]
  def listCommandInvocations(
      request: zio.aws.ssm.model.ListCommandInvocationsRequest
  ): ZStream[Any, AwsError, zio.aws.ssm.model.CommandInvocation.ReadOnly]
  def listCommandInvocationsPaginated(
      request: zio.aws.ssm.model.ListCommandInvocationsRequest
  ): IO[AwsError, zio.aws.ssm.model.ListCommandInvocationsResponse.ReadOnly]
  def deleteResourceDataSync(
      request: zio.aws.ssm.model.DeleteResourceDataSyncRequest
  ): IO[AwsError, zio.aws.ssm.model.DeleteResourceDataSyncResponse.ReadOnly]
  def updatePatchBaseline(
      request: zio.aws.ssm.model.UpdatePatchBaselineRequest
  ): IO[AwsError, zio.aws.ssm.model.UpdatePatchBaselineResponse.ReadOnly]
}
object Ssm {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Ssm] = customized(identity)
  def customized(
      customization: SsmAsyncClientBuilder => SsmAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Ssm] = managed(
    customization
  ).toLayer
  def managed(
      customization: SsmAsyncClientBuilder => SsmAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, Ssm] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = SsmAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[SsmAsyncClient, SsmAsyncClientBuilder](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[SsmAsyncClient, SsmAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  ) yield new SsmImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class SsmImpl[R](
      override val api: SsmAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Ssm
      with AwsServiceBase[R] {
    override val serviceName: String = "Ssm"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): SsmImpl[R1] = new SsmImpl(api, newAspect, r)
    def deleteInventory(
        request: zio.aws.ssm.model.DeleteInventoryRequest
    ): IO[AwsError, zio.aws.ssm.model.DeleteInventoryResponse.ReadOnly] =
      asyncRequestResponse[DeleteInventoryRequest, DeleteInventoryResponse](
        "deleteInventory",
        api.deleteInventory
      )(request.buildAwsValue())
        .map(zio.aws.ssm.model.DeleteInventoryResponse.wrap)
        .provideEnvironment(r)
    def describeAutomationStepExecutions(
        request: zio.aws.ssm.model.DescribeAutomationStepExecutionsRequest
    ): ZStream[Any, AwsError, zio.aws.ssm.model.StepExecution.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeAutomationStepExecutionsRequest,
        DescribeAutomationStepExecutionsResponse,
        StepExecution
      ](
        "describeAutomationStepExecutions",
        api.describeAutomationStepExecutions,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.stepExecutions().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ssm.model.StepExecution.wrap(item))
        .provideEnvironment(r)
    def describeAutomationStepExecutionsPaginated(
        request: zio.aws.ssm.model.DescribeAutomationStepExecutionsRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.DescribeAutomationStepExecutionsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeAutomationStepExecutionsRequest,
      DescribeAutomationStepExecutionsResponse
    ]("describeAutomationStepExecutions", api.describeAutomationStepExecutions)(
      request.buildAwsValue()
    ).map(zio.aws.ssm.model.DescribeAutomationStepExecutionsResponse.wrap)
      .provideEnvironment(r)
    def deleteParameters(
        request: zio.aws.ssm.model.DeleteParametersRequest
    ): IO[AwsError, zio.aws.ssm.model.DeleteParametersResponse.ReadOnly] =
      asyncRequestResponse[DeleteParametersRequest, DeleteParametersResponse](
        "deleteParameters",
        api.deleteParameters
      )(request.buildAwsValue())
        .map(zio.aws.ssm.model.DeleteParametersResponse.wrap)
        .provideEnvironment(r)
    def getParameterHistory(
        request: zio.aws.ssm.model.GetParameterHistoryRequest
    ): ZStream[Any, AwsError, zio.aws.ssm.model.ParameterHistory.ReadOnly] =
      asyncSimplePaginatedRequest[
        GetParameterHistoryRequest,
        GetParameterHistoryResponse,
        ParameterHistory
      ](
        "getParameterHistory",
        api.getParameterHistory,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.parameters().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ssm.model.ParameterHistory.wrap(item))
        .provideEnvironment(r)
    def getParameterHistoryPaginated(
        request: zio.aws.ssm.model.GetParameterHistoryRequest
    ): IO[AwsError, zio.aws.ssm.model.GetParameterHistoryResponse.ReadOnly] =
      asyncRequestResponse[
        GetParameterHistoryRequest,
        GetParameterHistoryResponse
      ]("getParameterHistory", api.getParameterHistory)(request.buildAwsValue())
        .map(zio.aws.ssm.model.GetParameterHistoryResponse.wrap)
        .provideEnvironment(r)
    def addTagsToResource(
        request: zio.aws.ssm.model.AddTagsToResourceRequest
    ): IO[AwsError, zio.aws.ssm.model.AddTagsToResourceResponse.ReadOnly] =
      asyncRequestResponse[AddTagsToResourceRequest, AddTagsToResourceResponse](
        "addTagsToResource",
        api.addTagsToResource
      )(request.buildAwsValue())
        .map(zio.aws.ssm.model.AddTagsToResourceResponse.wrap)
        .provideEnvironment(r)
    def describeSessions(
        request: zio.aws.ssm.model.DescribeSessionsRequest
    ): ZStream[Any, AwsError, zio.aws.ssm.model.Session.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeSessionsRequest,
        DescribeSessionsResponse,
        Session
      ](
        "describeSessions",
        api.describeSessions,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.sessions().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ssm.model.Session.wrap(item))
        .provideEnvironment(r)
    def describeSessionsPaginated(
        request: zio.aws.ssm.model.DescribeSessionsRequest
    ): IO[AwsError, zio.aws.ssm.model.DescribeSessionsResponse.ReadOnly] =
      asyncRequestResponse[DescribeSessionsRequest, DescribeSessionsResponse](
        "describeSessions",
        api.describeSessions
      )(request.buildAwsValue())
        .map(zio.aws.ssm.model.DescribeSessionsResponse.wrap)
        .provideEnvironment(r)
    def listResourceDataSync(
        request: zio.aws.ssm.model.ListResourceDataSyncRequest
    ): ZStream[Any, AwsError, zio.aws.ssm.model.ResourceDataSyncItem.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListResourceDataSyncRequest,
        ListResourceDataSyncResponse,
        ResourceDataSyncItem
      ](
        "listResourceDataSync",
        api.listResourceDataSync,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.resourceDataSyncItems().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ssm.model.ResourceDataSyncItem.wrap(item))
        .provideEnvironment(r)
    def listResourceDataSyncPaginated(
        request: zio.aws.ssm.model.ListResourceDataSyncRequest
    ): IO[AwsError, zio.aws.ssm.model.ListResourceDataSyncResponse.ReadOnly] =
      asyncRequestResponse[
        ListResourceDataSyncRequest,
        ListResourceDataSyncResponse
      ]("listResourceDataSync", api.listResourceDataSync)(
        request.buildAwsValue()
      ).map(zio.aws.ssm.model.ListResourceDataSyncResponse.wrap)
        .provideEnvironment(r)
    def getOpsMetadata(
        request: zio.aws.ssm.model.GetOpsMetadataRequest
    ): IO[AwsError, StreamingOutputResult[
      Any,
      zio.aws.ssm.model.GetOpsMetadataResponse.ReadOnly,
      Tuple2[MetadataKey, zio.aws.ssm.model.MetadataValue.ReadOnly]
    ]] = asyncPaginatedRequest[
      GetOpsMetadataRequest,
      GetOpsMetadataResponse,
      (java.lang.String, MetadataValue)
    ](
      "getOpsMetadata",
      api.getOpsMetadata,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.metadata().asScala)
    )(request.buildAwsValue())
      .map { result =>
        result
          .mapResponse(zio.aws.ssm.model.GetOpsMetadataResponse.wrap)
          .mapOutput(_.map({ case (key, value) =>
            zio.aws.ssm.model.primitives
              .MetadataKey(key) -> zio.aws.ssm.model.MetadataValue.wrap(value)
          }))
          .provideEnvironment(r)
      }
      .provideEnvironment(r)
    def getOpsMetadataPaginated(
        request: zio.aws.ssm.model.GetOpsMetadataRequest
    ): IO[AwsError, zio.aws.ssm.model.GetOpsMetadataResponse.ReadOnly] =
      asyncRequestResponse[GetOpsMetadataRequest, GetOpsMetadataResponse](
        "getOpsMetadata",
        api.getOpsMetadata
      )(request.buildAwsValue())
        .map(zio.aws.ssm.model.GetOpsMetadataResponse.wrap)
        .provideEnvironment(r)
    def deregisterPatchBaselineForPatchGroup(
        request: zio.aws.ssm.model.DeregisterPatchBaselineForPatchGroupRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.DeregisterPatchBaselineForPatchGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      DeregisterPatchBaselineForPatchGroupRequest,
      DeregisterPatchBaselineForPatchGroupResponse
    ](
      "deregisterPatchBaselineForPatchGroup",
      api.deregisterPatchBaselineForPatchGroup
    )(request.buildAwsValue())
      .map(zio.aws.ssm.model.DeregisterPatchBaselineForPatchGroupResponse.wrap)
      .provideEnvironment(r)
    def stopAutomationExecution(
        request: zio.aws.ssm.model.StopAutomationExecutionRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.StopAutomationExecutionResponse.ReadOnly
    ] = asyncRequestResponse[
      StopAutomationExecutionRequest,
      StopAutomationExecutionResponse
    ]("stopAutomationExecution", api.stopAutomationExecution)(
      request.buildAwsValue()
    ).map(zio.aws.ssm.model.StopAutomationExecutionResponse.wrap)
      .provideEnvironment(r)
    def describeInstanceAssociationsStatus(
        request: zio.aws.ssm.model.DescribeInstanceAssociationsStatusRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ssm.model.InstanceAssociationStatusInfo.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeInstanceAssociationsStatusRequest,
      DescribeInstanceAssociationsStatusResponse,
      InstanceAssociationStatusInfo
    ](
      "describeInstanceAssociationsStatus",
      api.describeInstanceAssociationsStatus,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.instanceAssociationStatusInfos().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ssm.model.InstanceAssociationStatusInfo.wrap(item))
      .provideEnvironment(r)
    def describeInstanceAssociationsStatusPaginated(
        request: zio.aws.ssm.model.DescribeInstanceAssociationsStatusRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.DescribeInstanceAssociationsStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeInstanceAssociationsStatusRequest,
      DescribeInstanceAssociationsStatusResponse
    ](
      "describeInstanceAssociationsStatus",
      api.describeInstanceAssociationsStatus
    )(request.buildAwsValue())
      .map(zio.aws.ssm.model.DescribeInstanceAssociationsStatusResponse.wrap)
      .provideEnvironment(r)
    def describeMaintenanceWindowsForTarget(
        request: zio.aws.ssm.model.DescribeMaintenanceWindowsForTargetRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ssm.model.MaintenanceWindowIdentityForTarget.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeMaintenanceWindowsForTargetRequest,
      DescribeMaintenanceWindowsForTargetResponse,
      MaintenanceWindowIdentityForTarget
    ](
      "describeMaintenanceWindowsForTarget",
      api.describeMaintenanceWindowsForTarget,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.windowIdentities().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.ssm.model.MaintenanceWindowIdentityForTarget.wrap(item)
      )
      .provideEnvironment(r)
    def describeMaintenanceWindowsForTargetPaginated(
        request: zio.aws.ssm.model.DescribeMaintenanceWindowsForTargetRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.DescribeMaintenanceWindowsForTargetResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeMaintenanceWindowsForTargetRequest,
      DescribeMaintenanceWindowsForTargetResponse
    ](
      "describeMaintenanceWindowsForTarget",
      api.describeMaintenanceWindowsForTarget
    )(request.buildAwsValue())
      .map(zio.aws.ssm.model.DescribeMaintenanceWindowsForTargetResponse.wrap)
      .provideEnvironment(r)
    def getParameters(
        request: zio.aws.ssm.model.GetParametersRequest
    ): IO[AwsError, zio.aws.ssm.model.GetParametersResponse.ReadOnly] =
      asyncRequestResponse[GetParametersRequest, GetParametersResponse](
        "getParameters",
        api.getParameters
      )(request.buildAwsValue())
        .map(zio.aws.ssm.model.GetParametersResponse.wrap)
        .provideEnvironment(r)
    def describeInstancePatchStates(
        request: zio.aws.ssm.model.DescribeInstancePatchStatesRequest
    ): ZStream[Any, AwsError, zio.aws.ssm.model.InstancePatchState.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeInstancePatchStatesRequest,
        DescribeInstancePatchStatesResponse,
        InstancePatchState
      ](
        "describeInstancePatchStates",
        api.describeInstancePatchStates,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.instancePatchStates().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ssm.model.InstancePatchState.wrap(item))
        .provideEnvironment(r)
    def describeInstancePatchStatesPaginated(
        request: zio.aws.ssm.model.DescribeInstancePatchStatesRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.DescribeInstancePatchStatesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeInstancePatchStatesRequest,
      DescribeInstancePatchStatesResponse
    ]("describeInstancePatchStates", api.describeInstancePatchStates)(
      request.buildAwsValue()
    ).map(zio.aws.ssm.model.DescribeInstancePatchStatesResponse.wrap)
      .provideEnvironment(r)
    def listInventoryEntries(
        request: zio.aws.ssm.model.ListInventoryEntriesRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.ssm.model.ListInventoryEntriesResponse.ReadOnly,
      Map[AttributeName, AttributeValue]
    ]] = asyncPaginatedRequest[
      ListInventoryEntriesRequest,
      ListInventoryEntriesResponse,
      java.util.Map[java.lang.String, java.lang.String]
    ](
      "listInventoryEntries",
      api.listInventoryEntries,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.entries().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.ssm.model.ListInventoryEntriesResponse.wrap)
          .mapOutput(
            _.map(item =>
              item.asScala
                .map({ case (key, value) =>
                  zio.aws.ssm.model.primitives.AttributeName(
                    key
                  ) -> zio.aws.ssm.model.primitives.AttributeValue(value)
                })
                .toMap
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listInventoryEntriesPaginated(
        request: zio.aws.ssm.model.ListInventoryEntriesRequest
    ): IO[AwsError, zio.aws.ssm.model.ListInventoryEntriesResponse.ReadOnly] =
      asyncRequestResponse[
        ListInventoryEntriesRequest,
        ListInventoryEntriesResponse
      ]("listInventoryEntries", api.listInventoryEntries)(
        request.buildAwsValue()
      ).map(zio.aws.ssm.model.ListInventoryEntriesResponse.wrap)
        .provideEnvironment(r)
    def describeMaintenanceWindowExecutions(
        request: zio.aws.ssm.model.DescribeMaintenanceWindowExecutionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ssm.model.MaintenanceWindowExecution.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeMaintenanceWindowExecutionsRequest,
      DescribeMaintenanceWindowExecutionsResponse,
      MaintenanceWindowExecution
    ](
      "describeMaintenanceWindowExecutions",
      api.describeMaintenanceWindowExecutions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.windowExecutions().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ssm.model.MaintenanceWindowExecution.wrap(item))
      .provideEnvironment(r)
    def describeMaintenanceWindowExecutionsPaginated(
        request: zio.aws.ssm.model.DescribeMaintenanceWindowExecutionsRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.DescribeMaintenanceWindowExecutionsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeMaintenanceWindowExecutionsRequest,
      DescribeMaintenanceWindowExecutionsResponse
    ](
      "describeMaintenanceWindowExecutions",
      api.describeMaintenanceWindowExecutions
    )(request.buildAwsValue())
      .map(zio.aws.ssm.model.DescribeMaintenanceWindowExecutionsResponse.wrap)
      .provideEnvironment(r)
    def describeAssociationExecutions(
        request: zio.aws.ssm.model.DescribeAssociationExecutionsRequest
    ): ZStream[Any, AwsError, zio.aws.ssm.model.AssociationExecution.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeAssociationExecutionsRequest,
        DescribeAssociationExecutionsResponse,
        AssociationExecution
      ](
        "describeAssociationExecutions",
        api.describeAssociationExecutions,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.associationExecutions().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ssm.model.AssociationExecution.wrap(item))
        .provideEnvironment(r)
    def describeAssociationExecutionsPaginated(
        request: zio.aws.ssm.model.DescribeAssociationExecutionsRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.DescribeAssociationExecutionsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeAssociationExecutionsRequest,
      DescribeAssociationExecutionsResponse
    ]("describeAssociationExecutions", api.describeAssociationExecutions)(
      request.buildAwsValue()
    ).map(zio.aws.ssm.model.DescribeAssociationExecutionsResponse.wrap)
      .provideEnvironment(r)
    def listComplianceItems(
        request: zio.aws.ssm.model.ListComplianceItemsRequest
    ): ZStream[Any, AwsError, zio.aws.ssm.model.ComplianceItem.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListComplianceItemsRequest,
        ListComplianceItemsResponse,
        ComplianceItem
      ](
        "listComplianceItems",
        api.listComplianceItems,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.complianceItems().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ssm.model.ComplianceItem.wrap(item))
        .provideEnvironment(r)
    def listComplianceItemsPaginated(
        request: zio.aws.ssm.model.ListComplianceItemsRequest
    ): IO[AwsError, zio.aws.ssm.model.ListComplianceItemsResponse.ReadOnly] =
      asyncRequestResponse[
        ListComplianceItemsRequest,
        ListComplianceItemsResponse
      ]("listComplianceItems", api.listComplianceItems)(request.buildAwsValue())
        .map(zio.aws.ssm.model.ListComplianceItemsResponse.wrap)
        .provideEnvironment(r)
    def describeMaintenanceWindowTasks(
        request: zio.aws.ssm.model.DescribeMaintenanceWindowTasksRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ssm.model.MaintenanceWindowTask.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeMaintenanceWindowTasksRequest,
      DescribeMaintenanceWindowTasksResponse,
      MaintenanceWindowTask
    ](
      "describeMaintenanceWindowTasks",
      api.describeMaintenanceWindowTasks,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.tasks().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ssm.model.MaintenanceWindowTask.wrap(item))
      .provideEnvironment(r)
    def describeMaintenanceWindowTasksPaginated(
        request: zio.aws.ssm.model.DescribeMaintenanceWindowTasksRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.DescribeMaintenanceWindowTasksResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeMaintenanceWindowTasksRequest,
      DescribeMaintenanceWindowTasksResponse
    ]("describeMaintenanceWindowTasks", api.describeMaintenanceWindowTasks)(
      request.buildAwsValue()
    ).map(zio.aws.ssm.model.DescribeMaintenanceWindowTasksResponse.wrap)
      .provideEnvironment(r)
    def deleteMaintenanceWindow(
        request: zio.aws.ssm.model.DeleteMaintenanceWindowRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.DeleteMaintenanceWindowResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteMaintenanceWindowRequest,
      DeleteMaintenanceWindowResponse
    ]("deleteMaintenanceWindow", api.deleteMaintenanceWindow)(
      request.buildAwsValue()
    ).map(zio.aws.ssm.model.DeleteMaintenanceWindowResponse.wrap)
      .provideEnvironment(r)
    def describePatchGroupState(
        request: zio.aws.ssm.model.DescribePatchGroupStateRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.DescribePatchGroupStateResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribePatchGroupStateRequest,
      DescribePatchGroupStateResponse
    ]("describePatchGroupState", api.describePatchGroupState)(
      request.buildAwsValue()
    ).map(zio.aws.ssm.model.DescribePatchGroupStateResponse.wrap)
      .provideEnvironment(r)
    def describeParameters(
        request: zio.aws.ssm.model.DescribeParametersRequest
    ): ZStream[Any, AwsError, zio.aws.ssm.model.ParameterMetadata.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeParametersRequest,
        DescribeParametersResponse,
        ParameterMetadata
      ](
        "describeParameters",
        api.describeParameters,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.parameters().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ssm.model.ParameterMetadata.wrap(item))
        .provideEnvironment(r)
    def describeParametersPaginated(
        request: zio.aws.ssm.model.DescribeParametersRequest
    ): IO[AwsError, zio.aws.ssm.model.DescribeParametersResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeParametersRequest,
        DescribeParametersResponse
      ]("describeParameters", api.describeParameters)(request.buildAwsValue())
        .map(zio.aws.ssm.model.DescribeParametersResponse.wrap)
        .provideEnvironment(r)
    def listOpsItemEvents(
        request: zio.aws.ssm.model.ListOpsItemEventsRequest
    ): ZStream[Any, AwsError, zio.aws.ssm.model.OpsItemEventSummary.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListOpsItemEventsRequest,
        ListOpsItemEventsResponse,
        OpsItemEventSummary
      ](
        "listOpsItemEvents",
        api.listOpsItemEvents,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.summaries().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ssm.model.OpsItemEventSummary.wrap(item))
        .provideEnvironment(r)
    def listOpsItemEventsPaginated(
        request: zio.aws.ssm.model.ListOpsItemEventsRequest
    ): IO[AwsError, zio.aws.ssm.model.ListOpsItemEventsResponse.ReadOnly] =
      asyncRequestResponse[ListOpsItemEventsRequest, ListOpsItemEventsResponse](
        "listOpsItemEvents",
        api.listOpsItemEvents
      )(request.buildAwsValue())
        .map(zio.aws.ssm.model.ListOpsItemEventsResponse.wrap)
        .provideEnvironment(r)
    def getDocument(
        request: zio.aws.ssm.model.GetDocumentRequest
    ): IO[AwsError, zio.aws.ssm.model.GetDocumentResponse.ReadOnly] =
      asyncRequestResponse[GetDocumentRequest, GetDocumentResponse](
        "getDocument",
        api.getDocument
      )(request.buildAwsValue())
        .map(zio.aws.ssm.model.GetDocumentResponse.wrap)
        .provideEnvironment(r)
    def createDocument(
        request: zio.aws.ssm.model.CreateDocumentRequest
    ): IO[AwsError, zio.aws.ssm.model.CreateDocumentResponse.ReadOnly] =
      asyncRequestResponse[CreateDocumentRequest, CreateDocumentResponse](
        "createDocument",
        api.createDocument
      )(request.buildAwsValue())
        .map(zio.aws.ssm.model.CreateDocumentResponse.wrap)
        .provideEnvironment(r)
    def modifyDocumentPermission(
        request: zio.aws.ssm.model.ModifyDocumentPermissionRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.ModifyDocumentPermissionResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifyDocumentPermissionRequest,
      ModifyDocumentPermissionResponse
    ]("modifyDocumentPermission", api.modifyDocumentPermission)(
      request.buildAwsValue()
    ).map(zio.aws.ssm.model.ModifyDocumentPermissionResponse.wrap)
      .provideEnvironment(r)
    def registerTargetWithMaintenanceWindow(
        request: zio.aws.ssm.model.RegisterTargetWithMaintenanceWindowRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.RegisterTargetWithMaintenanceWindowResponse.ReadOnly
    ] = asyncRequestResponse[
      RegisterTargetWithMaintenanceWindowRequest,
      RegisterTargetWithMaintenanceWindowResponse
    ](
      "registerTargetWithMaintenanceWindow",
      api.registerTargetWithMaintenanceWindow
    )(request.buildAwsValue())
      .map(zio.aws.ssm.model.RegisterTargetWithMaintenanceWindowResponse.wrap)
      .provideEnvironment(r)
    def terminateSession(
        request: zio.aws.ssm.model.TerminateSessionRequest
    ): IO[AwsError, zio.aws.ssm.model.TerminateSessionResponse.ReadOnly] =
      asyncRequestResponse[TerminateSessionRequest, TerminateSessionResponse](
        "terminateSession",
        api.terminateSession
      )(request.buildAwsValue())
        .map(zio.aws.ssm.model.TerminateSessionResponse.wrap)
        .provideEnvironment(r)
    def removeTagsFromResource(
        request: zio.aws.ssm.model.RemoveTagsFromResourceRequest
    ): IO[AwsError, zio.aws.ssm.model.RemoveTagsFromResourceResponse.ReadOnly] =
      asyncRequestResponse[
        RemoveTagsFromResourceRequest,
        RemoveTagsFromResourceResponse
      ]("removeTagsFromResource", api.removeTagsFromResource)(
        request.buildAwsValue()
      ).map(zio.aws.ssm.model.RemoveTagsFromResourceResponse.wrap)
        .provideEnvironment(r)
    def startChangeRequestExecution(
        request: zio.aws.ssm.model.StartChangeRequestExecutionRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.StartChangeRequestExecutionResponse.ReadOnly
    ] = asyncRequestResponse[
      StartChangeRequestExecutionRequest,
      StartChangeRequestExecutionResponse
    ]("startChangeRequestExecution", api.startChangeRequestExecution)(
      request.buildAwsValue()
    ).map(zio.aws.ssm.model.StartChangeRequestExecutionResponse.wrap)
      .provideEnvironment(r)
    def describeActivations(
        request: zio.aws.ssm.model.DescribeActivationsRequest
    ): ZStream[Any, AwsError, zio.aws.ssm.model.Activation.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeActivationsRequest,
        DescribeActivationsResponse,
        Activation
      ](
        "describeActivations",
        api.describeActivations,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.activationList().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ssm.model.Activation.wrap(item))
        .provideEnvironment(r)
    def describeActivationsPaginated(
        request: zio.aws.ssm.model.DescribeActivationsRequest
    ): IO[AwsError, zio.aws.ssm.model.DescribeActivationsResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeActivationsRequest,
        DescribeActivationsResponse
      ]("describeActivations", api.describeActivations)(request.buildAwsValue())
        .map(zio.aws.ssm.model.DescribeActivationsResponse.wrap)
        .provideEnvironment(r)
    def sendAutomationSignal(
        request: zio.aws.ssm.model.SendAutomationSignalRequest
    ): IO[AwsError, zio.aws.ssm.model.SendAutomationSignalResponse.ReadOnly] =
      asyncRequestResponse[
        SendAutomationSignalRequest,
        SendAutomationSignalResponse
      ]("sendAutomationSignal", api.sendAutomationSignal)(
        request.buildAwsValue()
      ).map(zio.aws.ssm.model.SendAutomationSignalResponse.wrap)
        .provideEnvironment(r)
    def createMaintenanceWindow(
        request: zio.aws.ssm.model.CreateMaintenanceWindowRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.CreateMaintenanceWindowResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateMaintenanceWindowRequest,
      CreateMaintenanceWindowResponse
    ]("createMaintenanceWindow", api.createMaintenanceWindow)(
      request.buildAwsValue()
    ).map(zio.aws.ssm.model.CreateMaintenanceWindowResponse.wrap)
      .provideEnvironment(r)
    def cancelCommand(
        request: zio.aws.ssm.model.CancelCommandRequest
    ): IO[AwsError, zio.aws.ssm.model.CancelCommandResponse.ReadOnly] =
      asyncRequestResponse[CancelCommandRequest, CancelCommandResponse](
        "cancelCommand",
        api.cancelCommand
      )(request.buildAwsValue())
        .map(zio.aws.ssm.model.CancelCommandResponse.wrap)
        .provideEnvironment(r)
    def getMaintenanceWindow(
        request: zio.aws.ssm.model.GetMaintenanceWindowRequest
    ): IO[AwsError, zio.aws.ssm.model.GetMaintenanceWindowResponse.ReadOnly] =
      asyncRequestResponse[
        GetMaintenanceWindowRequest,
        GetMaintenanceWindowResponse
      ]("getMaintenanceWindow", api.getMaintenanceWindow)(
        request.buildAwsValue()
      ).map(zio.aws.ssm.model.GetMaintenanceWindowResponse.wrap)
        .provideEnvironment(r)
    def describeAssociation(
        request: zio.aws.ssm.model.DescribeAssociationRequest
    ): IO[AwsError, zio.aws.ssm.model.DescribeAssociationResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeAssociationRequest,
        DescribeAssociationResponse
      ]("describeAssociation", api.describeAssociation)(request.buildAwsValue())
        .map(zio.aws.ssm.model.DescribeAssociationResponse.wrap)
        .provideEnvironment(r)
    def getMaintenanceWindowExecutionTask(
        request: zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskResponse.ReadOnly
    ] = asyncRequestResponse[
      GetMaintenanceWindowExecutionTaskRequest,
      GetMaintenanceWindowExecutionTaskResponse
    ](
      "getMaintenanceWindowExecutionTask",
      api.getMaintenanceWindowExecutionTask
    )(request.buildAwsValue())
      .map(zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskResponse.wrap)
      .provideEnvironment(r)
    def labelParameterVersion(
        request: zio.aws.ssm.model.LabelParameterVersionRequest
    ): IO[AwsError, zio.aws.ssm.model.LabelParameterVersionResponse.ReadOnly] =
      asyncRequestResponse[
        LabelParameterVersionRequest,
        LabelParameterVersionResponse
      ]("labelParameterVersion", api.labelParameterVersion)(
        request.buildAwsValue()
      ).map(zio.aws.ssm.model.LabelParameterVersionResponse.wrap)
        .provideEnvironment(r)
    def describePatchProperties(
        request: zio.aws.ssm.model.DescribePatchPropertiesRequest
    ): ZStream[Any, AwsError, Map[AttributeName, AttributeValue]] =
      asyncSimplePaginatedRequest[
        DescribePatchPropertiesRequest,
        DescribePatchPropertiesResponse,
        java.util.Map[java.lang.String, java.lang.String]
      ](
        "describePatchProperties",
        api.describePatchProperties,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.properties().asScala)
      )(request.buildAwsValue())
        .map(item =>
          item.asScala
            .map({ case (key, value) =>
              zio.aws.ssm.model.primitives.AttributeName(
                key
              ) -> zio.aws.ssm.model.primitives.AttributeValue(value)
            })
            .toMap
        )
        .provideEnvironment(r)
    def describePatchPropertiesPaginated(
        request: zio.aws.ssm.model.DescribePatchPropertiesRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.DescribePatchPropertiesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribePatchPropertiesRequest,
      DescribePatchPropertiesResponse
    ]("describePatchProperties", api.describePatchProperties)(
      request.buildAwsValue()
    ).map(zio.aws.ssm.model.DescribePatchPropertiesResponse.wrap)
      .provideEnvironment(r)
    def describeMaintenanceWindowSchedule(
        request: zio.aws.ssm.model.DescribeMaintenanceWindowScheduleRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ssm.model.ScheduledWindowExecution.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeMaintenanceWindowScheduleRequest,
      DescribeMaintenanceWindowScheduleResponse,
      ScheduledWindowExecution
    ](
      "describeMaintenanceWindowSchedule",
      api.describeMaintenanceWindowSchedule,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.scheduledWindowExecutions().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ssm.model.ScheduledWindowExecution.wrap(item))
      .provideEnvironment(r)
    def describeMaintenanceWindowSchedulePaginated(
        request: zio.aws.ssm.model.DescribeMaintenanceWindowScheduleRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.DescribeMaintenanceWindowScheduleResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeMaintenanceWindowScheduleRequest,
      DescribeMaintenanceWindowScheduleResponse
    ](
      "describeMaintenanceWindowSchedule",
      api.describeMaintenanceWindowSchedule
    )(request.buildAwsValue())
      .map(zio.aws.ssm.model.DescribeMaintenanceWindowScheduleResponse.wrap)
      .provideEnvironment(r)
    def getDefaultPatchBaseline(
        request: zio.aws.ssm.model.GetDefaultPatchBaselineRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.GetDefaultPatchBaselineResponse.ReadOnly
    ] = asyncRequestResponse[
      GetDefaultPatchBaselineRequest,
      GetDefaultPatchBaselineResponse
    ]("getDefaultPatchBaseline", api.getDefaultPatchBaseline)(
      request.buildAwsValue()
    ).map(zio.aws.ssm.model.GetDefaultPatchBaselineResponse.wrap)
      .provideEnvironment(r)
    def updateDocumentMetadata(
        request: zio.aws.ssm.model.UpdateDocumentMetadataRequest
    ): IO[AwsError, zio.aws.ssm.model.UpdateDocumentMetadataResponse.ReadOnly] =
      asyncRequestResponse[
        UpdateDocumentMetadataRequest,
        UpdateDocumentMetadataResponse
      ]("updateDocumentMetadata", api.updateDocumentMetadata)(
        request.buildAwsValue()
      ).map(zio.aws.ssm.model.UpdateDocumentMetadataResponse.wrap)
        .provideEnvironment(r)
    def deleteAssociation(
        request: zio.aws.ssm.model.DeleteAssociationRequest
    ): IO[AwsError, zio.aws.ssm.model.DeleteAssociationResponse.ReadOnly] =
      asyncRequestResponse[DeleteAssociationRequest, DeleteAssociationResponse](
        "deleteAssociation",
        api.deleteAssociation
      )(request.buildAwsValue())
        .map(zio.aws.ssm.model.DeleteAssociationResponse.wrap)
        .provideEnvironment(r)
    def createAssociationBatch(
        request: zio.aws.ssm.model.CreateAssociationBatchRequest
    ): IO[AwsError, zio.aws.ssm.model.CreateAssociationBatchResponse.ReadOnly] =
      asyncRequestResponse[
        CreateAssociationBatchRequest,
        CreateAssociationBatchResponse
      ]("createAssociationBatch", api.createAssociationBatch)(
        request.buildAwsValue()
      ).map(zio.aws.ssm.model.CreateAssociationBatchResponse.wrap)
        .provideEnvironment(r)
    def getParameter(
        request: zio.aws.ssm.model.GetParameterRequest
    ): IO[AwsError, zio.aws.ssm.model.GetParameterResponse.ReadOnly] =
      asyncRequestResponse[GetParameterRequest, GetParameterResponse](
        "getParameter",
        api.getParameter
      )(request.buildAwsValue())
        .map(zio.aws.ssm.model.GetParameterResponse.wrap)
        .provideEnvironment(r)
    def registerTaskWithMaintenanceWindow(
        request: zio.aws.ssm.model.RegisterTaskWithMaintenanceWindowRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.RegisterTaskWithMaintenanceWindowResponse.ReadOnly
    ] = asyncRequestResponse[
      RegisterTaskWithMaintenanceWindowRequest,
      RegisterTaskWithMaintenanceWindowResponse
    ](
      "registerTaskWithMaintenanceWindow",
      api.registerTaskWithMaintenanceWindow
    )(request.buildAwsValue())
      .map(zio.aws.ssm.model.RegisterTaskWithMaintenanceWindowResponse.wrap)
      .provideEnvironment(r)
    def listOpsMetadata(
        request: zio.aws.ssm.model.ListOpsMetadataRequest
    ): ZStream[Any, AwsError, zio.aws.ssm.model.OpsMetadata.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListOpsMetadataRequest,
        ListOpsMetadataResponse,
        OpsMetadata
      ](
        "listOpsMetadata",
        api.listOpsMetadata,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.opsMetadataList().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ssm.model.OpsMetadata.wrap(item))
        .provideEnvironment(r)
    def listOpsMetadataPaginated(
        request: zio.aws.ssm.model.ListOpsMetadataRequest
    ): IO[AwsError, zio.aws.ssm.model.ListOpsMetadataResponse.ReadOnly] =
      asyncRequestResponse[ListOpsMetadataRequest, ListOpsMetadataResponse](
        "listOpsMetadata",
        api.listOpsMetadata
      )(request.buildAwsValue())
        .map(zio.aws.ssm.model.ListOpsMetadataResponse.wrap)
        .provideEnvironment(r)
    def registerPatchBaselineForPatchGroup(
        request: zio.aws.ssm.model.RegisterPatchBaselineForPatchGroupRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.RegisterPatchBaselineForPatchGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      RegisterPatchBaselineForPatchGroupRequest,
      RegisterPatchBaselineForPatchGroupResponse
    ](
      "registerPatchBaselineForPatchGroup",
      api.registerPatchBaselineForPatchGroup
    )(request.buildAwsValue())
      .map(zio.aws.ssm.model.RegisterPatchBaselineForPatchGroupResponse.wrap)
      .provideEnvironment(r)
    def describeInstancePatchStatesForPatchGroup(
        request: zio.aws.ssm.model.DescribeInstancePatchStatesForPatchGroupRequest
    ): ZStream[Any, AwsError, zio.aws.ssm.model.InstancePatchState.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeInstancePatchStatesForPatchGroupRequest,
        DescribeInstancePatchStatesForPatchGroupResponse,
        InstancePatchState
      ](
        "describeInstancePatchStatesForPatchGroup",
        api.describeInstancePatchStatesForPatchGroup,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.instancePatchStates().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ssm.model.InstancePatchState.wrap(item))
        .provideEnvironment(r)
    def describeInstancePatchStatesForPatchGroupPaginated(
        request: zio.aws.ssm.model.DescribeInstancePatchStatesForPatchGroupRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.DescribeInstancePatchStatesForPatchGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeInstancePatchStatesForPatchGroupRequest,
      DescribeInstancePatchStatesForPatchGroupResponse
    ](
      "describeInstancePatchStatesForPatchGroup",
      api.describeInstancePatchStatesForPatchGroup
    )(request.buildAwsValue())
      .map(
        zio.aws.ssm.model.DescribeInstancePatchStatesForPatchGroupResponse.wrap
      )
      .provideEnvironment(r)
    def listDocuments(
        request: zio.aws.ssm.model.ListDocumentsRequest
    ): ZStream[Any, AwsError, zio.aws.ssm.model.DocumentIdentifier.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListDocumentsRequest,
        ListDocumentsResponse,
        DocumentIdentifier
      ](
        "listDocuments",
        api.listDocuments,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.documentIdentifiers().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ssm.model.DocumentIdentifier.wrap(item))
        .provideEnvironment(r)
    def listDocumentsPaginated(
        request: zio.aws.ssm.model.ListDocumentsRequest
    ): IO[AwsError, zio.aws.ssm.model.ListDocumentsResponse.ReadOnly] =
      asyncRequestResponse[ListDocumentsRequest, ListDocumentsResponse](
        "listDocuments",
        api.listDocuments
      )(request.buildAwsValue())
        .map(zio.aws.ssm.model.ListDocumentsResponse.wrap)
        .provideEnvironment(r)
    def getPatchBaseline(
        request: zio.aws.ssm.model.GetPatchBaselineRequest
    ): IO[AwsError, zio.aws.ssm.model.GetPatchBaselineResponse.ReadOnly] =
      asyncRequestResponse[GetPatchBaselineRequest, GetPatchBaselineResponse](
        "getPatchBaseline",
        api.getPatchBaseline
      )(request.buildAwsValue())
        .map(zio.aws.ssm.model.GetPatchBaselineResponse.wrap)
        .provideEnvironment(r)
    def updateMaintenanceWindowTarget(
        request: zio.aws.ssm.model.UpdateMaintenanceWindowTargetRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.UpdateMaintenanceWindowTargetResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateMaintenanceWindowTargetRequest,
      UpdateMaintenanceWindowTargetResponse
    ]("updateMaintenanceWindowTarget", api.updateMaintenanceWindowTarget)(
      request.buildAwsValue()
    ).map(zio.aws.ssm.model.UpdateMaintenanceWindowTargetResponse.wrap)
      .provideEnvironment(r)
    def startAutomationExecution(
        request: zio.aws.ssm.model.StartAutomationExecutionRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.StartAutomationExecutionResponse.ReadOnly
    ] = asyncRequestResponse[
      StartAutomationExecutionRequest,
      StartAutomationExecutionResponse
    ]("startAutomationExecution", api.startAutomationExecution)(
      request.buildAwsValue()
    ).map(zio.aws.ssm.model.StartAutomationExecutionResponse.wrap)
      .provideEnvironment(r)
    def sendCommand(
        request: zio.aws.ssm.model.SendCommandRequest
    ): IO[AwsError, zio.aws.ssm.model.SendCommandResponse.ReadOnly] =
      asyncRequestResponse[SendCommandRequest, SendCommandResponse](
        "sendCommand",
        api.sendCommand
      )(request.buildAwsValue())
        .map(zio.aws.ssm.model.SendCommandResponse.wrap)
        .provideEnvironment(r)
    def getInventory(request: zio.aws.ssm.model.GetInventoryRequest): ZStream[
      Any,
      AwsError,
      zio.aws.ssm.model.InventoryResultEntity.ReadOnly
    ] = asyncSimplePaginatedRequest[
      GetInventoryRequest,
      GetInventoryResponse,
      InventoryResultEntity
    ](
      "getInventory",
      api.getInventory,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.entities().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ssm.model.InventoryResultEntity.wrap(item))
      .provideEnvironment(r)
    def getInventoryPaginated(
        request: zio.aws.ssm.model.GetInventoryRequest
    ): IO[AwsError, zio.aws.ssm.model.GetInventoryResponse.ReadOnly] =
      asyncRequestResponse[GetInventoryRequest, GetInventoryResponse](
        "getInventory",
        api.getInventory
      )(request.buildAwsValue())
        .map(zio.aws.ssm.model.GetInventoryResponse.wrap)
        .provideEnvironment(r)
    def updateServiceSetting(
        request: zio.aws.ssm.model.UpdateServiceSettingRequest
    ): IO[AwsError, zio.aws.ssm.model.UpdateServiceSettingResponse.ReadOnly] =
      asyncRequestResponse[
        UpdateServiceSettingRequest,
        UpdateServiceSettingResponse
      ]("updateServiceSetting", api.updateServiceSetting)(
        request.buildAwsValue()
      ).map(zio.aws.ssm.model.UpdateServiceSettingResponse.wrap)
        .provideEnvironment(r)
    def getConnectionStatus(
        request: zio.aws.ssm.model.GetConnectionStatusRequest
    ): IO[AwsError, zio.aws.ssm.model.GetConnectionStatusResponse.ReadOnly] =
      asyncRequestResponse[
        GetConnectionStatusRequest,
        GetConnectionStatusResponse
      ]("getConnectionStatus", api.getConnectionStatus)(request.buildAwsValue())
        .map(zio.aws.ssm.model.GetConnectionStatusResponse.wrap)
        .provideEnvironment(r)
    def describeAutomationExecutions(
        request: zio.aws.ssm.model.DescribeAutomationExecutionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ssm.model.AutomationExecutionMetadata.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeAutomationExecutionsRequest,
      DescribeAutomationExecutionsResponse,
      AutomationExecutionMetadata
    ](
      "describeAutomationExecutions",
      api.describeAutomationExecutions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.automationExecutionMetadataList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ssm.model.AutomationExecutionMetadata.wrap(item))
      .provideEnvironment(r)
    def describeAutomationExecutionsPaginated(
        request: zio.aws.ssm.model.DescribeAutomationExecutionsRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      DescribeAutomationExecutionsRequest,
      DescribeAutomationExecutionsResponse
    ]("describeAutomationExecutions", api.describeAutomationExecutions)(
      request.buildAwsValue()
    ).map(zio.aws.ssm.model.DescribeAutomationExecutionsResponse.wrap)
      .provideEnvironment(r)
    def resumeSession(
        request: zio.aws.ssm.model.ResumeSessionRequest
    ): IO[AwsError, zio.aws.ssm.model.ResumeSessionResponse.ReadOnly] =
      asyncRequestResponse[ResumeSessionRequest, ResumeSessionResponse](
        "resumeSession",
        api.resumeSession
      )(request.buildAwsValue())
        .map(zio.aws.ssm.model.ResumeSessionResponse.wrap)
        .provideEnvironment(r)
    def listResourceComplianceSummaries(
        request: zio.aws.ssm.model.ListResourceComplianceSummariesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ssm.model.ResourceComplianceSummaryItem.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListResourceComplianceSummariesRequest,
      ListResourceComplianceSummariesResponse,
      ResourceComplianceSummaryItem
    ](
      "listResourceComplianceSummaries",
      api.listResourceComplianceSummaries,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.resourceComplianceSummaryItems().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ssm.model.ResourceComplianceSummaryItem.wrap(item))
      .provideEnvironment(r)
    def listResourceComplianceSummariesPaginated(
        request: zio.aws.ssm.model.ListResourceComplianceSummariesRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.ListResourceComplianceSummariesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListResourceComplianceSummariesRequest,
      ListResourceComplianceSummariesResponse
    ]("listResourceComplianceSummaries", api.listResourceComplianceSummaries)(
      request.buildAwsValue()
    ).map(zio.aws.ssm.model.ListResourceComplianceSummariesResponse.wrap)
      .provideEnvironment(r)
    def createPatchBaseline(
        request: zio.aws.ssm.model.CreatePatchBaselineRequest
    ): IO[AwsError, zio.aws.ssm.model.CreatePatchBaselineResponse.ReadOnly] =
      asyncRequestResponse[
        CreatePatchBaselineRequest,
        CreatePatchBaselineResponse
      ]("createPatchBaseline", api.createPatchBaseline)(request.buildAwsValue())
        .map(zio.aws.ssm.model.CreatePatchBaselineResponse.wrap)
        .provideEnvironment(r)
    def getOpsItem(
        request: zio.aws.ssm.model.GetOpsItemRequest
    ): IO[AwsError, zio.aws.ssm.model.GetOpsItemResponse.ReadOnly] =
      asyncRequestResponse[GetOpsItemRequest, GetOpsItemResponse](
        "getOpsItem",
        api.getOpsItem
      )(request.buildAwsValue())
        .map(zio.aws.ssm.model.GetOpsItemResponse.wrap)
        .provideEnvironment(r)
    def getPatchBaselineForPatchGroup(
        request: zio.aws.ssm.model.GetPatchBaselineForPatchGroupRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.GetPatchBaselineForPatchGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      GetPatchBaselineForPatchGroupRequest,
      GetPatchBaselineForPatchGroupResponse
    ]("getPatchBaselineForPatchGroup", api.getPatchBaselineForPatchGroup)(
      request.buildAwsValue()
    ).map(zio.aws.ssm.model.GetPatchBaselineForPatchGroupResponse.wrap)
      .provideEnvironment(r)
    def createAssociation(
        request: zio.aws.ssm.model.CreateAssociationRequest
    ): IO[AwsError, zio.aws.ssm.model.CreateAssociationResponse.ReadOnly] =
      asyncRequestResponse[CreateAssociationRequest, CreateAssociationResponse](
        "createAssociation",
        api.createAssociation
      )(request.buildAwsValue())
        .map(zio.aws.ssm.model.CreateAssociationResponse.wrap)
        .provideEnvironment(r)
    def listAssociations(
        request: zio.aws.ssm.model.ListAssociationsRequest
    ): ZStream[Any, AwsError, zio.aws.ssm.model.Association.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListAssociationsRequest,
        ListAssociationsResponse,
        Association
      ](
        "listAssociations",
        api.listAssociations,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.associations().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ssm.model.Association.wrap(item))
        .provideEnvironment(r)
    def listAssociationsPaginated(
        request: zio.aws.ssm.model.ListAssociationsRequest
    ): IO[AwsError, zio.aws.ssm.model.ListAssociationsResponse.ReadOnly] =
      asyncRequestResponse[ListAssociationsRequest, ListAssociationsResponse](
        "listAssociations",
        api.listAssociations
      )(request.buildAwsValue())
        .map(zio.aws.ssm.model.ListAssociationsResponse.wrap)
        .provideEnvironment(r)
    def updateDocument(
        request: zio.aws.ssm.model.UpdateDocumentRequest
    ): IO[AwsError, zio.aws.ssm.model.UpdateDocumentResponse.ReadOnly] =
      asyncRequestResponse[UpdateDocumentRequest, UpdateDocumentResponse](
        "updateDocument",
        api.updateDocument
      )(request.buildAwsValue())
        .map(zio.aws.ssm.model.UpdateDocumentResponse.wrap)
        .provideEnvironment(r)
    def putInventory(
        request: zio.aws.ssm.model.PutInventoryRequest
    ): IO[AwsError, zio.aws.ssm.model.PutInventoryResponse.ReadOnly] =
      asyncRequestResponse[PutInventoryRequest, PutInventoryResponse](
        "putInventory",
        api.putInventory
      )(request.buildAwsValue())
        .map(zio.aws.ssm.model.PutInventoryResponse.wrap)
        .provideEnvironment(r)
    def updateMaintenanceWindow(
        request: zio.aws.ssm.model.UpdateMaintenanceWindowRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.UpdateMaintenanceWindowResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateMaintenanceWindowRequest,
      UpdateMaintenanceWindowResponse
    ]("updateMaintenanceWindow", api.updateMaintenanceWindow)(
      request.buildAwsValue()
    ).map(zio.aws.ssm.model.UpdateMaintenanceWindowResponse.wrap)
      .provideEnvironment(r)
    def updateDocumentDefaultVersion(
        request: zio.aws.ssm.model.UpdateDocumentDefaultVersionRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.UpdateDocumentDefaultVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateDocumentDefaultVersionRequest,
      UpdateDocumentDefaultVersionResponse
    ]("updateDocumentDefaultVersion", api.updateDocumentDefaultVersion)(
      request.buildAwsValue()
    ).map(zio.aws.ssm.model.UpdateDocumentDefaultVersionResponse.wrap)
      .provideEnvironment(r)
    def getMaintenanceWindowTask(
        request: zio.aws.ssm.model.GetMaintenanceWindowTaskRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.GetMaintenanceWindowTaskResponse.ReadOnly
    ] = asyncRequestResponse[
      GetMaintenanceWindowTaskRequest,
      GetMaintenanceWindowTaskResponse
    ]("getMaintenanceWindowTask", api.getMaintenanceWindowTask)(
      request.buildAwsValue()
    ).map(zio.aws.ssm.model.GetMaintenanceWindowTaskResponse.wrap)
      .provideEnvironment(r)
    def describeAssociationExecutionTargets(
        request: zio.aws.ssm.model.DescribeAssociationExecutionTargetsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ssm.model.AssociationExecutionTarget.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeAssociationExecutionTargetsRequest,
      DescribeAssociationExecutionTargetsResponse,
      AssociationExecutionTarget
    ](
      "describeAssociationExecutionTargets",
      api.describeAssociationExecutionTargets,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.associationExecutionTargets().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ssm.model.AssociationExecutionTarget.wrap(item))
      .provideEnvironment(r)
    def describeAssociationExecutionTargetsPaginated(
        request: zio.aws.ssm.model.DescribeAssociationExecutionTargetsRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.DescribeAssociationExecutionTargetsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeAssociationExecutionTargetsRequest,
      DescribeAssociationExecutionTargetsResponse
    ](
      "describeAssociationExecutionTargets",
      api.describeAssociationExecutionTargets
    )(request.buildAwsValue())
      .map(zio.aws.ssm.model.DescribeAssociationExecutionTargetsResponse.wrap)
      .provideEnvironment(r)
    def createOpsItem(
        request: zio.aws.ssm.model.CreateOpsItemRequest
    ): IO[AwsError, zio.aws.ssm.model.CreateOpsItemResponse.ReadOnly] =
      asyncRequestResponse[CreateOpsItemRequest, CreateOpsItemResponse](
        "createOpsItem",
        api.createOpsItem
      )(request.buildAwsValue())
        .map(zio.aws.ssm.model.CreateOpsItemResponse.wrap)
        .provideEnvironment(r)
    def listCommands(
        request: zio.aws.ssm.model.ListCommandsRequest
    ): ZStream[Any, AwsError, zio.aws.ssm.model.Command.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListCommandsRequest,
        ListCommandsResponse,
        Command
      ](
        "listCommands",
        api.listCommands,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.commands().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ssm.model.Command.wrap(item))
        .provideEnvironment(r)
    def listCommandsPaginated(
        request: zio.aws.ssm.model.ListCommandsRequest
    ): IO[AwsError, zio.aws.ssm.model.ListCommandsResponse.ReadOnly] =
      asyncRequestResponse[ListCommandsRequest, ListCommandsResponse](
        "listCommands",
        api.listCommands
      )(request.buildAwsValue())
        .map(zio.aws.ssm.model.ListCommandsResponse.wrap)
        .provideEnvironment(r)
    def getAutomationExecution(
        request: zio.aws.ssm.model.GetAutomationExecutionRequest
    ): IO[AwsError, zio.aws.ssm.model.GetAutomationExecutionResponse.ReadOnly] =
      asyncRequestResponse[
        GetAutomationExecutionRequest,
        GetAutomationExecutionResponse
      ]("getAutomationExecution", api.getAutomationExecution)(
        request.buildAwsValue()
      ).map(zio.aws.ssm.model.GetAutomationExecutionResponse.wrap)
        .provideEnvironment(r)
    def describeMaintenanceWindowExecutionTasks(
        request: zio.aws.ssm.model.DescribeMaintenanceWindowExecutionTasksRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ssm.model.MaintenanceWindowExecutionTaskIdentity.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeMaintenanceWindowExecutionTasksRequest,
      DescribeMaintenanceWindowExecutionTasksResponse,
      MaintenanceWindowExecutionTaskIdentity
    ](
      "describeMaintenanceWindowExecutionTasks",
      api.describeMaintenanceWindowExecutionTasks,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.windowExecutionTaskIdentities().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.ssm.model.MaintenanceWindowExecutionTaskIdentity.wrap(item)
      )
      .provideEnvironment(r)
    def describeMaintenanceWindowExecutionTasksPaginated(
        request: zio.aws.ssm.model.DescribeMaintenanceWindowExecutionTasksRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.DescribeMaintenanceWindowExecutionTasksResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeMaintenanceWindowExecutionTasksRequest,
      DescribeMaintenanceWindowExecutionTasksResponse
    ](
      "describeMaintenanceWindowExecutionTasks",
      api.describeMaintenanceWindowExecutionTasks
    )(request.buildAwsValue())
      .map(
        zio.aws.ssm.model.DescribeMaintenanceWindowExecutionTasksResponse.wrap
      )
      .provideEnvironment(r)
    def listDocumentVersions(
        request: zio.aws.ssm.model.ListDocumentVersionsRequest
    ): ZStream[Any, AwsError, zio.aws.ssm.model.DocumentVersionInfo.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListDocumentVersionsRequest,
        ListDocumentVersionsResponse,
        DocumentVersionInfo
      ](
        "listDocumentVersions",
        api.listDocumentVersions,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.documentVersions().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ssm.model.DocumentVersionInfo.wrap(item))
        .provideEnvironment(r)
    def listDocumentVersionsPaginated(
        request: zio.aws.ssm.model.ListDocumentVersionsRequest
    ): IO[AwsError, zio.aws.ssm.model.ListDocumentVersionsResponse.ReadOnly] =
      asyncRequestResponse[
        ListDocumentVersionsRequest,
        ListDocumentVersionsResponse
      ]("listDocumentVersions", api.listDocumentVersions)(
        request.buildAwsValue()
      ).map(zio.aws.ssm.model.ListDocumentVersionsResponse.wrap)
        .provideEnvironment(r)
    def getOpsSummary(
        request: zio.aws.ssm.model.GetOpsSummaryRequest
    ): ZStream[Any, AwsError, zio.aws.ssm.model.OpsEntity.ReadOnly] =
      asyncSimplePaginatedRequest[
        GetOpsSummaryRequest,
        GetOpsSummaryResponse,
        OpsEntity
      ](
        "getOpsSummary",
        api.getOpsSummary,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.entities().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ssm.model.OpsEntity.wrap(item))
        .provideEnvironment(r)
    def getOpsSummaryPaginated(
        request: zio.aws.ssm.model.GetOpsSummaryRequest
    ): IO[AwsError, zio.aws.ssm.model.GetOpsSummaryResponse.ReadOnly] =
      asyncRequestResponse[GetOpsSummaryRequest, GetOpsSummaryResponse](
        "getOpsSummary",
        api.getOpsSummary
      )(request.buildAwsValue())
        .map(zio.aws.ssm.model.GetOpsSummaryResponse.wrap)
        .provideEnvironment(r)
    def describeDocument(
        request: zio.aws.ssm.model.DescribeDocumentRequest
    ): IO[AwsError, zio.aws.ssm.model.DescribeDocumentResponse.ReadOnly] =
      asyncRequestResponse[DescribeDocumentRequest, DescribeDocumentResponse](
        "describeDocument",
        api.describeDocument
      )(request.buildAwsValue())
        .map(zio.aws.ssm.model.DescribeDocumentResponse.wrap)
        .provideEnvironment(r)
    def describePatchGroups(
        request: zio.aws.ssm.model.DescribePatchGroupsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ssm.model.PatchGroupPatchBaselineMapping.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribePatchGroupsRequest,
      DescribePatchGroupsResponse,
      PatchGroupPatchBaselineMapping
    ](
      "describePatchGroups",
      api.describePatchGroups,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.mappings().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ssm.model.PatchGroupPatchBaselineMapping.wrap(item))
      .provideEnvironment(r)
    def describePatchGroupsPaginated(
        request: zio.aws.ssm.model.DescribePatchGroupsRequest
    ): IO[AwsError, zio.aws.ssm.model.DescribePatchGroupsResponse.ReadOnly] =
      asyncRequestResponse[
        DescribePatchGroupsRequest,
        DescribePatchGroupsResponse
      ]("describePatchGroups", api.describePatchGroups)(request.buildAwsValue())
        .map(zio.aws.ssm.model.DescribePatchGroupsResponse.wrap)
        .provideEnvironment(r)
    def startAssociationsOnce(
        request: zio.aws.ssm.model.StartAssociationsOnceRequest
    ): IO[AwsError, zio.aws.ssm.model.StartAssociationsOnceResponse.ReadOnly] =
      asyncRequestResponse[
        StartAssociationsOnceRequest,
        StartAssociationsOnceResponse
      ]("startAssociationsOnce", api.startAssociationsOnce)(
        request.buildAwsValue()
      ).map(zio.aws.ssm.model.StartAssociationsOnceResponse.wrap)
        .provideEnvironment(r)
    def describeMaintenanceWindowTargets(
        request: zio.aws.ssm.model.DescribeMaintenanceWindowTargetsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ssm.model.MaintenanceWindowTarget.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeMaintenanceWindowTargetsRequest,
      DescribeMaintenanceWindowTargetsResponse,
      MaintenanceWindowTarget
    ](
      "describeMaintenanceWindowTargets",
      api.describeMaintenanceWindowTargets,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.targets().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ssm.model.MaintenanceWindowTarget.wrap(item))
      .provideEnvironment(r)
    def describeMaintenanceWindowTargetsPaginated(
        request: zio.aws.ssm.model.DescribeMaintenanceWindowTargetsRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.DescribeMaintenanceWindowTargetsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeMaintenanceWindowTargetsRequest,
      DescribeMaintenanceWindowTargetsResponse
    ]("describeMaintenanceWindowTargets", api.describeMaintenanceWindowTargets)(
      request.buildAwsValue()
    ).map(zio.aws.ssm.model.DescribeMaintenanceWindowTargetsResponse.wrap)
      .provideEnvironment(r)
    def updateManagedInstanceRole(
        request: zio.aws.ssm.model.UpdateManagedInstanceRoleRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.UpdateManagedInstanceRoleResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateManagedInstanceRoleRequest,
      UpdateManagedInstanceRoleResponse
    ]("updateManagedInstanceRole", api.updateManagedInstanceRole)(
      request.buildAwsValue()
    ).map(zio.aws.ssm.model.UpdateManagedInstanceRoleResponse.wrap)
      .provideEnvironment(r)
    def describeInstanceInformation(
        request: zio.aws.ssm.model.DescribeInstanceInformationRequest
    ): ZStream[Any, AwsError, zio.aws.ssm.model.InstanceInformation.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeInstanceInformationRequest,
        DescribeInstanceInformationResponse,
        InstanceInformation
      ](
        "describeInstanceInformation",
        api.describeInstanceInformation,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.instanceInformationList().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ssm.model.InstanceInformation.wrap(item))
        .provideEnvironment(r)
    def describeInstanceInformationPaginated(
        request: zio.aws.ssm.model.DescribeInstanceInformationRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.DescribeInstanceInformationResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeInstanceInformationRequest,
      DescribeInstanceInformationResponse
    ]("describeInstanceInformation", api.describeInstanceInformation)(
      request.buildAwsValue()
    ).map(zio.aws.ssm.model.DescribeInstanceInformationResponse.wrap)
      .provideEnvironment(r)
    def updateMaintenanceWindowTask(
        request: zio.aws.ssm.model.UpdateMaintenanceWindowTaskRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.UpdateMaintenanceWindowTaskResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateMaintenanceWindowTaskRequest,
      UpdateMaintenanceWindowTaskResponse
    ]("updateMaintenanceWindowTask", api.updateMaintenanceWindowTask)(
      request.buildAwsValue()
    ).map(zio.aws.ssm.model.UpdateMaintenanceWindowTaskResponse.wrap)
      .provideEnvironment(r)
    def describeMaintenanceWindows(
        request: zio.aws.ssm.model.DescribeMaintenanceWindowsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ssm.model.MaintenanceWindowIdentity.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeMaintenanceWindowsRequest,
      DescribeMaintenanceWindowsResponse,
      MaintenanceWindowIdentity
    ](
      "describeMaintenanceWindows",
      api.describeMaintenanceWindows,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.windowIdentities().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ssm.model.MaintenanceWindowIdentity.wrap(item))
      .provideEnvironment(r)
    def describeMaintenanceWindowsPaginated(
        request: zio.aws.ssm.model.DescribeMaintenanceWindowsRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.DescribeMaintenanceWindowsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeMaintenanceWindowsRequest,
      DescribeMaintenanceWindowsResponse
    ]("describeMaintenanceWindows", api.describeMaintenanceWindows)(
      request.buildAwsValue()
    ).map(zio.aws.ssm.model.DescribeMaintenanceWindowsResponse.wrap)
      .provideEnvironment(r)
    def getServiceSetting(
        request: zio.aws.ssm.model.GetServiceSettingRequest
    ): IO[AwsError, zio.aws.ssm.model.GetServiceSettingResponse.ReadOnly] =
      asyncRequestResponse[GetServiceSettingRequest, GetServiceSettingResponse](
        "getServiceSetting",
        api.getServiceSetting
      )(request.buildAwsValue())
        .map(zio.aws.ssm.model.GetServiceSettingResponse.wrap)
        .provideEnvironment(r)
    def registerDefaultPatchBaseline(
        request: zio.aws.ssm.model.RegisterDefaultPatchBaselineRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.RegisterDefaultPatchBaselineResponse.ReadOnly
    ] = asyncRequestResponse[
      RegisterDefaultPatchBaselineRequest,
      RegisterDefaultPatchBaselineResponse
    ]("registerDefaultPatchBaseline", api.registerDefaultPatchBaseline)(
      request.buildAwsValue()
    ).map(zio.aws.ssm.model.RegisterDefaultPatchBaselineResponse.wrap)
      .provideEnvironment(r)
    def listDocumentMetadataHistory(
        request: zio.aws.ssm.model.ListDocumentMetadataHistoryRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.ListDocumentMetadataHistoryResponse.ReadOnly
    ] = asyncRequestResponse[
      ListDocumentMetadataHistoryRequest,
      ListDocumentMetadataHistoryResponse
    ]("listDocumentMetadataHistory", api.listDocumentMetadataHistory)(
      request.buildAwsValue()
    ).map(zio.aws.ssm.model.ListDocumentMetadataHistoryResponse.wrap)
      .provideEnvironment(r)
    def getParametersByPath(
        request: zio.aws.ssm.model.GetParametersByPathRequest
    ): ZStream[Any, AwsError, zio.aws.ssm.model.Parameter.ReadOnly] =
      asyncSimplePaginatedRequest[
        GetParametersByPathRequest,
        GetParametersByPathResponse,
        Parameter
      ](
        "getParametersByPath",
        api.getParametersByPath,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.parameters().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ssm.model.Parameter.wrap(item))
        .provideEnvironment(r)
    def getParametersByPathPaginated(
        request: zio.aws.ssm.model.GetParametersByPathRequest
    ): IO[AwsError, zio.aws.ssm.model.GetParametersByPathResponse.ReadOnly] =
      asyncRequestResponse[
        GetParametersByPathRequest,
        GetParametersByPathResponse
      ]("getParametersByPath", api.getParametersByPath)(request.buildAwsValue())
        .map(zio.aws.ssm.model.GetParametersByPathResponse.wrap)
        .provideEnvironment(r)
    def cancelMaintenanceWindowExecution(
        request: zio.aws.ssm.model.CancelMaintenanceWindowExecutionRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.CancelMaintenanceWindowExecutionResponse.ReadOnly
    ] = asyncRequestResponse[
      CancelMaintenanceWindowExecutionRequest,
      CancelMaintenanceWindowExecutionResponse
    ]("cancelMaintenanceWindowExecution", api.cancelMaintenanceWindowExecution)(
      request.buildAwsValue()
    ).map(zio.aws.ssm.model.CancelMaintenanceWindowExecutionResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.ssm.model.ListTagsForResourceRequest
    ): IO[AwsError, zio.aws.ssm.model.ListTagsForResourceResponse.ReadOnly] =
      asyncRequestResponse[
        ListTagsForResourceRequest,
        ListTagsForResourceResponse
      ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
        .map(zio.aws.ssm.model.ListTagsForResourceResponse.wrap)
        .provideEnvironment(r)
    def describeMaintenanceWindowExecutionTaskInvocations(
        request: zio.aws.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ssm.model.MaintenanceWindowExecutionTaskInvocationIdentity.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeMaintenanceWindowExecutionTaskInvocationsRequest,
      DescribeMaintenanceWindowExecutionTaskInvocationsResponse,
      MaintenanceWindowExecutionTaskInvocationIdentity
    ](
      "describeMaintenanceWindowExecutionTaskInvocations",
      api.describeMaintenanceWindowExecutionTaskInvocations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r =>
        zio.Chunk.fromIterable(
          r.windowExecutionTaskInvocationIdentities().asScala
        )
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.ssm.model.MaintenanceWindowExecutionTaskInvocationIdentity
          .wrap(item)
      )
      .provideEnvironment(r)
    def describeMaintenanceWindowExecutionTaskInvocationsPaginated(
        request: zio.aws.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeMaintenanceWindowExecutionTaskInvocationsRequest,
      DescribeMaintenanceWindowExecutionTaskInvocationsResponse
    ](
      "describeMaintenanceWindowExecutionTaskInvocations",
      api.describeMaintenanceWindowExecutionTaskInvocations
    )(request.buildAwsValue())
      .map(
        zio.aws.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsResponse.wrap
      )
      .provideEnvironment(r)
    def updateAssociation(
        request: zio.aws.ssm.model.UpdateAssociationRequest
    ): IO[AwsError, zio.aws.ssm.model.UpdateAssociationResponse.ReadOnly] =
      asyncRequestResponse[UpdateAssociationRequest, UpdateAssociationResponse](
        "updateAssociation",
        api.updateAssociation
      )(request.buildAwsValue())
        .map(zio.aws.ssm.model.UpdateAssociationResponse.wrap)
        .provideEnvironment(r)
    def startSession(
        request: zio.aws.ssm.model.StartSessionRequest
    ): IO[AwsError, zio.aws.ssm.model.StartSessionResponse.ReadOnly] =
      asyncRequestResponse[StartSessionRequest, StartSessionResponse](
        "startSession",
        api.startSession
      )(request.buildAwsValue())
        .map(zio.aws.ssm.model.StartSessionResponse.wrap)
        .provideEnvironment(r)
    def associateOpsItemRelatedItem(
        request: zio.aws.ssm.model.AssociateOpsItemRelatedItemRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.AssociateOpsItemRelatedItemResponse.ReadOnly
    ] = asyncRequestResponse[
      AssociateOpsItemRelatedItemRequest,
      AssociateOpsItemRelatedItemResponse
    ]("associateOpsItemRelatedItem", api.associateOpsItemRelatedItem)(
      request.buildAwsValue()
    ).map(zio.aws.ssm.model.AssociateOpsItemRelatedItemResponse.wrap)
      .provideEnvironment(r)
    def disassociateOpsItemRelatedItem(
        request: zio.aws.ssm.model.DisassociateOpsItemRelatedItemRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.DisassociateOpsItemRelatedItemResponse.ReadOnly
    ] = asyncRequestResponse[
      DisassociateOpsItemRelatedItemRequest,
      DisassociateOpsItemRelatedItemResponse
    ]("disassociateOpsItemRelatedItem", api.disassociateOpsItemRelatedItem)(
      request.buildAwsValue()
    ).map(zio.aws.ssm.model.DisassociateOpsItemRelatedItemResponse.wrap)
      .provideEnvironment(r)
    def describeOpsItems(
        request: zio.aws.ssm.model.DescribeOpsItemsRequest
    ): ZStream[Any, AwsError, zio.aws.ssm.model.OpsItemSummary.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeOpsItemsRequest,
        DescribeOpsItemsResponse,
        OpsItemSummary
      ](
        "describeOpsItems",
        api.describeOpsItems,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.opsItemSummaries().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ssm.model.OpsItemSummary.wrap(item))
        .provideEnvironment(r)
    def describeOpsItemsPaginated(
        request: zio.aws.ssm.model.DescribeOpsItemsRequest
    ): IO[AwsError, zio.aws.ssm.model.DescribeOpsItemsResponse.ReadOnly] =
      asyncRequestResponse[DescribeOpsItemsRequest, DescribeOpsItemsResponse](
        "describeOpsItems",
        api.describeOpsItems
      )(request.buildAwsValue())
        .map(zio.aws.ssm.model.DescribeOpsItemsResponse.wrap)
        .provideEnvironment(r)
    def describeEffectiveInstanceAssociations(
        request: zio.aws.ssm.model.DescribeEffectiveInstanceAssociationsRequest
    ): ZStream[Any, AwsError, zio.aws.ssm.model.InstanceAssociation.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeEffectiveInstanceAssociationsRequest,
        DescribeEffectiveInstanceAssociationsResponse,
        InstanceAssociation
      ](
        "describeEffectiveInstanceAssociations",
        api.describeEffectiveInstanceAssociations,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.associations().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ssm.model.InstanceAssociation.wrap(item))
        .provideEnvironment(r)
    def describeEffectiveInstanceAssociationsPaginated(
        request: zio.aws.ssm.model.DescribeEffectiveInstanceAssociationsRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.DescribeEffectiveInstanceAssociationsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeEffectiveInstanceAssociationsRequest,
      DescribeEffectiveInstanceAssociationsResponse
    ](
      "describeEffectiveInstanceAssociations",
      api.describeEffectiveInstanceAssociations
    )(request.buildAwsValue())
      .map(zio.aws.ssm.model.DescribeEffectiveInstanceAssociationsResponse.wrap)
      .provideEnvironment(r)
    def listAssociationVersions(
        request: zio.aws.ssm.model.ListAssociationVersionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ssm.model.AssociationVersionInfo.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListAssociationVersionsRequest,
      ListAssociationVersionsResponse,
      AssociationVersionInfo
    ](
      "listAssociationVersions",
      api.listAssociationVersions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.associationVersions().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ssm.model.AssociationVersionInfo.wrap(item))
      .provideEnvironment(r)
    def listAssociationVersionsPaginated(
        request: zio.aws.ssm.model.ListAssociationVersionsRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.ListAssociationVersionsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListAssociationVersionsRequest,
      ListAssociationVersionsResponse
    ]("listAssociationVersions", api.listAssociationVersions)(
      request.buildAwsValue()
    ).map(zio.aws.ssm.model.ListAssociationVersionsResponse.wrap)
      .provideEnvironment(r)
    def describeInstancePatches(
        request: zio.aws.ssm.model.DescribeInstancePatchesRequest
    ): ZStream[Any, AwsError, zio.aws.ssm.model.PatchComplianceData.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeInstancePatchesRequest,
        DescribeInstancePatchesResponse,
        PatchComplianceData
      ](
        "describeInstancePatches",
        api.describeInstancePatches,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.patches().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ssm.model.PatchComplianceData.wrap(item))
        .provideEnvironment(r)
    def describeInstancePatchesPaginated(
        request: zio.aws.ssm.model.DescribeInstancePatchesRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.DescribeInstancePatchesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeInstancePatchesRequest,
      DescribeInstancePatchesResponse
    ]("describeInstancePatches", api.describeInstancePatches)(
      request.buildAwsValue()
    ).map(zio.aws.ssm.model.DescribeInstancePatchesResponse.wrap)
      .provideEnvironment(r)
    def getDeployablePatchSnapshotForInstance(
        request: zio.aws.ssm.model.GetDeployablePatchSnapshotForInstanceRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.GetDeployablePatchSnapshotForInstanceResponse.ReadOnly
    ] = asyncRequestResponse[
      GetDeployablePatchSnapshotForInstanceRequest,
      GetDeployablePatchSnapshotForInstanceResponse
    ](
      "getDeployablePatchSnapshotForInstance",
      api.getDeployablePatchSnapshotForInstance
    )(request.buildAwsValue())
      .map(zio.aws.ssm.model.GetDeployablePatchSnapshotForInstanceResponse.wrap)
      .provideEnvironment(r)
    def putComplianceItems(
        request: zio.aws.ssm.model.PutComplianceItemsRequest
    ): IO[AwsError, zio.aws.ssm.model.PutComplianceItemsResponse.ReadOnly] =
      asyncRequestResponse[
        PutComplianceItemsRequest,
        PutComplianceItemsResponse
      ]("putComplianceItems", api.putComplianceItems)(request.buildAwsValue())
        .map(zio.aws.ssm.model.PutComplianceItemsResponse.wrap)
        .provideEnvironment(r)
    def deleteActivation(
        request: zio.aws.ssm.model.DeleteActivationRequest
    ): IO[AwsError, zio.aws.ssm.model.DeleteActivationResponse.ReadOnly] =
      asyncRequestResponse[DeleteActivationRequest, DeleteActivationResponse](
        "deleteActivation",
        api.deleteActivation
      )(request.buildAwsValue())
        .map(zio.aws.ssm.model.DeleteActivationResponse.wrap)
        .provideEnvironment(r)
    def listOpsItemRelatedItems(
        request: zio.aws.ssm.model.ListOpsItemRelatedItemsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ssm.model.OpsItemRelatedItemSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListOpsItemRelatedItemsRequest,
      ListOpsItemRelatedItemsResponse,
      OpsItemRelatedItemSummary
    ](
      "listOpsItemRelatedItems",
      api.listOpsItemRelatedItems,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.summaries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ssm.model.OpsItemRelatedItemSummary.wrap(item))
      .provideEnvironment(r)
    def listOpsItemRelatedItemsPaginated(
        request: zio.aws.ssm.model.ListOpsItemRelatedItemsRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.ListOpsItemRelatedItemsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListOpsItemRelatedItemsRequest,
      ListOpsItemRelatedItemsResponse
    ]("listOpsItemRelatedItems", api.listOpsItemRelatedItems)(
      request.buildAwsValue()
    ).map(zio.aws.ssm.model.ListOpsItemRelatedItemsResponse.wrap)
      .provideEnvironment(r)
    def deleteParameter(
        request: zio.aws.ssm.model.DeleteParameterRequest
    ): IO[AwsError, zio.aws.ssm.model.DeleteParameterResponse.ReadOnly] =
      asyncRequestResponse[DeleteParameterRequest, DeleteParameterResponse](
        "deleteParameter",
        api.deleteParameter
      )(request.buildAwsValue())
        .map(zio.aws.ssm.model.DeleteParameterResponse.wrap)
        .provideEnvironment(r)
    def describeInventoryDeletions(
        request: zio.aws.ssm.model.DescribeInventoryDeletionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ssm.model.InventoryDeletionStatusItem.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeInventoryDeletionsRequest,
      DescribeInventoryDeletionsResponse,
      InventoryDeletionStatusItem
    ](
      "describeInventoryDeletions",
      api.describeInventoryDeletions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.inventoryDeletions().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ssm.model.InventoryDeletionStatusItem.wrap(item))
      .provideEnvironment(r)
    def describeInventoryDeletionsPaginated(
        request: zio.aws.ssm.model.DescribeInventoryDeletionsRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.DescribeInventoryDeletionsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeInventoryDeletionsRequest,
      DescribeInventoryDeletionsResponse
    ]("describeInventoryDeletions", api.describeInventoryDeletions)(
      request.buildAwsValue()
    ).map(zio.aws.ssm.model.DescribeInventoryDeletionsResponse.wrap)
      .provideEnvironment(r)
    def getCommandInvocation(
        request: zio.aws.ssm.model.GetCommandInvocationRequest
    ): IO[AwsError, zio.aws.ssm.model.GetCommandInvocationResponse.ReadOnly] =
      asyncRequestResponse[
        GetCommandInvocationRequest,
        GetCommandInvocationResponse
      ]("getCommandInvocation", api.getCommandInvocation)(
        request.buildAwsValue()
      ).map(zio.aws.ssm.model.GetCommandInvocationResponse.wrap)
        .provideEnvironment(r)
    def updateAssociationStatus(
        request: zio.aws.ssm.model.UpdateAssociationStatusRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.UpdateAssociationStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateAssociationStatusRequest,
      UpdateAssociationStatusResponse
    ]("updateAssociationStatus", api.updateAssociationStatus)(
      request.buildAwsValue()
    ).map(zio.aws.ssm.model.UpdateAssociationStatusResponse.wrap)
      .provideEnvironment(r)
    def updateOpsMetadata(
        request: zio.aws.ssm.model.UpdateOpsMetadataRequest
    ): IO[AwsError, zio.aws.ssm.model.UpdateOpsMetadataResponse.ReadOnly] =
      asyncRequestResponse[UpdateOpsMetadataRequest, UpdateOpsMetadataResponse](
        "updateOpsMetadata",
        api.updateOpsMetadata
      )(request.buildAwsValue())
        .map(zio.aws.ssm.model.UpdateOpsMetadataResponse.wrap)
        .provideEnvironment(r)
    def describePatchBaselines(
        request: zio.aws.ssm.model.DescribePatchBaselinesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ssm.model.PatchBaselineIdentity.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribePatchBaselinesRequest,
      DescribePatchBaselinesResponse,
      PatchBaselineIdentity
    ](
      "describePatchBaselines",
      api.describePatchBaselines,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.baselineIdentities().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ssm.model.PatchBaselineIdentity.wrap(item))
      .provideEnvironment(r)
    def describePatchBaselinesPaginated(
        request: zio.aws.ssm.model.DescribePatchBaselinesRequest
    ): IO[AwsError, zio.aws.ssm.model.DescribePatchBaselinesResponse.ReadOnly] =
      asyncRequestResponse[
        DescribePatchBaselinesRequest,
        DescribePatchBaselinesResponse
      ]("describePatchBaselines", api.describePatchBaselines)(
        request.buildAwsValue()
      ).map(zio.aws.ssm.model.DescribePatchBaselinesResponse.wrap)
        .provideEnvironment(r)
    def describeEffectivePatchesForPatchBaseline(
        request: zio.aws.ssm.model.DescribeEffectivePatchesForPatchBaselineRequest
    ): ZStream[Any, AwsError, zio.aws.ssm.model.EffectivePatch.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeEffectivePatchesForPatchBaselineRequest,
        DescribeEffectivePatchesForPatchBaselineResponse,
        EffectivePatch
      ](
        "describeEffectivePatchesForPatchBaseline",
        api.describeEffectivePatchesForPatchBaseline,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.effectivePatches().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ssm.model.EffectivePatch.wrap(item))
        .provideEnvironment(r)
    def describeEffectivePatchesForPatchBaselinePaginated(
        request: zio.aws.ssm.model.DescribeEffectivePatchesForPatchBaselineRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.DescribeEffectivePatchesForPatchBaselineResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeEffectivePatchesForPatchBaselineRequest,
      DescribeEffectivePatchesForPatchBaselineResponse
    ](
      "describeEffectivePatchesForPatchBaseline",
      api.describeEffectivePatchesForPatchBaseline
    )(request.buildAwsValue())
      .map(
        zio.aws.ssm.model.DescribeEffectivePatchesForPatchBaselineResponse.wrap
      )
      .provideEnvironment(r)
    def createActivation(
        request: zio.aws.ssm.model.CreateActivationRequest
    ): IO[AwsError, zio.aws.ssm.model.CreateActivationResponse.ReadOnly] =
      asyncRequestResponse[CreateActivationRequest, CreateActivationResponse](
        "createActivation",
        api.createActivation
      )(request.buildAwsValue())
        .map(zio.aws.ssm.model.CreateActivationResponse.wrap)
        .provideEnvironment(r)
    def getMaintenanceWindowExecution(
        request: zio.aws.ssm.model.GetMaintenanceWindowExecutionRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.GetMaintenanceWindowExecutionResponse.ReadOnly
    ] = asyncRequestResponse[
      GetMaintenanceWindowExecutionRequest,
      GetMaintenanceWindowExecutionResponse
    ]("getMaintenanceWindowExecution", api.getMaintenanceWindowExecution)(
      request.buildAwsValue()
    ).map(zio.aws.ssm.model.GetMaintenanceWindowExecutionResponse.wrap)
      .provideEnvironment(r)
    def deregisterTaskFromMaintenanceWindow(
        request: zio.aws.ssm.model.DeregisterTaskFromMaintenanceWindowRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.DeregisterTaskFromMaintenanceWindowResponse.ReadOnly
    ] = asyncRequestResponse[
      DeregisterTaskFromMaintenanceWindowRequest,
      DeregisterTaskFromMaintenanceWindowResponse
    ](
      "deregisterTaskFromMaintenanceWindow",
      api.deregisterTaskFromMaintenanceWindow
    )(request.buildAwsValue())
      .map(zio.aws.ssm.model.DeregisterTaskFromMaintenanceWindowResponse.wrap)
      .provideEnvironment(r)
    def deleteDocument(
        request: zio.aws.ssm.model.DeleteDocumentRequest
    ): IO[AwsError, zio.aws.ssm.model.DeleteDocumentResponse.ReadOnly] =
      asyncRequestResponse[DeleteDocumentRequest, DeleteDocumentResponse](
        "deleteDocument",
        api.deleteDocument
      )(request.buildAwsValue())
        .map(zio.aws.ssm.model.DeleteDocumentResponse.wrap)
        .provideEnvironment(r)
    def createResourceDataSync(
        request: zio.aws.ssm.model.CreateResourceDataSyncRequest
    ): IO[AwsError, zio.aws.ssm.model.CreateResourceDataSyncResponse.ReadOnly] =
      asyncRequestResponse[
        CreateResourceDataSyncRequest,
        CreateResourceDataSyncResponse
      ]("createResourceDataSync", api.createResourceDataSync)(
        request.buildAwsValue()
      ).map(zio.aws.ssm.model.CreateResourceDataSyncResponse.wrap)
        .provideEnvironment(r)
    def getMaintenanceWindowExecutionTaskInvocation(
        request: zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskInvocationRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskInvocationResponse.ReadOnly
    ] = asyncRequestResponse[
      GetMaintenanceWindowExecutionTaskInvocationRequest,
      GetMaintenanceWindowExecutionTaskInvocationResponse
    ](
      "getMaintenanceWindowExecutionTaskInvocation",
      api.getMaintenanceWindowExecutionTaskInvocation
    )(request.buildAwsValue())
      .map(
        zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskInvocationResponse.wrap
      )
      .provideEnvironment(r)
    def deregisterManagedInstance(
        request: zio.aws.ssm.model.DeregisterManagedInstanceRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.DeregisterManagedInstanceResponse.ReadOnly
    ] = asyncRequestResponse[
      DeregisterManagedInstanceRequest,
      DeregisterManagedInstanceResponse
    ]("deregisterManagedInstance", api.deregisterManagedInstance)(
      request.buildAwsValue()
    ).map(zio.aws.ssm.model.DeregisterManagedInstanceResponse.wrap)
      .provideEnvironment(r)
    def updateOpsItem(
        request: zio.aws.ssm.model.UpdateOpsItemRequest
    ): IO[AwsError, zio.aws.ssm.model.UpdateOpsItemResponse.ReadOnly] =
      asyncRequestResponse[UpdateOpsItemRequest, UpdateOpsItemResponse](
        "updateOpsItem",
        api.updateOpsItem
      )(request.buildAwsValue())
        .map(zio.aws.ssm.model.UpdateOpsItemResponse.wrap)
        .provideEnvironment(r)
    def deleteOpsMetadata(
        request: zio.aws.ssm.model.DeleteOpsMetadataRequest
    ): IO[AwsError, zio.aws.ssm.model.DeleteOpsMetadataResponse.ReadOnly] =
      asyncRequestResponse[DeleteOpsMetadataRequest, DeleteOpsMetadataResponse](
        "deleteOpsMetadata",
        api.deleteOpsMetadata
      )(request.buildAwsValue())
        .map(zio.aws.ssm.model.DeleteOpsMetadataResponse.wrap)
        .provideEnvironment(r)
    def describeAvailablePatches(
        request: zio.aws.ssm.model.DescribeAvailablePatchesRequest
    ): ZStream[Any, AwsError, zio.aws.ssm.model.Patch.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeAvailablePatchesRequest,
        DescribeAvailablePatchesResponse,
        Patch
      ](
        "describeAvailablePatches",
        api.describeAvailablePatches,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.patches().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ssm.model.Patch.wrap(item))
        .provideEnvironment(r)
    def describeAvailablePatchesPaginated(
        request: zio.aws.ssm.model.DescribeAvailablePatchesRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.DescribeAvailablePatchesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeAvailablePatchesRequest,
      DescribeAvailablePatchesResponse
    ]("describeAvailablePatches", api.describeAvailablePatches)(
      request.buildAwsValue()
    ).map(zio.aws.ssm.model.DescribeAvailablePatchesResponse.wrap)
      .provideEnvironment(r)
    def listComplianceSummaries(
        request: zio.aws.ssm.model.ListComplianceSummariesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ssm.model.ComplianceSummaryItem.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListComplianceSummariesRequest,
      ListComplianceSummariesResponse,
      ComplianceSummaryItem
    ](
      "listComplianceSummaries",
      api.listComplianceSummaries,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.complianceSummaryItems().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ssm.model.ComplianceSummaryItem.wrap(item))
      .provideEnvironment(r)
    def listComplianceSummariesPaginated(
        request: zio.aws.ssm.model.ListComplianceSummariesRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.ListComplianceSummariesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListComplianceSummariesRequest,
      ListComplianceSummariesResponse
    ]("listComplianceSummaries", api.listComplianceSummaries)(
      request.buildAwsValue()
    ).map(zio.aws.ssm.model.ListComplianceSummariesResponse.wrap)
      .provideEnvironment(r)
    def deletePatchBaseline(
        request: zio.aws.ssm.model.DeletePatchBaselineRequest
    ): IO[AwsError, zio.aws.ssm.model.DeletePatchBaselineResponse.ReadOnly] =
      asyncRequestResponse[
        DeletePatchBaselineRequest,
        DeletePatchBaselineResponse
      ]("deletePatchBaseline", api.deletePatchBaseline)(request.buildAwsValue())
        .map(zio.aws.ssm.model.DeletePatchBaselineResponse.wrap)
        .provideEnvironment(r)
    def createOpsMetadata(
        request: zio.aws.ssm.model.CreateOpsMetadataRequest
    ): IO[AwsError, zio.aws.ssm.model.CreateOpsMetadataResponse.ReadOnly] =
      asyncRequestResponse[CreateOpsMetadataRequest, CreateOpsMetadataResponse](
        "createOpsMetadata",
        api.createOpsMetadata
      )(request.buildAwsValue())
        .map(zio.aws.ssm.model.CreateOpsMetadataResponse.wrap)
        .provideEnvironment(r)
    def deregisterTargetFromMaintenanceWindow(
        request: zio.aws.ssm.model.DeregisterTargetFromMaintenanceWindowRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.DeregisterTargetFromMaintenanceWindowResponse.ReadOnly
    ] = asyncRequestResponse[
      DeregisterTargetFromMaintenanceWindowRequest,
      DeregisterTargetFromMaintenanceWindowResponse
    ](
      "deregisterTargetFromMaintenanceWindow",
      api.deregisterTargetFromMaintenanceWindow
    )(request.buildAwsValue())
      .map(zio.aws.ssm.model.DeregisterTargetFromMaintenanceWindowResponse.wrap)
      .provideEnvironment(r)
    def putParameter(
        request: zio.aws.ssm.model.PutParameterRequest
    ): IO[AwsError, zio.aws.ssm.model.PutParameterResponse.ReadOnly] =
      asyncRequestResponse[PutParameterRequest, PutParameterResponse](
        "putParameter",
        api.putParameter
      )(request.buildAwsValue())
        .map(zio.aws.ssm.model.PutParameterResponse.wrap)
        .provideEnvironment(r)
    def describeDocumentPermission(
        request: zio.aws.ssm.model.DescribeDocumentPermissionRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.DescribeDocumentPermissionResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeDocumentPermissionRequest,
      DescribeDocumentPermissionResponse
    ]("describeDocumentPermission", api.describeDocumentPermission)(
      request.buildAwsValue()
    ).map(zio.aws.ssm.model.DescribeDocumentPermissionResponse.wrap)
      .provideEnvironment(r)
    def resetServiceSetting(
        request: zio.aws.ssm.model.ResetServiceSettingRequest
    ): IO[AwsError, zio.aws.ssm.model.ResetServiceSettingResponse.ReadOnly] =
      asyncRequestResponse[
        ResetServiceSettingRequest,
        ResetServiceSettingResponse
      ]("resetServiceSetting", api.resetServiceSetting)(request.buildAwsValue())
        .map(zio.aws.ssm.model.ResetServiceSettingResponse.wrap)
        .provideEnvironment(r)
    def updateResourceDataSync(
        request: zio.aws.ssm.model.UpdateResourceDataSyncRequest
    ): IO[AwsError, zio.aws.ssm.model.UpdateResourceDataSyncResponse.ReadOnly] =
      asyncRequestResponse[
        UpdateResourceDataSyncRequest,
        UpdateResourceDataSyncResponse
      ]("updateResourceDataSync", api.updateResourceDataSync)(
        request.buildAwsValue()
      ).map(zio.aws.ssm.model.UpdateResourceDataSyncResponse.wrap)
        .provideEnvironment(r)
    def unlabelParameterVersion(
        request: zio.aws.ssm.model.UnlabelParameterVersionRequest
    ): IO[
      AwsError,
      zio.aws.ssm.model.UnlabelParameterVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      UnlabelParameterVersionRequest,
      UnlabelParameterVersionResponse
    ]("unlabelParameterVersion", api.unlabelParameterVersion)(
      request.buildAwsValue()
    ).map(zio.aws.ssm.model.UnlabelParameterVersionResponse.wrap)
      .provideEnvironment(r)
    def getInventorySchema(
        request: zio.aws.ssm.model.GetInventorySchemaRequest
    ): ZStream[Any, AwsError, zio.aws.ssm.model.InventoryItemSchema.ReadOnly] =
      asyncSimplePaginatedRequest[
        GetInventorySchemaRequest,
        GetInventorySchemaResponse,
        InventoryItemSchema
      ](
        "getInventorySchema",
        api.getInventorySchema,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.schemas().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ssm.model.InventoryItemSchema.wrap(item))
        .provideEnvironment(r)
    def getInventorySchemaPaginated(
        request: zio.aws.ssm.model.GetInventorySchemaRequest
    ): IO[AwsError, zio.aws.ssm.model.GetInventorySchemaResponse.ReadOnly] =
      asyncRequestResponse[
        GetInventorySchemaRequest,
        GetInventorySchemaResponse
      ]("getInventorySchema", api.getInventorySchema)(request.buildAwsValue())
        .map(zio.aws.ssm.model.GetInventorySchemaResponse.wrap)
        .provideEnvironment(r)
    def getCalendarState(
        request: zio.aws.ssm.model.GetCalendarStateRequest
    ): IO[AwsError, zio.aws.ssm.model.GetCalendarStateResponse.ReadOnly] =
      asyncRequestResponse[GetCalendarStateRequest, GetCalendarStateResponse](
        "getCalendarState",
        api.getCalendarState
      )(request.buildAwsValue())
        .map(zio.aws.ssm.model.GetCalendarStateResponse.wrap)
        .provideEnvironment(r)
    def listCommandInvocations(
        request: zio.aws.ssm.model.ListCommandInvocationsRequest
    ): ZStream[Any, AwsError, zio.aws.ssm.model.CommandInvocation.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListCommandInvocationsRequest,
        ListCommandInvocationsResponse,
        CommandInvocation
      ](
        "listCommandInvocations",
        api.listCommandInvocations,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.commandInvocations().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ssm.model.CommandInvocation.wrap(item))
        .provideEnvironment(r)
    def listCommandInvocationsPaginated(
        request: zio.aws.ssm.model.ListCommandInvocationsRequest
    ): IO[AwsError, zio.aws.ssm.model.ListCommandInvocationsResponse.ReadOnly] =
      asyncRequestResponse[
        ListCommandInvocationsRequest,
        ListCommandInvocationsResponse
      ]("listCommandInvocations", api.listCommandInvocations)(
        request.buildAwsValue()
      ).map(zio.aws.ssm.model.ListCommandInvocationsResponse.wrap)
        .provideEnvironment(r)
    def deleteResourceDataSync(
        request: zio.aws.ssm.model.DeleteResourceDataSyncRequest
    ): IO[AwsError, zio.aws.ssm.model.DeleteResourceDataSyncResponse.ReadOnly] =
      asyncRequestResponse[
        DeleteResourceDataSyncRequest,
        DeleteResourceDataSyncResponse
      ]("deleteResourceDataSync", api.deleteResourceDataSync)(
        request.buildAwsValue()
      ).map(zio.aws.ssm.model.DeleteResourceDataSyncResponse.wrap)
        .provideEnvironment(r)
    def updatePatchBaseline(
        request: zio.aws.ssm.model.UpdatePatchBaselineRequest
    ): IO[AwsError, zio.aws.ssm.model.UpdatePatchBaselineResponse.ReadOnly] =
      asyncRequestResponse[
        UpdatePatchBaselineRequest,
        UpdatePatchBaselineResponse
      ]("updatePatchBaseline", api.updatePatchBaseline)(request.buildAwsValue())
        .map(zio.aws.ssm.model.UpdatePatchBaselineResponse.wrap)
        .provideEnvironment(r)
  }
  def deleteInventory(request: zio.aws.ssm.model.DeleteInventoryRequest): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.DeleteInventoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteInventory(request))
  def describeAutomationStepExecutions(
      request: zio.aws.ssm.model.DescribeAutomationStepExecutionsRequest
  ): ZStream[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.StepExecution.ReadOnly
  ] = ZStream.serviceWithStream(_.describeAutomationStepExecutions(request))
  def describeAutomationStepExecutionsPaginated(
      request: zio.aws.ssm.model.DescribeAutomationStepExecutionsRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.DescribeAutomationStepExecutionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAutomationStepExecutionsPaginated(request))
  def deleteParameters(request: zio.aws.ssm.model.DeleteParametersRequest): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.DeleteParametersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteParameters(request))
  def getParameterHistory(
      request: zio.aws.ssm.model.GetParameterHistoryRequest
  ): ZStream[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.ParameterHistory.ReadOnly
  ] = ZStream.serviceWithStream(_.getParameterHistory(request))
  def getParameterHistoryPaginated(
      request: zio.aws.ssm.model.GetParameterHistoryRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.GetParameterHistoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getParameterHistoryPaginated(request))
  def addTagsToResource(
      request: zio.aws.ssm.model.AddTagsToResourceRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.AddTagsToResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.addTagsToResource(request))
  def describeSessions(
      request: zio.aws.ssm.model.DescribeSessionsRequest
  ): ZStream[zio.aws.ssm.Ssm, AwsError, zio.aws.ssm.model.Session.ReadOnly] =
    ZStream.serviceWithStream(_.describeSessions(request))
  def describeSessionsPaginated(
      request: zio.aws.ssm.model.DescribeSessionsRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.DescribeSessionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSessionsPaginated(request))
  def listResourceDataSync(
      request: zio.aws.ssm.model.ListResourceDataSyncRequest
  ): ZStream[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.ResourceDataSyncItem.ReadOnly
  ] = ZStream.serviceWithStream(_.listResourceDataSync(request))
  def listResourceDataSyncPaginated(
      request: zio.aws.ssm.model.ListResourceDataSyncRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.ListResourceDataSyncResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listResourceDataSyncPaginated(request))
  def getOpsMetadata(
      request: zio.aws.ssm.model.GetOpsMetadataRequest
  ): ZIO[zio.aws.ssm.Ssm, AwsError, StreamingOutputResult[
    Any,
    zio.aws.ssm.model.GetOpsMetadataResponse.ReadOnly,
    Tuple2[MetadataKey, zio.aws.ssm.model.MetadataValue.ReadOnly]
  ]] = ZIO.serviceWithZIO(_.getOpsMetadata(request))
  def getOpsMetadataPaginated(
      request: zio.aws.ssm.model.GetOpsMetadataRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.GetOpsMetadataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getOpsMetadataPaginated(request))
  def deregisterPatchBaselineForPatchGroup(
      request: zio.aws.ssm.model.DeregisterPatchBaselineForPatchGroupRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.DeregisterPatchBaselineForPatchGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deregisterPatchBaselineForPatchGroup(request))
  def stopAutomationExecution(
      request: zio.aws.ssm.model.StopAutomationExecutionRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.StopAutomationExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopAutomationExecution(request))
  def describeInstanceAssociationsStatus(
      request: zio.aws.ssm.model.DescribeInstanceAssociationsStatusRequest
  ): ZStream[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.InstanceAssociationStatusInfo.ReadOnly
  ] = ZStream.serviceWithStream(_.describeInstanceAssociationsStatus(request))
  def describeInstanceAssociationsStatusPaginated(
      request: zio.aws.ssm.model.DescribeInstanceAssociationsStatusRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.DescribeInstanceAssociationsStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeInstanceAssociationsStatusPaginated(request))
  def describeMaintenanceWindowsForTarget(
      request: zio.aws.ssm.model.DescribeMaintenanceWindowsForTargetRequest
  ): ZStream[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.MaintenanceWindowIdentityForTarget.ReadOnly
  ] = ZStream.serviceWithStream(_.describeMaintenanceWindowsForTarget(request))
  def describeMaintenanceWindowsForTargetPaginated(
      request: zio.aws.ssm.model.DescribeMaintenanceWindowsForTargetRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.DescribeMaintenanceWindowsForTargetResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.describeMaintenanceWindowsForTargetPaginated(request))
  def getParameters(request: zio.aws.ssm.model.GetParametersRequest): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.GetParametersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getParameters(request))
  def describeInstancePatchStates(
      request: zio.aws.ssm.model.DescribeInstancePatchStatesRequest
  ): ZStream[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.InstancePatchState.ReadOnly
  ] = ZStream.serviceWithStream(_.describeInstancePatchStates(request))
  def describeInstancePatchStatesPaginated(
      request: zio.aws.ssm.model.DescribeInstancePatchStatesRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.DescribeInstancePatchStatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeInstancePatchStatesPaginated(request))
  def listInventoryEntries(
      request: zio.aws.ssm.model.ListInventoryEntriesRequest
  ): ZIO[zio.aws.ssm.Ssm, AwsError, StreamingOutputResult[
    Any,
    zio.aws.ssm.model.ListInventoryEntriesResponse.ReadOnly,
    Map[AttributeName, AttributeValue]
  ]] = ZIO.serviceWithZIO(_.listInventoryEntries(request))
  def listInventoryEntriesPaginated(
      request: zio.aws.ssm.model.ListInventoryEntriesRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.ListInventoryEntriesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listInventoryEntriesPaginated(request))
  def describeMaintenanceWindowExecutions(
      request: zio.aws.ssm.model.DescribeMaintenanceWindowExecutionsRequest
  ): ZStream[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.MaintenanceWindowExecution.ReadOnly
  ] = ZStream.serviceWithStream(_.describeMaintenanceWindowExecutions(request))
  def describeMaintenanceWindowExecutionsPaginated(
      request: zio.aws.ssm.model.DescribeMaintenanceWindowExecutionsRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.DescribeMaintenanceWindowExecutionsResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.describeMaintenanceWindowExecutionsPaginated(request))
  def describeAssociationExecutions(
      request: zio.aws.ssm.model.DescribeAssociationExecutionsRequest
  ): ZStream[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.AssociationExecution.ReadOnly
  ] = ZStream.serviceWithStream(_.describeAssociationExecutions(request))
  def describeAssociationExecutionsPaginated(
      request: zio.aws.ssm.model.DescribeAssociationExecutionsRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.DescribeAssociationExecutionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAssociationExecutionsPaginated(request))
  def listComplianceItems(
      request: zio.aws.ssm.model.ListComplianceItemsRequest
  ): ZStream[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.ComplianceItem.ReadOnly
  ] = ZStream.serviceWithStream(_.listComplianceItems(request))
  def listComplianceItemsPaginated(
      request: zio.aws.ssm.model.ListComplianceItemsRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.ListComplianceItemsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listComplianceItemsPaginated(request))
  def describeMaintenanceWindowTasks(
      request: zio.aws.ssm.model.DescribeMaintenanceWindowTasksRequest
  ): ZStream[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.MaintenanceWindowTask.ReadOnly
  ] = ZStream.serviceWithStream(_.describeMaintenanceWindowTasks(request))
  def describeMaintenanceWindowTasksPaginated(
      request: zio.aws.ssm.model.DescribeMaintenanceWindowTasksRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.DescribeMaintenanceWindowTasksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeMaintenanceWindowTasksPaginated(request))
  def deleteMaintenanceWindow(
      request: zio.aws.ssm.model.DeleteMaintenanceWindowRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.DeleteMaintenanceWindowResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteMaintenanceWindow(request))
  def describePatchGroupState(
      request: zio.aws.ssm.model.DescribePatchGroupStateRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.DescribePatchGroupStateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describePatchGroupState(request))
  def describeParameters(
      request: zio.aws.ssm.model.DescribeParametersRequest
  ): ZStream[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.ParameterMetadata.ReadOnly
  ] = ZStream.serviceWithStream(_.describeParameters(request))
  def describeParametersPaginated(
      request: zio.aws.ssm.model.DescribeParametersRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.DescribeParametersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeParametersPaginated(request))
  def listOpsItemEvents(
      request: zio.aws.ssm.model.ListOpsItemEventsRequest
  ): ZStream[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.OpsItemEventSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listOpsItemEvents(request))
  def listOpsItemEventsPaginated(
      request: zio.aws.ssm.model.ListOpsItemEventsRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.ListOpsItemEventsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listOpsItemEventsPaginated(request))
  def getDocument(request: zio.aws.ssm.model.GetDocumentRequest): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.GetDocumentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDocument(request))
  def createDocument(request: zio.aws.ssm.model.CreateDocumentRequest): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.CreateDocumentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDocument(request))
  def modifyDocumentPermission(
      request: zio.aws.ssm.model.ModifyDocumentPermissionRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.ModifyDocumentPermissionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyDocumentPermission(request))
  def registerTargetWithMaintenanceWindow(
      request: zio.aws.ssm.model.RegisterTargetWithMaintenanceWindowRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.RegisterTargetWithMaintenanceWindowResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.registerTargetWithMaintenanceWindow(request))
  def terminateSession(request: zio.aws.ssm.model.TerminateSessionRequest): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.TerminateSessionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.terminateSession(request))
  def removeTagsFromResource(
      request: zio.aws.ssm.model.RemoveTagsFromResourceRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.RemoveTagsFromResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.removeTagsFromResource(request))
  def startChangeRequestExecution(
      request: zio.aws.ssm.model.StartChangeRequestExecutionRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.StartChangeRequestExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startChangeRequestExecution(request))
  def describeActivations(
      request: zio.aws.ssm.model.DescribeActivationsRequest
  ): ZStream[zio.aws.ssm.Ssm, AwsError, zio.aws.ssm.model.Activation.ReadOnly] =
    ZStream.serviceWithStream(_.describeActivations(request))
  def describeActivationsPaginated(
      request: zio.aws.ssm.model.DescribeActivationsRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.DescribeActivationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeActivationsPaginated(request))
  def sendAutomationSignal(
      request: zio.aws.ssm.model.SendAutomationSignalRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.SendAutomationSignalResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.sendAutomationSignal(request))
  def createMaintenanceWindow(
      request: zio.aws.ssm.model.CreateMaintenanceWindowRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.CreateMaintenanceWindowResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createMaintenanceWindow(request))
  def cancelCommand(request: zio.aws.ssm.model.CancelCommandRequest): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.CancelCommandResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelCommand(request))
  def getMaintenanceWindow(
      request: zio.aws.ssm.model.GetMaintenanceWindowRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.GetMaintenanceWindowResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMaintenanceWindow(request))
  def describeAssociation(
      request: zio.aws.ssm.model.DescribeAssociationRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.DescribeAssociationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAssociation(request))
  def getMaintenanceWindowExecutionTask(
      request: zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMaintenanceWindowExecutionTask(request))
  def labelParameterVersion(
      request: zio.aws.ssm.model.LabelParameterVersionRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.LabelParameterVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.labelParameterVersion(request))
  def describePatchProperties(
      request: zio.aws.ssm.model.DescribePatchPropertiesRequest
  ): ZStream[zio.aws.ssm.Ssm, AwsError, Map[AttributeName, AttributeValue]] =
    ZStream.serviceWithStream(_.describePatchProperties(request))
  def describePatchPropertiesPaginated(
      request: zio.aws.ssm.model.DescribePatchPropertiesRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.DescribePatchPropertiesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describePatchPropertiesPaginated(request))
  def describeMaintenanceWindowSchedule(
      request: zio.aws.ssm.model.DescribeMaintenanceWindowScheduleRequest
  ): ZStream[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.ScheduledWindowExecution.ReadOnly
  ] = ZStream.serviceWithStream(_.describeMaintenanceWindowSchedule(request))
  def describeMaintenanceWindowSchedulePaginated(
      request: zio.aws.ssm.model.DescribeMaintenanceWindowScheduleRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.DescribeMaintenanceWindowScheduleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeMaintenanceWindowSchedulePaginated(request))
  def getDefaultPatchBaseline(
      request: zio.aws.ssm.model.GetDefaultPatchBaselineRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.GetDefaultPatchBaselineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDefaultPatchBaseline(request))
  def updateDocumentMetadata(
      request: zio.aws.ssm.model.UpdateDocumentMetadataRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.UpdateDocumentMetadataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDocumentMetadata(request))
  def deleteAssociation(
      request: zio.aws.ssm.model.DeleteAssociationRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.DeleteAssociationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteAssociation(request))
  def createAssociationBatch(
      request: zio.aws.ssm.model.CreateAssociationBatchRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.CreateAssociationBatchResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAssociationBatch(request))
  def getParameter(request: zio.aws.ssm.model.GetParameterRequest): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.GetParameterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getParameter(request))
  def registerTaskWithMaintenanceWindow(
      request: zio.aws.ssm.model.RegisterTaskWithMaintenanceWindowRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.RegisterTaskWithMaintenanceWindowResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.registerTaskWithMaintenanceWindow(request))
  def listOpsMetadata(
      request: zio.aws.ssm.model.ListOpsMetadataRequest
  ): ZStream[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.OpsMetadata.ReadOnly
  ] = ZStream.serviceWithStream(_.listOpsMetadata(request))
  def listOpsMetadataPaginated(
      request: zio.aws.ssm.model.ListOpsMetadataRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.ListOpsMetadataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listOpsMetadataPaginated(request))
  def registerPatchBaselineForPatchGroup(
      request: zio.aws.ssm.model.RegisterPatchBaselineForPatchGroupRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.RegisterPatchBaselineForPatchGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.registerPatchBaselineForPatchGroup(request))
  def describeInstancePatchStatesForPatchGroup(
      request: zio.aws.ssm.model.DescribeInstancePatchStatesForPatchGroupRequest
  ): ZStream[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.InstancePatchState.ReadOnly
  ] = ZStream.serviceWithStream(
    _.describeInstancePatchStatesForPatchGroup(request)
  )
  def describeInstancePatchStatesForPatchGroupPaginated(
      request: zio.aws.ssm.model.DescribeInstancePatchStatesForPatchGroupRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.DescribeInstancePatchStatesForPatchGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.describeInstancePatchStatesForPatchGroupPaginated(request)
  )
  def listDocuments(request: zio.aws.ssm.model.ListDocumentsRequest): ZStream[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.DocumentIdentifier.ReadOnly
  ] = ZStream.serviceWithStream(_.listDocuments(request))
  def listDocumentsPaginated(
      request: zio.aws.ssm.model.ListDocumentsRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.ListDocumentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDocumentsPaginated(request))
  def getPatchBaseline(request: zio.aws.ssm.model.GetPatchBaselineRequest): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.GetPatchBaselineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPatchBaseline(request))
  def updateMaintenanceWindowTarget(
      request: zio.aws.ssm.model.UpdateMaintenanceWindowTargetRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.UpdateMaintenanceWindowTargetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateMaintenanceWindowTarget(request))
  def startAutomationExecution(
      request: zio.aws.ssm.model.StartAutomationExecutionRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.StartAutomationExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startAutomationExecution(request))
  def sendCommand(request: zio.aws.ssm.model.SendCommandRequest): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.SendCommandResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.sendCommand(request))
  def getInventory(request: zio.aws.ssm.model.GetInventoryRequest): ZStream[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.InventoryResultEntity.ReadOnly
  ] = ZStream.serviceWithStream(_.getInventory(request))
  def getInventoryPaginated(
      request: zio.aws.ssm.model.GetInventoryRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.GetInventoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getInventoryPaginated(request))
  def updateServiceSetting(
      request: zio.aws.ssm.model.UpdateServiceSettingRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.UpdateServiceSettingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateServiceSetting(request))
  def getConnectionStatus(
      request: zio.aws.ssm.model.GetConnectionStatusRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.GetConnectionStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getConnectionStatus(request))
  def describeAutomationExecutions(
      request: zio.aws.ssm.model.DescribeAutomationExecutionsRequest
  ): ZStream[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.AutomationExecutionMetadata.ReadOnly
  ] = ZStream.serviceWithStream(_.describeAutomationExecutions(request))
  def describeAutomationExecutionsPaginated(
      request: zio.aws.ssm.model.DescribeAutomationExecutionsRequest
  ): ZIO[zio.aws.ssm.Ssm, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.describeAutomationExecutionsPaginated(request))
  def resumeSession(request: zio.aws.ssm.model.ResumeSessionRequest): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.ResumeSessionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.resumeSession(request))
  def listResourceComplianceSummaries(
      request: zio.aws.ssm.model.ListResourceComplianceSummariesRequest
  ): ZStream[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.ResourceComplianceSummaryItem.ReadOnly
  ] = ZStream.serviceWithStream(_.listResourceComplianceSummaries(request))
  def listResourceComplianceSummariesPaginated(
      request: zio.aws.ssm.model.ListResourceComplianceSummariesRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.ListResourceComplianceSummariesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listResourceComplianceSummariesPaginated(request))
  def createPatchBaseline(
      request: zio.aws.ssm.model.CreatePatchBaselineRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.CreatePatchBaselineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPatchBaseline(request))
  def getOpsItem(request: zio.aws.ssm.model.GetOpsItemRequest): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.GetOpsItemResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getOpsItem(request))
  def getPatchBaselineForPatchGroup(
      request: zio.aws.ssm.model.GetPatchBaselineForPatchGroupRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.GetPatchBaselineForPatchGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPatchBaselineForPatchGroup(request))
  def createAssociation(
      request: zio.aws.ssm.model.CreateAssociationRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.CreateAssociationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAssociation(request))
  def listAssociations(
      request: zio.aws.ssm.model.ListAssociationsRequest
  ): ZStream[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.Association.ReadOnly
  ] = ZStream.serviceWithStream(_.listAssociations(request))
  def listAssociationsPaginated(
      request: zio.aws.ssm.model.ListAssociationsRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.ListAssociationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAssociationsPaginated(request))
  def updateDocument(request: zio.aws.ssm.model.UpdateDocumentRequest): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.UpdateDocumentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDocument(request))
  def putInventory(request: zio.aws.ssm.model.PutInventoryRequest): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.PutInventoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putInventory(request))
  def updateMaintenanceWindow(
      request: zio.aws.ssm.model.UpdateMaintenanceWindowRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.UpdateMaintenanceWindowResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateMaintenanceWindow(request))
  def updateDocumentDefaultVersion(
      request: zio.aws.ssm.model.UpdateDocumentDefaultVersionRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.UpdateDocumentDefaultVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDocumentDefaultVersion(request))
  def getMaintenanceWindowTask(
      request: zio.aws.ssm.model.GetMaintenanceWindowTaskRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.GetMaintenanceWindowTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMaintenanceWindowTask(request))
  def describeAssociationExecutionTargets(
      request: zio.aws.ssm.model.DescribeAssociationExecutionTargetsRequest
  ): ZStream[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.AssociationExecutionTarget.ReadOnly
  ] = ZStream.serviceWithStream(_.describeAssociationExecutionTargets(request))
  def describeAssociationExecutionTargetsPaginated(
      request: zio.aws.ssm.model.DescribeAssociationExecutionTargetsRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.DescribeAssociationExecutionTargetsResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.describeAssociationExecutionTargetsPaginated(request))
  def createOpsItem(request: zio.aws.ssm.model.CreateOpsItemRequest): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.CreateOpsItemResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createOpsItem(request))
  def listCommands(
      request: zio.aws.ssm.model.ListCommandsRequest
  ): ZStream[zio.aws.ssm.Ssm, AwsError, zio.aws.ssm.model.Command.ReadOnly] =
    ZStream.serviceWithStream(_.listCommands(request))
  def listCommandsPaginated(
      request: zio.aws.ssm.model.ListCommandsRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.ListCommandsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listCommandsPaginated(request))
  def getAutomationExecution(
      request: zio.aws.ssm.model.GetAutomationExecutionRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.GetAutomationExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAutomationExecution(request))
  def describeMaintenanceWindowExecutionTasks(
      request: zio.aws.ssm.model.DescribeMaintenanceWindowExecutionTasksRequest
  ): ZStream[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.MaintenanceWindowExecutionTaskIdentity.ReadOnly
  ] = ZStream.serviceWithStream(
    _.describeMaintenanceWindowExecutionTasks(request)
  )
  def describeMaintenanceWindowExecutionTasksPaginated(
      request: zio.aws.ssm.model.DescribeMaintenanceWindowExecutionTasksRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.DescribeMaintenanceWindowExecutionTasksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.describeMaintenanceWindowExecutionTasksPaginated(request)
  )
  def listDocumentVersions(
      request: zio.aws.ssm.model.ListDocumentVersionsRequest
  ): ZStream[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.DocumentVersionInfo.ReadOnly
  ] = ZStream.serviceWithStream(_.listDocumentVersions(request))
  def listDocumentVersionsPaginated(
      request: zio.aws.ssm.model.ListDocumentVersionsRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.ListDocumentVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDocumentVersionsPaginated(request))
  def getOpsSummary(
      request: zio.aws.ssm.model.GetOpsSummaryRequest
  ): ZStream[zio.aws.ssm.Ssm, AwsError, zio.aws.ssm.model.OpsEntity.ReadOnly] =
    ZStream.serviceWithStream(_.getOpsSummary(request))
  def getOpsSummaryPaginated(
      request: zio.aws.ssm.model.GetOpsSummaryRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.GetOpsSummaryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getOpsSummaryPaginated(request))
  def describeDocument(request: zio.aws.ssm.model.DescribeDocumentRequest): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.DescribeDocumentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDocument(request))
  def describePatchGroups(
      request: zio.aws.ssm.model.DescribePatchGroupsRequest
  ): ZStream[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.PatchGroupPatchBaselineMapping.ReadOnly
  ] = ZStream.serviceWithStream(_.describePatchGroups(request))
  def describePatchGroupsPaginated(
      request: zio.aws.ssm.model.DescribePatchGroupsRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.DescribePatchGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describePatchGroupsPaginated(request))
  def startAssociationsOnce(
      request: zio.aws.ssm.model.StartAssociationsOnceRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.StartAssociationsOnceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startAssociationsOnce(request))
  def describeMaintenanceWindowTargets(
      request: zio.aws.ssm.model.DescribeMaintenanceWindowTargetsRequest
  ): ZStream[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.MaintenanceWindowTarget.ReadOnly
  ] = ZStream.serviceWithStream(_.describeMaintenanceWindowTargets(request))
  def describeMaintenanceWindowTargetsPaginated(
      request: zio.aws.ssm.model.DescribeMaintenanceWindowTargetsRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.DescribeMaintenanceWindowTargetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeMaintenanceWindowTargetsPaginated(request))
  def updateManagedInstanceRole(
      request: zio.aws.ssm.model.UpdateManagedInstanceRoleRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.UpdateManagedInstanceRoleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateManagedInstanceRole(request))
  def describeInstanceInformation(
      request: zio.aws.ssm.model.DescribeInstanceInformationRequest
  ): ZStream[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.InstanceInformation.ReadOnly
  ] = ZStream.serviceWithStream(_.describeInstanceInformation(request))
  def describeInstanceInformationPaginated(
      request: zio.aws.ssm.model.DescribeInstanceInformationRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.DescribeInstanceInformationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeInstanceInformationPaginated(request))
  def updateMaintenanceWindowTask(
      request: zio.aws.ssm.model.UpdateMaintenanceWindowTaskRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.UpdateMaintenanceWindowTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateMaintenanceWindowTask(request))
  def describeMaintenanceWindows(
      request: zio.aws.ssm.model.DescribeMaintenanceWindowsRequest
  ): ZStream[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.MaintenanceWindowIdentity.ReadOnly
  ] = ZStream.serviceWithStream(_.describeMaintenanceWindows(request))
  def describeMaintenanceWindowsPaginated(
      request: zio.aws.ssm.model.DescribeMaintenanceWindowsRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.DescribeMaintenanceWindowsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeMaintenanceWindowsPaginated(request))
  def getServiceSetting(
      request: zio.aws.ssm.model.GetServiceSettingRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.GetServiceSettingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getServiceSetting(request))
  def registerDefaultPatchBaseline(
      request: zio.aws.ssm.model.RegisterDefaultPatchBaselineRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.RegisterDefaultPatchBaselineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.registerDefaultPatchBaseline(request))
  def listDocumentMetadataHistory(
      request: zio.aws.ssm.model.ListDocumentMetadataHistoryRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.ListDocumentMetadataHistoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDocumentMetadataHistory(request))
  def getParametersByPath(
      request: zio.aws.ssm.model.GetParametersByPathRequest
  ): ZStream[zio.aws.ssm.Ssm, AwsError, zio.aws.ssm.model.Parameter.ReadOnly] =
    ZStream.serviceWithStream(_.getParametersByPath(request))
  def getParametersByPathPaginated(
      request: zio.aws.ssm.model.GetParametersByPathRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.GetParametersByPathResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getParametersByPathPaginated(request))
  def cancelMaintenanceWindowExecution(
      request: zio.aws.ssm.model.CancelMaintenanceWindowExecutionRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.CancelMaintenanceWindowExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelMaintenanceWindowExecution(request))
  def listTagsForResource(
      request: zio.aws.ssm.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def describeMaintenanceWindowExecutionTaskInvocations(
      request: zio.aws.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsRequest
  ): ZStream[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.MaintenanceWindowExecutionTaskInvocationIdentity.ReadOnly
  ] = ZStream.serviceWithStream(
    _.describeMaintenanceWindowExecutionTaskInvocations(request)
  )
  def describeMaintenanceWindowExecutionTaskInvocationsPaginated(
      request: zio.aws.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.describeMaintenanceWindowExecutionTaskInvocationsPaginated(request)
  )
  def updateAssociation(
      request: zio.aws.ssm.model.UpdateAssociationRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.UpdateAssociationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateAssociation(request))
  def startSession(request: zio.aws.ssm.model.StartSessionRequest): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.StartSessionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startSession(request))
  def associateOpsItemRelatedItem(
      request: zio.aws.ssm.model.AssociateOpsItemRelatedItemRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.AssociateOpsItemRelatedItemResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateOpsItemRelatedItem(request))
  def disassociateOpsItemRelatedItem(
      request: zio.aws.ssm.model.DisassociateOpsItemRelatedItemRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.DisassociateOpsItemRelatedItemResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateOpsItemRelatedItem(request))
  def describeOpsItems(
      request: zio.aws.ssm.model.DescribeOpsItemsRequest
  ): ZStream[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.OpsItemSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.describeOpsItems(request))
  def describeOpsItemsPaginated(
      request: zio.aws.ssm.model.DescribeOpsItemsRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.DescribeOpsItemsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeOpsItemsPaginated(request))
  def describeEffectiveInstanceAssociations(
      request: zio.aws.ssm.model.DescribeEffectiveInstanceAssociationsRequest
  ): ZStream[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.InstanceAssociation.ReadOnly
  ] =
    ZStream.serviceWithStream(_.describeEffectiveInstanceAssociations(request))
  def describeEffectiveInstanceAssociationsPaginated(
      request: zio.aws.ssm.model.DescribeEffectiveInstanceAssociationsRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.DescribeEffectiveInstanceAssociationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.describeEffectiveInstanceAssociationsPaginated(request)
  )
  def listAssociationVersions(
      request: zio.aws.ssm.model.ListAssociationVersionsRequest
  ): ZStream[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.AssociationVersionInfo.ReadOnly
  ] = ZStream.serviceWithStream(_.listAssociationVersions(request))
  def listAssociationVersionsPaginated(
      request: zio.aws.ssm.model.ListAssociationVersionsRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.ListAssociationVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAssociationVersionsPaginated(request))
  def describeInstancePatches(
      request: zio.aws.ssm.model.DescribeInstancePatchesRequest
  ): ZStream[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.PatchComplianceData.ReadOnly
  ] = ZStream.serviceWithStream(_.describeInstancePatches(request))
  def describeInstancePatchesPaginated(
      request: zio.aws.ssm.model.DescribeInstancePatchesRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.DescribeInstancePatchesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeInstancePatchesPaginated(request))
  def getDeployablePatchSnapshotForInstance(
      request: zio.aws.ssm.model.GetDeployablePatchSnapshotForInstanceRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.GetDeployablePatchSnapshotForInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDeployablePatchSnapshotForInstance(request))
  def putComplianceItems(
      request: zio.aws.ssm.model.PutComplianceItemsRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.PutComplianceItemsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putComplianceItems(request))
  def deleteActivation(request: zio.aws.ssm.model.DeleteActivationRequest): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.DeleteActivationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteActivation(request))
  def listOpsItemRelatedItems(
      request: zio.aws.ssm.model.ListOpsItemRelatedItemsRequest
  ): ZStream[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.OpsItemRelatedItemSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listOpsItemRelatedItems(request))
  def listOpsItemRelatedItemsPaginated(
      request: zio.aws.ssm.model.ListOpsItemRelatedItemsRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.ListOpsItemRelatedItemsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listOpsItemRelatedItemsPaginated(request))
  def deleteParameter(request: zio.aws.ssm.model.DeleteParameterRequest): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.DeleteParameterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteParameter(request))
  def describeInventoryDeletions(
      request: zio.aws.ssm.model.DescribeInventoryDeletionsRequest
  ): ZStream[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.InventoryDeletionStatusItem.ReadOnly
  ] = ZStream.serviceWithStream(_.describeInventoryDeletions(request))
  def describeInventoryDeletionsPaginated(
      request: zio.aws.ssm.model.DescribeInventoryDeletionsRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.DescribeInventoryDeletionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeInventoryDeletionsPaginated(request))
  def getCommandInvocation(
      request: zio.aws.ssm.model.GetCommandInvocationRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.GetCommandInvocationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCommandInvocation(request))
  def updateAssociationStatus(
      request: zio.aws.ssm.model.UpdateAssociationStatusRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.UpdateAssociationStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateAssociationStatus(request))
  def updateOpsMetadata(
      request: zio.aws.ssm.model.UpdateOpsMetadataRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.UpdateOpsMetadataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateOpsMetadata(request))
  def describePatchBaselines(
      request: zio.aws.ssm.model.DescribePatchBaselinesRequest
  ): ZStream[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.PatchBaselineIdentity.ReadOnly
  ] = ZStream.serviceWithStream(_.describePatchBaselines(request))
  def describePatchBaselinesPaginated(
      request: zio.aws.ssm.model.DescribePatchBaselinesRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.DescribePatchBaselinesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describePatchBaselinesPaginated(request))
  def describeEffectivePatchesForPatchBaseline(
      request: zio.aws.ssm.model.DescribeEffectivePatchesForPatchBaselineRequest
  ): ZStream[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.EffectivePatch.ReadOnly
  ] = ZStream.serviceWithStream(
    _.describeEffectivePatchesForPatchBaseline(request)
  )
  def describeEffectivePatchesForPatchBaselinePaginated(
      request: zio.aws.ssm.model.DescribeEffectivePatchesForPatchBaselineRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.DescribeEffectivePatchesForPatchBaselineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.describeEffectivePatchesForPatchBaselinePaginated(request)
  )
  def createActivation(request: zio.aws.ssm.model.CreateActivationRequest): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.CreateActivationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createActivation(request))
  def getMaintenanceWindowExecution(
      request: zio.aws.ssm.model.GetMaintenanceWindowExecutionRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.GetMaintenanceWindowExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMaintenanceWindowExecution(request))
  def deregisterTaskFromMaintenanceWindow(
      request: zio.aws.ssm.model.DeregisterTaskFromMaintenanceWindowRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.DeregisterTaskFromMaintenanceWindowResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deregisterTaskFromMaintenanceWindow(request))
  def deleteDocument(request: zio.aws.ssm.model.DeleteDocumentRequest): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.DeleteDocumentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDocument(request))
  def createResourceDataSync(
      request: zio.aws.ssm.model.CreateResourceDataSyncRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.CreateResourceDataSyncResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createResourceDataSync(request))
  def getMaintenanceWindowExecutionTaskInvocation(
      request: zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskInvocationRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskInvocationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMaintenanceWindowExecutionTaskInvocation(request))
  def deregisterManagedInstance(
      request: zio.aws.ssm.model.DeregisterManagedInstanceRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.DeregisterManagedInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deregisterManagedInstance(request))
  def updateOpsItem(request: zio.aws.ssm.model.UpdateOpsItemRequest): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.UpdateOpsItemResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateOpsItem(request))
  def deleteOpsMetadata(
      request: zio.aws.ssm.model.DeleteOpsMetadataRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.DeleteOpsMetadataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteOpsMetadata(request))
  def describeAvailablePatches(
      request: zio.aws.ssm.model.DescribeAvailablePatchesRequest
  ): ZStream[zio.aws.ssm.Ssm, AwsError, zio.aws.ssm.model.Patch.ReadOnly] =
    ZStream.serviceWithStream(_.describeAvailablePatches(request))
  def describeAvailablePatchesPaginated(
      request: zio.aws.ssm.model.DescribeAvailablePatchesRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.DescribeAvailablePatchesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAvailablePatchesPaginated(request))
  def listComplianceSummaries(
      request: zio.aws.ssm.model.ListComplianceSummariesRequest
  ): ZStream[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.ComplianceSummaryItem.ReadOnly
  ] = ZStream.serviceWithStream(_.listComplianceSummaries(request))
  def listComplianceSummariesPaginated(
      request: zio.aws.ssm.model.ListComplianceSummariesRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.ListComplianceSummariesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listComplianceSummariesPaginated(request))
  def deletePatchBaseline(
      request: zio.aws.ssm.model.DeletePatchBaselineRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.DeletePatchBaselineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deletePatchBaseline(request))
  def createOpsMetadata(
      request: zio.aws.ssm.model.CreateOpsMetadataRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.CreateOpsMetadataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createOpsMetadata(request))
  def deregisterTargetFromMaintenanceWindow(
      request: zio.aws.ssm.model.DeregisterTargetFromMaintenanceWindowRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.DeregisterTargetFromMaintenanceWindowResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deregisterTargetFromMaintenanceWindow(request))
  def putParameter(request: zio.aws.ssm.model.PutParameterRequest): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.PutParameterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putParameter(request))
  def describeDocumentPermission(
      request: zio.aws.ssm.model.DescribeDocumentPermissionRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.DescribeDocumentPermissionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDocumentPermission(request))
  def resetServiceSetting(
      request: zio.aws.ssm.model.ResetServiceSettingRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.ResetServiceSettingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.resetServiceSetting(request))
  def updateResourceDataSync(
      request: zio.aws.ssm.model.UpdateResourceDataSyncRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.UpdateResourceDataSyncResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateResourceDataSync(request))
  def unlabelParameterVersion(
      request: zio.aws.ssm.model.UnlabelParameterVersionRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.UnlabelParameterVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.unlabelParameterVersion(request))
  def getInventorySchema(
      request: zio.aws.ssm.model.GetInventorySchemaRequest
  ): ZStream[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.InventoryItemSchema.ReadOnly
  ] = ZStream.serviceWithStream(_.getInventorySchema(request))
  def getInventorySchemaPaginated(
      request: zio.aws.ssm.model.GetInventorySchemaRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.GetInventorySchemaResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getInventorySchemaPaginated(request))
  def getCalendarState(request: zio.aws.ssm.model.GetCalendarStateRequest): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.GetCalendarStateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCalendarState(request))
  def listCommandInvocations(
      request: zio.aws.ssm.model.ListCommandInvocationsRequest
  ): ZStream[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.CommandInvocation.ReadOnly
  ] = ZStream.serviceWithStream(_.listCommandInvocations(request))
  def listCommandInvocationsPaginated(
      request: zio.aws.ssm.model.ListCommandInvocationsRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.ListCommandInvocationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listCommandInvocationsPaginated(request))
  def deleteResourceDataSync(
      request: zio.aws.ssm.model.DeleteResourceDataSyncRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.DeleteResourceDataSyncResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteResourceDataSync(request))
  def updatePatchBaseline(
      request: zio.aws.ssm.model.UpdatePatchBaselineRequest
  ): ZIO[
    zio.aws.ssm.Ssm,
    AwsError,
    zio.aws.ssm.model.UpdatePatchBaselineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updatePatchBaseline(request))
}
