package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.MaintenanceWindowTaskId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RegisterTaskWithMaintenanceWindowResponse(
    windowTaskId: Option[MaintenanceWindowTaskId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.RegisterTaskWithMaintenanceWindowResponse = {
    import RegisterTaskWithMaintenanceWindowResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.RegisterTaskWithMaintenanceWindowResponse
      .builder()
      .optionallyWith(
        windowTaskId.map(value =>
          MaintenanceWindowTaskId.unwrap(value): java.lang.String
        )
      )(_.windowTaskId)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.RegisterTaskWithMaintenanceWindowResponse.ReadOnly =
    zio.aws.ssm.model.RegisterTaskWithMaintenanceWindowResponse
      .wrap(buildAwsValue())
}
object RegisterTaskWithMaintenanceWindowResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.RegisterTaskWithMaintenanceWindowResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssm.model.RegisterTaskWithMaintenanceWindowResponse =
      zio.aws.ssm.model.RegisterTaskWithMaintenanceWindowResponse(
        windowTaskId.map(value => value)
      )
    def windowTaskId: Option[MaintenanceWindowTaskId]
    def getWindowTaskId: ZIO[Any, AwsError, MaintenanceWindowTaskId] =
      AwsError.unwrapOptionField("windowTaskId", windowTaskId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.RegisterTaskWithMaintenanceWindowResponse
  ) extends zio.aws.ssm.model.RegisterTaskWithMaintenanceWindowResponse.ReadOnly {
    override val windowTaskId: Option[MaintenanceWindowTaskId] = scala
      .Option(impl.windowTaskId())
      .map(value => zio.aws.ssm.model.primitives.MaintenanceWindowTaskId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.RegisterTaskWithMaintenanceWindowResponse
  ): zio.aws.ssm.model.RegisterTaskWithMaintenanceWindowResponse.ReadOnly =
    new Wrapper(impl)
}
