package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  PatchKbNumber,
  DateTime,
  PatchSeverity,
  PatchTitle,
  PatchClassification,
  PatchCVEIds
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class PatchComplianceData(
    title: PatchTitle,
    kbId: PatchKbNumber,
    classification: PatchClassification,
    severity: PatchSeverity,
    state: zio.aws.ssm.model.PatchComplianceDataState,
    installedTime: DateTime,
    cveIds: Option[PatchCVEIds] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.PatchComplianceData = {
    import PatchComplianceData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.PatchComplianceData
      .builder()
      .title(PatchTitle.unwrap(title): java.lang.String)
      .kbId(PatchKbNumber.unwrap(kbId): java.lang.String)
      .classification(
        PatchClassification.unwrap(classification): java.lang.String
      )
      .severity(PatchSeverity.unwrap(severity): java.lang.String)
      .state(state.unwrap)
      .installedTime(DateTime.unwrap(installedTime): Instant)
      .optionallyWith(
        cveIds.map(value => PatchCVEIds.unwrap(value): java.lang.String)
      )(_.cveIds)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.PatchComplianceData.ReadOnly =
    zio.aws.ssm.model.PatchComplianceData.wrap(buildAwsValue())
}
object PatchComplianceData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.PatchComplianceData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.PatchComplianceData =
      zio.aws.ssm.model.PatchComplianceData(
        title,
        kbId,
        classification,
        severity,
        state,
        installedTime,
        cveIds.map(value => value)
      )
    def title: PatchTitle
    def kbId: PatchKbNumber
    def classification: PatchClassification
    def severity: PatchSeverity
    def state: zio.aws.ssm.model.PatchComplianceDataState
    def installedTime: DateTime
    def cveIds: Option[PatchCVEIds]
    def getTitle: ZIO[Any, Nothing, PatchTitle] = ZIO.succeed(title)
    def getKbId: ZIO[Any, Nothing, PatchKbNumber] = ZIO.succeed(kbId)
    def getClassification: ZIO[Any, Nothing, PatchClassification] =
      ZIO.succeed(classification)
    def getSeverity: ZIO[Any, Nothing, PatchSeverity] = ZIO.succeed(severity)
    def getState
        : ZIO[Any, Nothing, zio.aws.ssm.model.PatchComplianceDataState] =
      ZIO.succeed(state)
    def getInstalledTime: ZIO[Any, Nothing, DateTime] =
      ZIO.succeed(installedTime)
    def getCveIds: ZIO[Any, AwsError, PatchCVEIds] =
      AwsError.unwrapOptionField("cveIds", cveIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.PatchComplianceData
  ) extends zio.aws.ssm.model.PatchComplianceData.ReadOnly {
    override val title: PatchTitle =
      zio.aws.ssm.model.primitives.PatchTitle(impl.title())
    override val kbId: PatchKbNumber =
      zio.aws.ssm.model.primitives.PatchKbNumber(impl.kbId())
    override val classification: PatchClassification =
      zio.aws.ssm.model.primitives.PatchClassification(impl.classification())
    override val severity: PatchSeverity =
      zio.aws.ssm.model.primitives.PatchSeverity(impl.severity())
    override val state: zio.aws.ssm.model.PatchComplianceDataState =
      zio.aws.ssm.model.PatchComplianceDataState.wrap(impl.state())
    override val installedTime: DateTime =
      zio.aws.ssm.model.primitives.DateTime(impl.installedTime())
    override val cveIds: Option[PatchCVEIds] = scala
      .Option(impl.cveIds())
      .map(value => zio.aws.ssm.model.primitives.PatchCVEIds(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.PatchComplianceData
  ): zio.aws.ssm.model.PatchComplianceData.ReadOnly = new Wrapper(impl)
}
