package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{NextToken, MaxResults}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListDocumentsRequest(
    documentFilterList: Option[Iterable[zio.aws.ssm.model.DocumentFilter]] =
      None,
    filters: Option[Iterable[zio.aws.ssm.model.DocumentKeyValuesFilter]] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ListDocumentsRequest = {
    import ListDocumentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ListDocumentsRequest
      .builder()
      .optionallyWith(
        documentFilterList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.documentFilterList)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ListDocumentsRequest.ReadOnly =
    zio.aws.ssm.model.ListDocumentsRequest.wrap(buildAwsValue())
}
object ListDocumentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ListDocumentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ListDocumentsRequest =
      zio.aws.ssm.model.ListDocumentsRequest(
        documentFilterList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def documentFilterList
        : Option[List[zio.aws.ssm.model.DocumentFilter.ReadOnly]]
    def filters
        : Option[List[zio.aws.ssm.model.DocumentKeyValuesFilter.ReadOnly]]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getDocumentFilterList
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.DocumentFilter.ReadOnly]] =
      AwsError.unwrapOptionField("documentFilterList", documentFilterList)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.DocumentKeyValuesFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ListDocumentsRequest
  ) extends zio.aws.ssm.model.ListDocumentsRequest.ReadOnly {
    override val documentFilterList
        : Option[List[zio.aws.ssm.model.DocumentFilter.ReadOnly]] = scala
      .Option(impl.documentFilterList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.DocumentFilter.wrap(item)
        }.toList
      )
    override val filters
        : Option[List[zio.aws.ssm.model.DocumentKeyValuesFilter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.DocumentKeyValuesFilter.wrap(item)
          }.toList
        )
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ssm.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ListDocumentsRequest
  ): zio.aws.ssm.model.ListDocumentsRequest.ReadOnly = new Wrapper(impl)
}
