package zio.aws.ssm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InstanceAssociationOutputLocation(
    s3Location: Option[zio.aws.ssm.model.S3OutputLocation] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.InstanceAssociationOutputLocation = {
    import InstanceAssociationOutputLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.InstanceAssociationOutputLocation
      .builder()
      .optionallyWith(s3Location.map(value => value.buildAwsValue()))(
        _.s3Location
      )
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.InstanceAssociationOutputLocation.ReadOnly =
    zio.aws.ssm.model.InstanceAssociationOutputLocation.wrap(buildAwsValue())
}
object InstanceAssociationOutputLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.InstanceAssociationOutputLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.InstanceAssociationOutputLocation =
      zio.aws.ssm.model.InstanceAssociationOutputLocation(
        s3Location.map(value => value.asEditable)
      )
    def s3Location: Option[zio.aws.ssm.model.S3OutputLocation.ReadOnly]
    def getS3Location
        : ZIO[Any, AwsError, zio.aws.ssm.model.S3OutputLocation.ReadOnly] =
      AwsError.unwrapOptionField("s3Location", s3Location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.InstanceAssociationOutputLocation
  ) extends zio.aws.ssm.model.InstanceAssociationOutputLocation.ReadOnly {
    override val s3Location
        : Option[zio.aws.ssm.model.S3OutputLocation.ReadOnly] = scala
      .Option(impl.s3Location())
      .map(value => zio.aws.ssm.model.S3OutputLocation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.InstanceAssociationOutputLocation
  ): zio.aws.ssm.model.InstanceAssociationOutputLocation.ReadOnly = new Wrapper(
    impl
  )
}
