package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  NextToken,
  MetadataKey,
  OpsMetadataResourceId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetOpsMetadataResponse(
    resourceId: Option[OpsMetadataResourceId] = None,
    metadata: Option[Map[MetadataKey, zio.aws.ssm.model.MetadataValue]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetOpsMetadataResponse = {
    import GetOpsMetadataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetOpsMetadataResponse
      .builder()
      .optionallyWith(
        resourceId.map(value =>
          OpsMetadataResourceId.unwrap(value): java.lang.String
        )
      )(_.resourceId)
      .optionallyWith(
        metadata.map(value =>
          value
            .map({ case (key, value) =>
              (MetadataKey.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.metadata)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.GetOpsMetadataResponse.ReadOnly =
    zio.aws.ssm.model.GetOpsMetadataResponse.wrap(buildAwsValue())
}
object GetOpsMetadataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetOpsMetadataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.GetOpsMetadataResponse =
      zio.aws.ssm.model.GetOpsMetadataResponse(
        resourceId.map(value => value),
        metadata.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        nextToken.map(value => value)
      )
    def resourceId: Option[OpsMetadataResourceId]
    def metadata
        : Option[Map[MetadataKey, zio.aws.ssm.model.MetadataValue.ReadOnly]]
    def nextToken: Option[NextToken]
    def getResourceId: ZIO[Any, AwsError, OpsMetadataResourceId] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getMetadata: ZIO[Any, AwsError, Map[
      MetadataKey,
      zio.aws.ssm.model.MetadataValue.ReadOnly
    ]] = AwsError.unwrapOptionField("metadata", metadata)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetOpsMetadataResponse
  ) extends zio.aws.ssm.model.GetOpsMetadataResponse.ReadOnly {
    override val resourceId: Option[OpsMetadataResourceId] = scala
      .Option(impl.resourceId())
      .map(value => zio.aws.ssm.model.primitives.OpsMetadataResourceId(value))
    override val metadata
        : Option[Map[MetadataKey, zio.aws.ssm.model.MetadataValue.ReadOnly]] =
      scala
        .Option(impl.metadata())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.ssm.model.primitives
                .MetadataKey(key) -> zio.aws.ssm.model.MetadataValue.wrap(value)
            })
            .toMap
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetOpsMetadataResponse
  ): zio.aws.ssm.model.GetOpsMetadataResponse.ReadOnly = new Wrapper(impl)
}
