package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  NextToken,
  GetOpsMetadataMaxResults,
  OpsMetadataArn
}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetOpsMetadataRequest(
    opsMetadataArn: OpsMetadataArn,
    maxResults: Option[GetOpsMetadataMaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetOpsMetadataRequest = {
    import GetOpsMetadataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetOpsMetadataRequest
      .builder()
      .opsMetadataArn(OpsMetadataArn.unwrap(opsMetadataArn): java.lang.String)
      .optionallyWith(
        maxResults.map(value => GetOpsMetadataMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.GetOpsMetadataRequest.ReadOnly =
    zio.aws.ssm.model.GetOpsMetadataRequest.wrap(buildAwsValue())
}
object GetOpsMetadataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetOpsMetadataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.GetOpsMetadataRequest =
      zio.aws.ssm.model.GetOpsMetadataRequest(
        opsMetadataArn,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def opsMetadataArn: OpsMetadataArn
    def maxResults: Option[GetOpsMetadataMaxResults]
    def nextToken: Option[NextToken]
    def getOpsMetadataArn: ZIO[Any, Nothing, OpsMetadataArn] =
      ZIO.succeed(opsMetadataArn)
    def getMaxResults: ZIO[Any, AwsError, GetOpsMetadataMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetOpsMetadataRequest
  ) extends zio.aws.ssm.model.GetOpsMetadataRequest.ReadOnly {
    override val opsMetadataArn: OpsMetadataArn =
      zio.aws.ssm.model.primitives.OpsMetadataArn(impl.opsMetadataArn())
    override val maxResults: Option[GetOpsMetadataMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.ssm.model.primitives.GetOpsMetadataMaxResults(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetOpsMetadataRequest
  ): zio.aws.ssm.model.GetOpsMetadataRequest.ReadOnly = new Wrapper(impl)
}
