package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  GetInventorySchemaMaxResults,
  NextToken,
  AggregatorSchemaOnly,
  IsSubTypeSchema,
  InventoryItemTypeNameFilter
}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetInventorySchemaRequest(
    typeName: Option[InventoryItemTypeNameFilter] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[GetInventorySchemaMaxResults] = None,
    aggregator: Option[AggregatorSchemaOnly] = None,
    subType: Option[IsSubTypeSchema] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetInventorySchemaRequest = {
    import GetInventorySchemaRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetInventorySchemaRequest
      .builder()
      .optionallyWith(
        typeName.map(value =>
          InventoryItemTypeNameFilter.unwrap(value): java.lang.String
        )
      )(_.typeName)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          GetInventorySchemaMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        aggregator.map(value =>
          AggregatorSchemaOnly.unwrap(value): java.lang.Boolean
        )
      )(_.aggregator)
      .optionallyWith(
        subType.map(value => IsSubTypeSchema.unwrap(value): java.lang.Boolean)
      )(_.subType)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.GetInventorySchemaRequest.ReadOnly =
    zio.aws.ssm.model.GetInventorySchemaRequest.wrap(buildAwsValue())
}
object GetInventorySchemaRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetInventorySchemaRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.GetInventorySchemaRequest =
      zio.aws.ssm.model.GetInventorySchemaRequest(
        typeName.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        aggregator.map(value => value),
        subType.map(value => value)
      )
    def typeName: Option[InventoryItemTypeNameFilter]
    def nextToken: Option[NextToken]
    def maxResults: Option[GetInventorySchemaMaxResults]
    def aggregator: Option[AggregatorSchemaOnly]
    def subType: Option[IsSubTypeSchema]
    def getTypeName: ZIO[Any, AwsError, InventoryItemTypeNameFilter] =
      AwsError.unwrapOptionField("typeName", typeName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, GetInventorySchemaMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getAggregator: ZIO[Any, AwsError, AggregatorSchemaOnly] =
      AwsError.unwrapOptionField("aggregator", aggregator)
    def getSubType: ZIO[Any, AwsError, IsSubTypeSchema] =
      AwsError.unwrapOptionField("subType", subType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetInventorySchemaRequest
  ) extends zio.aws.ssm.model.GetInventorySchemaRequest.ReadOnly {
    override val typeName: Option[InventoryItemTypeNameFilter] = scala
      .Option(impl.typeName())
      .map(value =>
        zio.aws.ssm.model.primitives.InventoryItemTypeNameFilter(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
    override val maxResults: Option[GetInventorySchemaMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.ssm.model.primitives.GetInventorySchemaMaxResults(value)
      )
    override val aggregator: Option[AggregatorSchemaOnly] = scala
      .Option(impl.aggregator())
      .map(value => zio.aws.ssm.model.primitives.AggregatorSchemaOnly(value))
    override val subType: Option[IsSubTypeSchema] = scala
      .Option(impl.subType())
      .map(value => zio.aws.ssm.model.primitives.IsSubTypeSchema(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetInventorySchemaRequest
  ): zio.aws.ssm.model.GetInventorySchemaRequest.ReadOnly = new Wrapper(impl)
}
