package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  NextToken,
  PatchBaselineMaxResults,
  BaselineId
}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeEffectivePatchesForPatchBaselineRequest(
    baselineId: BaselineId,
    maxResults: Option[PatchBaselineMaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineRequest = {
    import DescribeEffectivePatchesForPatchBaselineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineRequest
      .builder()
      .baselineId(BaselineId.unwrap(baselineId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => PatchBaselineMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.DescribeEffectivePatchesForPatchBaselineRequest.ReadOnly =
    zio.aws.ssm.model.DescribeEffectivePatchesForPatchBaselineRequest
      .wrap(buildAwsValue())
}
object DescribeEffectivePatchesForPatchBaselineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssm.model.DescribeEffectivePatchesForPatchBaselineRequest =
      zio.aws.ssm.model.DescribeEffectivePatchesForPatchBaselineRequest(
        baselineId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def baselineId: BaselineId
    def maxResults: Option[PatchBaselineMaxResults]
    def nextToken: Option[NextToken]
    def getBaselineId: ZIO[Any, Nothing, BaselineId] = ZIO.succeed(baselineId)
    def getMaxResults: ZIO[Any, AwsError, PatchBaselineMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineRequest
  ) extends zio.aws.ssm.model.DescribeEffectivePatchesForPatchBaselineRequest.ReadOnly {
    override val baselineId: BaselineId =
      zio.aws.ssm.model.primitives.BaselineId(impl.baselineId())
    override val maxResults: Option[PatchBaselineMaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ssm.model.primitives.PatchBaselineMaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineRequest
  ): zio.aws.ssm.model.DescribeEffectivePatchesForPatchBaselineRequest.ReadOnly =
    new Wrapper(impl)
}
