package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.AutomationExecutionFilterValue
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AutomationExecutionFilter(
    key: zio.aws.ssm.model.AutomationExecutionFilterKey,
    values: Iterable[AutomationExecutionFilterValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.AutomationExecutionFilter = {
    import AutomationExecutionFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.AutomationExecutionFilter
      .builder()
      .key(key.unwrap)
      .values(values.map { item =>
        AutomationExecutionFilterValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.AutomationExecutionFilter.ReadOnly =
    zio.aws.ssm.model.AutomationExecutionFilter.wrap(buildAwsValue())
}
object AutomationExecutionFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.AutomationExecutionFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.AutomationExecutionFilter =
      zio.aws.ssm.model.AutomationExecutionFilter(key, values)
    def key: zio.aws.ssm.model.AutomationExecutionFilterKey
    def values: List[AutomationExecutionFilterValue]
    def getKey
        : ZIO[Any, Nothing, zio.aws.ssm.model.AutomationExecutionFilterKey] =
      ZIO.succeed(key)
    def getValues: ZIO[Any, Nothing, List[AutomationExecutionFilterValue]] =
      ZIO.succeed(values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.AutomationExecutionFilter
  ) extends zio.aws.ssm.model.AutomationExecutionFilter.ReadOnly {
    override val key: zio.aws.ssm.model.AutomationExecutionFilterKey =
      zio.aws.ssm.model.AutomationExecutionFilterKey.wrap(impl.key())
    override val values: List[AutomationExecutionFilterValue] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.ssm.model.primitives.AutomationExecutionFilterValue(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.AutomationExecutionFilter
  ): zio.aws.ssm.model.AutomationExecutionFilter.ReadOnly = new Wrapper(impl)
}
