package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  AssociationId,
  StatusName,
  AssociationExecutionId,
  ResourceCountByStatus,
  DateTime,
  AssociationVersion
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class AssociationExecution(
    associationId: Option[AssociationId] = None,
    associationVersion: Option[AssociationVersion] = None,
    executionId: Option[AssociationExecutionId] = None,
    status: Option[StatusName] = None,
    detailedStatus: Option[StatusName] = None,
    createdTime: Option[DateTime] = None,
    lastExecutionDate: Option[DateTime] = None,
    resourceCountByStatus: Option[ResourceCountByStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.AssociationExecution = {
    import AssociationExecution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.AssociationExecution
      .builder()
      .optionallyWith(
        associationId.map(value =>
          AssociationId.unwrap(value): java.lang.String
        )
      )(_.associationId)
      .optionallyWith(
        associationVersion.map(value =>
          AssociationVersion.unwrap(value): java.lang.String
        )
      )(_.associationVersion)
      .optionallyWith(
        executionId.map(value =>
          AssociationExecutionId.unwrap(value): java.lang.String
        )
      )(_.executionId)
      .optionallyWith(
        status.map(value => StatusName.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        detailedStatus.map(value => StatusName.unwrap(value): java.lang.String)
      )(_.detailedStatus)
      .optionallyWith(
        createdTime.map(value => DateTime.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        lastExecutionDate.map(value => DateTime.unwrap(value): Instant)
      )(_.lastExecutionDate)
      .optionallyWith(
        resourceCountByStatus.map(value =>
          ResourceCountByStatus.unwrap(value): java.lang.String
        )
      )(_.resourceCountByStatus)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.AssociationExecution.ReadOnly =
    zio.aws.ssm.model.AssociationExecution.wrap(buildAwsValue())
}
object AssociationExecution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.AssociationExecution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.AssociationExecution =
      zio.aws.ssm.model.AssociationExecution(
        associationId.map(value => value),
        associationVersion.map(value => value),
        executionId.map(value => value),
        status.map(value => value),
        detailedStatus.map(value => value),
        createdTime.map(value => value),
        lastExecutionDate.map(value => value),
        resourceCountByStatus.map(value => value)
      )
    def associationId: Option[AssociationId]
    def associationVersion: Option[AssociationVersion]
    def executionId: Option[AssociationExecutionId]
    def status: Option[StatusName]
    def detailedStatus: Option[StatusName]
    def createdTime: Option[DateTime]
    def lastExecutionDate: Option[DateTime]
    def resourceCountByStatus: Option[ResourceCountByStatus]
    def getAssociationId: ZIO[Any, AwsError, AssociationId] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getAssociationVersion: ZIO[Any, AwsError, AssociationVersion] =
      AwsError.unwrapOptionField("associationVersion", associationVersion)
    def getExecutionId: ZIO[Any, AwsError, AssociationExecutionId] =
      AwsError.unwrapOptionField("executionId", executionId)
    def getStatus: ZIO[Any, AwsError, StatusName] =
      AwsError.unwrapOptionField("status", status)
    def getDetailedStatus: ZIO[Any, AwsError, StatusName] =
      AwsError.unwrapOptionField("detailedStatus", detailedStatus)
    def getCreatedTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getLastExecutionDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastExecutionDate", lastExecutionDate)
    def getResourceCountByStatus: ZIO[Any, AwsError, ResourceCountByStatus] =
      AwsError.unwrapOptionField("resourceCountByStatus", resourceCountByStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.AssociationExecution
  ) extends zio.aws.ssm.model.AssociationExecution.ReadOnly {
    override val associationId: Option[AssociationId] = scala
      .Option(impl.associationId())
      .map(value => zio.aws.ssm.model.primitives.AssociationId(value))
    override val associationVersion: Option[AssociationVersion] = scala
      .Option(impl.associationVersion())
      .map(value => zio.aws.ssm.model.primitives.AssociationVersion(value))
    override val executionId: Option[AssociationExecutionId] = scala
      .Option(impl.executionId())
      .map(value => zio.aws.ssm.model.primitives.AssociationExecutionId(value))
    override val status: Option[StatusName] = scala
      .Option(impl.status())
      .map(value => zio.aws.ssm.model.primitives.StatusName(value))
    override val detailedStatus: Option[StatusName] = scala
      .Option(impl.detailedStatus())
      .map(value => zio.aws.ssm.model.primitives.StatusName(value))
    override val createdTime: Option[DateTime] = scala
      .Option(impl.createdTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val lastExecutionDate: Option[DateTime] = scala
      .Option(impl.lastExecutionDate())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val resourceCountByStatus: Option[ResourceCountByStatus] = scala
      .Option(impl.resourceCountByStatus())
      .map(value => zio.aws.ssm.model.primitives.ResourceCountByStatus(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.AssociationExecution
  ): zio.aws.ssm.model.AssociationExecution.ReadOnly = new Wrapper(impl)
}
