package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  MaintenanceWindowFilterValue,
  MaintenanceWindowFilterKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MaintenanceWindowFilter(
    key: Option[MaintenanceWindowFilterKey] = None,
    values: Option[Iterable[MaintenanceWindowFilterValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.MaintenanceWindowFilter = {
    import MaintenanceWindowFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.MaintenanceWindowFilter
      .builder()
      .optionallyWith(
        key.map(value =>
          MaintenanceWindowFilterKey.unwrap(value): java.lang.String
        )
      )(_.key)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            MaintenanceWindowFilterValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.MaintenanceWindowFilter.ReadOnly =
    zio.aws.ssm.model.MaintenanceWindowFilter.wrap(buildAwsValue())
}
object MaintenanceWindowFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.MaintenanceWindowFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.MaintenanceWindowFilter =
      zio.aws.ssm.model.MaintenanceWindowFilter(
        key.map(value => value),
        values.map(value => value)
      )
    def key: Option[MaintenanceWindowFilterKey]
    def values: Option[List[MaintenanceWindowFilterValue]]
    def getKey: ZIO[Any, AwsError, MaintenanceWindowFilterKey] =
      AwsError.unwrapOptionField("key", key)
    def getValues: ZIO[Any, AwsError, List[MaintenanceWindowFilterValue]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.MaintenanceWindowFilter
  ) extends zio.aws.ssm.model.MaintenanceWindowFilter.ReadOnly {
    override val key: Option[MaintenanceWindowFilterKey] = scala
      .Option(impl.key())
      .map(value =>
        zio.aws.ssm.model.primitives.MaintenanceWindowFilterKey(value)
      )
    override val values: Option[List[MaintenanceWindowFilterValue]] = scala
      .Option(impl.values())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.primitives.MaintenanceWindowFilterValue(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.MaintenanceWindowFilter
  ): zio.aws.ssm.model.MaintenanceWindowFilter.ReadOnly = new Wrapper(impl)
}
