package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.InventoryItemAttributeName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class InventoryItemAttribute(
    name: InventoryItemAttributeName,
    dataType: zio.aws.ssm.model.InventoryAttributeDataType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.InventoryItemAttribute = {
    import InventoryItemAttribute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.InventoryItemAttribute
      .builder()
      .name(InventoryItemAttributeName.unwrap(name): java.lang.String)
      .dataType(dataType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.InventoryItemAttribute.ReadOnly =
    zio.aws.ssm.model.InventoryItemAttribute.wrap(buildAwsValue())
}
object InventoryItemAttribute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.InventoryItemAttribute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.InventoryItemAttribute =
      zio.aws.ssm.model.InventoryItemAttribute(name, dataType)
    def name: InventoryItemAttributeName
    def dataType: zio.aws.ssm.model.InventoryAttributeDataType
    def getName: ZIO[Any, Nothing, InventoryItemAttributeName] =
      ZIO.succeed(name)
    def getDataType
        : ZIO[Any, Nothing, zio.aws.ssm.model.InventoryAttributeDataType] =
      ZIO.succeed(dataType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.InventoryItemAttribute
  ) extends zio.aws.ssm.model.InventoryItemAttribute.ReadOnly {
    override val name: InventoryItemAttributeName =
      zio.aws.ssm.model.primitives.InventoryItemAttributeName(impl.name())
    override val dataType: zio.aws.ssm.model.InventoryAttributeDataType =
      zio.aws.ssm.model.InventoryAttributeDataType.wrap(impl.dataType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.InventoryItemAttribute
  ): zio.aws.ssm.model.InventoryItemAttribute.ReadOnly = new Wrapper(impl)
}
