package zio.aws.ssm.model
import scala.jdk.CollectionConverters._
sealed trait DocumentFormat {
  def unwrap: software.amazon.awssdk.services.ssm.model.DocumentFormat
}
object DocumentFormat {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.DocumentFormat
  ): zio.aws.ssm.model.DocumentFormat = value match {
    case software.amazon.awssdk.services.ssm.model.DocumentFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.DocumentFormat.YAML =>
      val r = YAML
      r
    case software.amazon.awssdk.services.ssm.model.DocumentFormat.JSON =>
      val r = JSON
      r
    case software.amazon.awssdk.services.ssm.model.DocumentFormat.TEXT =>
      val r = TEXT
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssm.model.DocumentFormat {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DocumentFormat =
      software.amazon.awssdk.services.ssm.model.DocumentFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object YAML extends zio.aws.ssm.model.DocumentFormat {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DocumentFormat =
      software.amazon.awssdk.services.ssm.model.DocumentFormat.YAML
  }
  case object JSON extends zio.aws.ssm.model.DocumentFormat {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DocumentFormat =
      software.amazon.awssdk.services.ssm.model.DocumentFormat.JSON
  }
  case object TEXT extends zio.aws.ssm.model.DocumentFormat {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DocumentFormat =
      software.amazon.awssdk.services.ssm.model.DocumentFormat.TEXT
  }
}
