package zio.aws.ssm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateAssociationStatusResponse(
    associationDescription: Option[zio.aws.ssm.model.AssociationDescription] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.UpdateAssociationStatusResponse = {
    import UpdateAssociationStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.UpdateAssociationStatusResponse
      .builder()
      .optionallyWith(
        associationDescription.map(value => value.buildAwsValue())
      )(_.associationDescription)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.UpdateAssociationStatusResponse.ReadOnly =
    zio.aws.ssm.model.UpdateAssociationStatusResponse.wrap(buildAwsValue())
}
object UpdateAssociationStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.UpdateAssociationStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.UpdateAssociationStatusResponse =
      zio.aws.ssm.model.UpdateAssociationStatusResponse(
        associationDescription.map(value => value.asEditable)
      )
    def associationDescription
        : Option[zio.aws.ssm.model.AssociationDescription.ReadOnly]
    def getAssociationDescription: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.AssociationDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "associationDescription",
      associationDescription
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.UpdateAssociationStatusResponse
  ) extends zio.aws.ssm.model.UpdateAssociationStatusResponse.ReadOnly {
    override val associationDescription
        : Option[zio.aws.ssm.model.AssociationDescription.ReadOnly] = scala
      .Option(impl.associationDescription())
      .map(value => zio.aws.ssm.model.AssociationDescription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.UpdateAssociationStatusResponse
  ): zio.aws.ssm.model.UpdateAssociationStatusResponse.ReadOnly = new Wrapper(
    impl
  )
}
