package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  AssociationId,
  StatusName,
  DocumentARN,
  InstanceId,
  AgentErrorCode,
  AssociationName,
  DocumentVersion,
  DateTime,
  AssociationVersion,
  InstanceAssociationExecutionSummary
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class InstanceAssociationStatusInfo(
    associationId: Option[AssociationId] = None,
    name: Option[DocumentARN] = None,
    documentVersion: Option[DocumentVersion] = None,
    associationVersion: Option[AssociationVersion] = None,
    instanceId: Option[InstanceId] = None,
    executionDate: Option[DateTime] = None,
    status: Option[StatusName] = None,
    detailedStatus: Option[StatusName] = None,
    executionSummary: Option[InstanceAssociationExecutionSummary] = None,
    errorCode: Option[AgentErrorCode] = None,
    outputUrl: Option[zio.aws.ssm.model.InstanceAssociationOutputUrl] = None,
    associationName: Option[AssociationName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.InstanceAssociationStatusInfo = {
    import InstanceAssociationStatusInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.InstanceAssociationStatusInfo
      .builder()
      .optionallyWith(
        associationId.map(value =>
          AssociationId.unwrap(value): java.lang.String
        )
      )(_.associationId)
      .optionallyWith(
        name.map(value => DocumentARN.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        documentVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.documentVersion)
      .optionallyWith(
        associationVersion.map(value =>
          AssociationVersion.unwrap(value): java.lang.String
        )
      )(_.associationVersion)
      .optionallyWith(
        instanceId.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.instanceId)
      .optionallyWith(
        executionDate.map(value => DateTime.unwrap(value): Instant)
      )(_.executionDate)
      .optionallyWith(
        status.map(value => StatusName.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        detailedStatus.map(value => StatusName.unwrap(value): java.lang.String)
      )(_.detailedStatus)
      .optionallyWith(
        executionSummary.map(value =>
          InstanceAssociationExecutionSummary.unwrap(value): java.lang.String
        )
      )(_.executionSummary)
      .optionallyWith(
        errorCode.map(value => AgentErrorCode.unwrap(value): java.lang.String)
      )(_.errorCode)
      .optionallyWith(outputUrl.map(value => value.buildAwsValue()))(
        _.outputUrl
      )
      .optionallyWith(
        associationName.map(value =>
          AssociationName.unwrap(value): java.lang.String
        )
      )(_.associationName)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.InstanceAssociationStatusInfo.ReadOnly =
    zio.aws.ssm.model.InstanceAssociationStatusInfo.wrap(buildAwsValue())
}
object InstanceAssociationStatusInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.InstanceAssociationStatusInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.InstanceAssociationStatusInfo =
      zio.aws.ssm.model.InstanceAssociationStatusInfo(
        associationId.map(value => value),
        name.map(value => value),
        documentVersion.map(value => value),
        associationVersion.map(value => value),
        instanceId.map(value => value),
        executionDate.map(value => value),
        status.map(value => value),
        detailedStatus.map(value => value),
        executionSummary.map(value => value),
        errorCode.map(value => value),
        outputUrl.map(value => value.asEditable),
        associationName.map(value => value)
      )
    def associationId: Option[AssociationId]
    def name: Option[DocumentARN]
    def documentVersion: Option[DocumentVersion]
    def associationVersion: Option[AssociationVersion]
    def instanceId: Option[InstanceId]
    def executionDate: Option[DateTime]
    def status: Option[StatusName]
    def detailedStatus: Option[StatusName]
    def executionSummary: Option[InstanceAssociationExecutionSummary]
    def errorCode: Option[AgentErrorCode]
    def outputUrl
        : Option[zio.aws.ssm.model.InstanceAssociationOutputUrl.ReadOnly]
    def associationName: Option[AssociationName]
    def getAssociationId: ZIO[Any, AwsError, AssociationId] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getName: ZIO[Any, AwsError, DocumentARN] =
      AwsError.unwrapOptionField("name", name)
    def getDocumentVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("documentVersion", documentVersion)
    def getAssociationVersion: ZIO[Any, AwsError, AssociationVersion] =
      AwsError.unwrapOptionField("associationVersion", associationVersion)
    def getInstanceId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getExecutionDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("executionDate", executionDate)
    def getStatus: ZIO[Any, AwsError, StatusName] =
      AwsError.unwrapOptionField("status", status)
    def getDetailedStatus: ZIO[Any, AwsError, StatusName] =
      AwsError.unwrapOptionField("detailedStatus", detailedStatus)
    def getExecutionSummary
        : ZIO[Any, AwsError, InstanceAssociationExecutionSummary] =
      AwsError.unwrapOptionField("executionSummary", executionSummary)
    def getErrorCode: ZIO[Any, AwsError, AgentErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getOutputUrl: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.InstanceAssociationOutputUrl.ReadOnly
    ] = AwsError.unwrapOptionField("outputUrl", outputUrl)
    def getAssociationName: ZIO[Any, AwsError, AssociationName] =
      AwsError.unwrapOptionField("associationName", associationName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.InstanceAssociationStatusInfo
  ) extends zio.aws.ssm.model.InstanceAssociationStatusInfo.ReadOnly {
    override val associationId: Option[AssociationId] = scala
      .Option(impl.associationId())
      .map(value => zio.aws.ssm.model.primitives.AssociationId(value))
    override val name: Option[DocumentARN] = scala
      .Option(impl.name())
      .map(value => zio.aws.ssm.model.primitives.DocumentARN(value))
    override val documentVersion: Option[DocumentVersion] = scala
      .Option(impl.documentVersion())
      .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
    override val associationVersion: Option[AssociationVersion] = scala
      .Option(impl.associationVersion())
      .map(value => zio.aws.ssm.model.primitives.AssociationVersion(value))
    override val instanceId: Option[InstanceId] = scala
      .Option(impl.instanceId())
      .map(value => zio.aws.ssm.model.primitives.InstanceId(value))
    override val executionDate: Option[DateTime] = scala
      .Option(impl.executionDate())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val status: Option[StatusName] = scala
      .Option(impl.status())
      .map(value => zio.aws.ssm.model.primitives.StatusName(value))
    override val detailedStatus: Option[StatusName] = scala
      .Option(impl.detailedStatus())
      .map(value => zio.aws.ssm.model.primitives.StatusName(value))
    override val executionSummary: Option[InstanceAssociationExecutionSummary] =
      scala
        .Option(impl.executionSummary())
        .map(value =>
          zio.aws.ssm.model.primitives
            .InstanceAssociationExecutionSummary(value)
        )
    override val errorCode: Option[AgentErrorCode] = scala
      .Option(impl.errorCode())
      .map(value => zio.aws.ssm.model.primitives.AgentErrorCode(value))
    override val outputUrl
        : Option[zio.aws.ssm.model.InstanceAssociationOutputUrl.ReadOnly] =
      scala
        .Option(impl.outputUrl())
        .map(value =>
          zio.aws.ssm.model.InstanceAssociationOutputUrl.wrap(value)
        )
    override val associationName: Option[AssociationName] = scala
      .Option(impl.associationName())
      .map(value => zio.aws.ssm.model.primitives.AssociationName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.InstanceAssociationStatusInfo
  ): zio.aws.ssm.model.InstanceAssociationStatusInfo.ReadOnly = new Wrapper(
    impl
  )
}
