package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.PSParameterName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetParameterRequest(
    name: PSParameterName,
    withDecryption: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetParameterRequest = {
    import GetParameterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetParameterRequest
      .builder()
      .name(PSParameterName.unwrap(name): java.lang.String)
      .optionallyWith(withDecryption.map(value => value: java.lang.Boolean))(
        _.withDecryption
      )
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.GetParameterRequest.ReadOnly =
    zio.aws.ssm.model.GetParameterRequest.wrap(buildAwsValue())
}
object GetParameterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetParameterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.GetParameterRequest = zio.aws.ssm.model
      .GetParameterRequest(name, withDecryption.map(value => value))
    def name: PSParameterName
    def withDecryption: Option[Boolean]
    def getName: ZIO[Any, Nothing, PSParameterName] = ZIO.succeed(name)
    def getWithDecryption: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("withDecryption", withDecryption)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetParameterRequest
  ) extends zio.aws.ssm.model.GetParameterRequest.ReadOnly {
    override val name: PSParameterName =
      zio.aws.ssm.model.primitives.PSParameterName(impl.name())
    override val withDecryption: Option[Boolean] =
      scala.Option(impl.withDecryption()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetParameterRequest
  ): zio.aws.ssm.model.GetParameterRequest.ReadOnly = new Wrapper(impl)
}
