package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{NextToken, MaxResults, InstanceId}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeInstanceAssociationsStatusRequest(
    instanceId: InstanceId,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeInstanceAssociationsStatusRequest = {
    import DescribeInstanceAssociationsStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeInstanceAssociationsStatusRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.DescribeInstanceAssociationsStatusRequest.ReadOnly =
    zio.aws.ssm.model.DescribeInstanceAssociationsStatusRequest
      .wrap(buildAwsValue())
}
object DescribeInstanceAssociationsStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeInstanceAssociationsStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssm.model.DescribeInstanceAssociationsStatusRequest =
      zio.aws.ssm.model.DescribeInstanceAssociationsStatusRequest(
        instanceId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def instanceId: InstanceId
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeInstanceAssociationsStatusRequest
  ) extends zio.aws.ssm.model.DescribeInstanceAssociationsStatusRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.ssm.model.primitives.InstanceId(impl.instanceId())
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ssm.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeInstanceAssociationsStatusRequest
  ): zio.aws.ssm.model.DescribeInstanceAssociationsStatusRequest.ReadOnly =
    new Wrapper(impl)
}
