package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeActivationsResponse(
    activationList: Option[Iterable[zio.aws.ssm.model.Activation]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeActivationsResponse = {
    import DescribeActivationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeActivationsResponse
      .builder()
      .optionallyWith(
        activationList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.activationList)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DescribeActivationsResponse.ReadOnly =
    zio.aws.ssm.model.DescribeActivationsResponse.wrap(buildAwsValue())
}
object DescribeActivationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeActivationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DescribeActivationsResponse =
      zio.aws.ssm.model.DescribeActivationsResponse(
        activationList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def activationList: Option[List[zio.aws.ssm.model.Activation.ReadOnly]]
    def nextToken: Option[NextToken]
    def getActivationList
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.Activation.ReadOnly]] =
      AwsError.unwrapOptionField("activationList", activationList)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeActivationsResponse
  ) extends zio.aws.ssm.model.DescribeActivationsResponse.ReadOnly {
    override val activationList
        : Option[List[zio.aws.ssm.model.Activation.ReadOnly]] = scala
      .Option(impl.activationList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.Activation.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeActivationsResponse
  ): zio.aws.ssm.model.DescribeActivationsResponse.ReadOnly = new Wrapper(impl)
}
