package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  MaintenanceWindowTargetId,
  MaintenanceWindowId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeregisterTargetFromMaintenanceWindowResponse(
    windowId: Option[MaintenanceWindowId] = None,
    windowTargetId: Option[MaintenanceWindowTargetId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DeregisterTargetFromMaintenanceWindowResponse = {
    import DeregisterTargetFromMaintenanceWindowResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DeregisterTargetFromMaintenanceWindowResponse
      .builder()
      .optionallyWith(
        windowId.map(value =>
          MaintenanceWindowId.unwrap(value): java.lang.String
        )
      )(_.windowId)
      .optionallyWith(
        windowTargetId.map(value =>
          MaintenanceWindowTargetId.unwrap(value): java.lang.String
        )
      )(_.windowTargetId)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.DeregisterTargetFromMaintenanceWindowResponse.ReadOnly =
    zio.aws.ssm.model.DeregisterTargetFromMaintenanceWindowResponse
      .wrap(buildAwsValue())
}
object DeregisterTargetFromMaintenanceWindowResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DeregisterTargetFromMaintenanceWindowResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssm.model.DeregisterTargetFromMaintenanceWindowResponse =
      zio.aws.ssm.model.DeregisterTargetFromMaintenanceWindowResponse(
        windowId.map(value => value),
        windowTargetId.map(value => value)
      )
    def windowId: Option[MaintenanceWindowId]
    def windowTargetId: Option[MaintenanceWindowTargetId]
    def getWindowId: ZIO[Any, AwsError, MaintenanceWindowId] =
      AwsError.unwrapOptionField("windowId", windowId)
    def getWindowTargetId: ZIO[Any, AwsError, MaintenanceWindowTargetId] =
      AwsError.unwrapOptionField("windowTargetId", windowTargetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DeregisterTargetFromMaintenanceWindowResponse
  ) extends zio.aws.ssm.model.DeregisterTargetFromMaintenanceWindowResponse.ReadOnly {
    override val windowId: Option[MaintenanceWindowId] = scala
      .Option(impl.windowId())
      .map(value => zio.aws.ssm.model.primitives.MaintenanceWindowId(value))
    override val windowTargetId: Option[MaintenanceWindowTargetId] = scala
      .Option(impl.windowTargetId())
      .map(value =>
        zio.aws.ssm.model.primitives.MaintenanceWindowTargetId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DeregisterTargetFromMaintenanceWindowResponse
  ): zio.aws.ssm.model.DeregisterTargetFromMaintenanceWindowResponse.ReadOnly =
    new Wrapper(impl)
}
